/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.recipe;

import net.jacobwasbeast.picaxe.ModRecipes;
import net.jacobwasbeast.picaxe.items.ImageBannerItem;
import net.jacobwasbeast.picaxe.items.ImageShieldItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ImageShieldDecorationRecipe
extends CustomRecipe {
    public ImageShieldDecorationRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput recipeInput, Level level) {
        ItemStack shieldStack = ItemStack.EMPTY;
        ItemStack bannerStack = ItemStack.EMPTY;
        for (int i = 0; i < recipeInput.size(); ++i) {
            ItemStack currentStack = recipeInput.getItem(i);
            if (currentStack.isEmpty()) continue;
            if (currentStack.getItem() instanceof ImageBannerItem) {
                if (!bannerStack.isEmpty()) {
                    return false;
                }
                bannerStack = currentStack;
                continue;
            }
            if (!(currentStack.getItem() instanceof ShieldItem)) continue;
            if (!shieldStack.isEmpty()) {
                return false;
            }
            shieldStack = currentStack;
        }
        return !shieldStack.isEmpty() && !bannerStack.isEmpty();
    }

    public ItemStack assemble(CraftingInput recipeInput, HolderLookup.Provider registries) {
        ItemStack bannerStack = ItemStack.EMPTY;
        for (int i = 0; i < recipeInput.size(); ++i) {
            ItemStack currentStack = recipeInput.getItem(i);
            if (currentStack.isEmpty() || !(currentStack.getItem() instanceof ImageBannerItem)) continue;
            bannerStack = currentStack;
            break;
        }
        if (bannerStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return ImageShieldItem.createFromBanner(bannerStack);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.IMAGE_SHIELD_RECIPE_SERIALIZER.get();
    }
}

