/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.gui;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.jacobwasbeast.picaxe.blocks.entities.ImageFrameBlockEntity;
import net.jacobwasbeast.picaxe.network.UpdateImageFramePayload;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ImageFrameConfigScreen
extends class_437 {
    private final ImageFrameBlockEntity blockEntity;
    private class_342 urlInput;
    private class_342 widthInput;
    private class_342 heightInput;
    private class_4185 stretchButton;
    private boolean shouldStretch;
    private String urlValue;
    private String widthValue;
    private String heightValue;

    public ImageFrameConfigScreen(ImageFrameBlockEntity be) {
        super((class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.title"));
        this.blockEntity = be;
        this.shouldStretch = be.shouldStretchToFit();
        this.urlValue = be.getImageUrl();
        this.widthValue = String.valueOf(be.getFrameWidth());
        this.heightValue = String.valueOf(be.getFrameHeight());
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        this.urlInput = new class_342(this.field_22793, centerX - 150, centerY - 60, 300, 20, (class_2561)class_2561.method_43471((String)"picaxe.screen.url_input.url"));
        this.urlInput.method_1880(256);
        this.urlInput.method_1852(this.urlValue);
        this.method_25429((class_364)this.urlInput);
        this.method_48265((class_364)this.urlInput);
        this.widthInput = new class_342(this.field_22793, centerX - 105, centerY - 20, 100, 20, (class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.width"));
        this.widthInput.method_1852(this.widthValue);
        this.method_25429((class_364)this.widthInput);
        this.heightInput = new class_342(this.field_22793, centerX + 5, centerY - 20, 100, 20, (class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.height"));
        this.heightInput.method_1852(this.heightValue);
        this.method_25429((class_364)this.heightInput);
        this.stretchButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)this.getStretchButtonText(), button -> {
            this.shouldStretch = !this.shouldStretch;
            button.method_25355(this.getStretchButtonText());
        }).method_46434(centerX - 100, centerY + 10, 200, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"picaxe.screen.url_input.confirm"), button -> {
            try {
                int width = Integer.parseInt(this.widthInput.method_1882());
                int height = Integer.parseInt(this.heightInput.method_1882());
                String url = this.urlInput.method_1882();
                class_2338 pos = this.blockEntity.method_11016();
                class_2540 buf = new class_2540(Unpooled.buffer());
                UpdateImageFramePayload payload = new UpdateImageFramePayload(pos, url, width, height, this.shouldStretch);
                payload.write(buf);
                NetworkManager.sendToServer((class_2960)UpdateImageFramePayload.TYPE, (class_2540)buf);
                this.field_22787.method_1507(null);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).method_46434(centerX - 100, centerY + 40, 98, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"picaxe.screen.url_input.cancel"), button -> this.field_22787.method_1507(null)).method_46434(centerX + 2, centerY + 40, 98, 20).method_46431());
    }

    private class_2561 getStretchButtonText() {
        class_5250 state = this.shouldStretch ? class_2561.method_43471((String)"picaxe.screen.image_frame.stretch_on") : class_2561.method_43471((String)"picaxe.screen.image_frame.stretch_off");
        return class_2561.method_43469((String)"picaxe.screen.image_frame.stretch_mode", (Object[])new Object[]{state});
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        this.urlValue = this.urlInput.method_1882();
        this.widthValue = this.widthInput.method_1882();
        this.heightValue = this.heightInput.method_1882();
        this.method_25423(minecraft, width, height);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        int labelYOffset = this.field_22790 / 2;
        guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.url_label"), this.field_22789 / 2, labelYOffset - 75, 0xA0A0A0);
        guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.width_label"), this.field_22789 / 2 - 55, labelYOffset - 35, 0xA0A0A0);
        guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.height_label"), this.field_22789 / 2 + 55, labelYOffset - 35, 0xA0A0A0);
        this.urlInput.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.widthInput.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.heightInput.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25421() {
        return false;
    }
}

