/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.utils;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RasterFormatException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.w3c.dom.NodeList;

public class ImageUtils {
    private static final class_310 mc = class_310.method_1551();
    private static final int MAX_LOAD_TRIES = 3;
    private static final HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(10L)).build();
    private static final ExecutorService executor = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors()));
    private static final Set<String> blacklist = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Set<String> loading = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Map<String, SoftReference<byte[]>> rawDataCache = new ConcurrentHashMap<String, SoftReference<byte[]>>();
    private static final Map<String, class_2960> cachedTextures = new ConcurrentHashMap<String, class_2960>();
    private static final Map<String, AnimatedTexture> cachedAnimatedTextures = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Map<String, class_2960> cachedSideTopper = new ConcurrentHashMap<String, class_2960>();
    private static final Map<String, AnimatedTexture> cachedAnimatedSideTopper = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Map<String, class_2960> cachedSideDrapeLeft = new ConcurrentHashMap<String, class_2960>();
    private static final Map<String, AnimatedTexture> cachedAnimatedSideDrapeLeft = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Map<String, class_2960> cachedSideDrapeRight = new ConcurrentHashMap<String, class_2960>();
    private static final Map<String, AnimatedTexture> cachedAnimatedSideDrapeRight = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Set<String> pendingSideTransforms = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Map<String, class_2960> cachedFrontBackTopper = new ConcurrentHashMap<String, class_2960>();
    private static final Map<String, AnimatedTexture> cachedAnimatedFrontBackTopper = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Map<String, class_2960> cachedFrontDrape = new ConcurrentHashMap<String, class_2960>();
    private static final Map<String, AnimatedTexture> cachedAnimatedFrontDrape = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Map<String, class_2960> cachedBackDrape = new ConcurrentHashMap<String, class_2960>();
    private static final Map<String, AnimatedTexture> cachedAnimatedBackDrape = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Set<String> pendingFrontBackTransforms = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Map<String, class_2960> cachedSingleFrontDrape = new ConcurrentHashMap<String, class_2960>();
    private static final Map<String, AnimatedTexture> cachedAnimatedSingleFrontDrape = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Map<String, class_2960> cachedSingleTopper = new ConcurrentHashMap<String, class_2960>();
    private static final Map<String, AnimatedTexture> cachedAnimatedSingleTopper = new ConcurrentHashMap<String, AnimatedTexture>();
    private static final Set<String> pendingSingleFrontTransforms = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final class_2960 NOT_FOUND_TEXTURE;
    private static final class_2960 LOADING_TEXTURE;

    private static BufferedImage loadBufferedImageFromResource(String namespace, String path) {
        try {
            class_2960 imageLoc = class_2960.method_43902((String)namespace, (String)path);
            InputStream in = ((class_3298)mc.method_1478().method_14486(imageLoc).get()).method_14482();
            return ImageIO.read(in);
        }
        catch (IOException e) {
            System.err.println("CRITICAL: Failed to load resource image: " + namespace + ":" + path + " - " + e.getMessage());
            return new BufferedImage(16, 16, 2);
        }
    }

    private static String sanitize(String key) {
        return key.toLowerCase().replaceAll("[^a-z0-9._-]", "_");
    }

    private static class_1011 toNativeImage(BufferedImage img) {
        if (img == null) {
            return null;
        }
        int width = img.getWidth();
        int height = img.getHeight();
        BufferedImage convertedImg = img;
        if (img.getType() != 3) {
            convertedImg = new BufferedImage(width, height, 3);
            convertedImg.getGraphics().drawImage(img, 0, 0, null);
        }
        int[] argbPixels = ((DataBufferInt)convertedImg.getRaster().getDataBuffer()).getData();
        class_1011 ni = new class_1011(width, height, false);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = argbPixels[y * width + (width - 1 - x)];
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb & 0xFF;
                int abgr = a << 24 | b << 16 | g << 8 | r;
                ni.method_4305(x, y, abgr);
            }
        }
        return ni;
    }

    public static class_2960 registerTextureFromImage(String key, BufferedImage img, boolean shouldCache) {
        if (img == null) {
            System.err.println("Attempted to register a null image for key: " + key);
            return NOT_FOUND_TEXTURE;
        }
        if (shouldCache && cachedTextures.containsKey(key)) {
            return cachedTextures.get(key);
        }
        try {
            class_1011 ni = ImageUtils.toNativeImage(img);
            if (ni == null) {
                return NOT_FOUND_TEXTURE;
            }
            class_1043 dyn = new class_1043(ni);
            class_2960 loc = mc.method_1531().method_4617("dynamic/" + ImageUtils.sanitize(key), dyn);
            if (shouldCache) {
                cachedTextures.put(key, loc);
            }
            return loc;
        }
        catch (Exception e) {
            System.err.println("Failed to register texture for key: " + key + " \u2013 " + e.getMessage());
            return NOT_FOUND_TEXTURE;
        }
    }

    private static void processUrl(String url) {
        HttpRequest request;
        try {
            request = HttpRequest.newBuilder().uri(URI.create(url)).header("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 10.0; WOW64) AppleWebKit/537.50 (KHTML, like Gecko) Chrome/49.0.1164.162 Safari/536").timeout(Duration.ofSeconds(20L)).build();
        }
        catch (IllegalArgumentException e) {
            System.err.println("Invalid URL, adding to blacklist: " + url);
            blacklist.add(url);
            return;
        }
        for (int i = 1; i <= 3; ++i) {
            try {
                HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
                if (response.statusCode() >= 200 && response.statusCode() < 300) {
                    byte[] imageBytes = response.body();
                    rawDataCache.put(url, new SoftReference<byte[]>(imageBytes));
                    if (ImageUtils.isGif(imageBytes)) {
                        ImageUtils.loadAnimatedGif(url, imageBytes);
                    } else {
                        try (ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);){
                            BufferedImage image = ImageIO.read(is);
                            if (image == null) {
                                throw new IOException("ImageIO.read returned null. Unsupported format or corrupt data.");
                            }
                            mc.execute(() -> ImageUtils.registerTextureFromImage(url, image, true));
                        }
                    }
                    return;
                }
                throw new IOException("HTTP request failed with status code: " + response.statusCode());
            }
            catch (Exception e) {
                System.err.println("Attempt " + i + "/3 failed to load " + url + ": " + e.getMessage());
                if (!(e instanceof InterruptedException)) continue;
                Thread.currentThread().interrupt();
                System.err.println("Image loading interrupted for " + url);
                break;
            }
        }
        System.err.println("Gave up loading image, adding to blacklist: " + url);
        blacklist.add(url);
    }

    private static void loadAnimatedGif(String url, byte[] data) throws IOException {
        int[] delayMillis;
        ArrayList<class_1011> nativeFrames = new ArrayList<class_1011>();
        int totalDuration = 0;
        try (ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(data));){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
            if (!readers.hasNext()) {
                throw new IOException("No GIF ImageReader found");
            }
            ImageReader reader = readers.next();
            reader.setInput(stream);
            int numFrames = reader.getNumImages(true);
            delayMillis = new int[numFrames];
            BufferedImage canvas = null;
            Graphics g = null;
            for (int i = 0; i < numFrames; ++i) {
                BufferedImage frameImage = reader.read(i);
                if (canvas == null) {
                    canvas = new BufferedImage(reader.getWidth(0), reader.getHeight(0), 2);
                    g = canvas.createGraphics();
                    ((Graphics2D)g).setBackground(new Color(0, 0, 0, 0));
                }
                IIOMetadata metadata = reader.getImageMetadata(i);
                IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
                NodeList gces = root.getElementsByTagName("GraphicControlExtension");
                int delay = 10;
                String disposal = "none";
                if (gces.getLength() > 0) {
                    IIOMetadataNode gce = (IIOMetadataNode)gces.item(0);
                    delay = Integer.parseInt(gce.getAttribute("delayTime"));
                    disposal = gce.getAttribute("disposalMethod");
                }
                delayMillis[i] = delay * 10 > 0 ? delay * 10 : 100;
                totalDuration += delayMillis[i];
                IIOMetadataNode imageDescriptor = (IIOMetadataNode)root.getElementsByTagName("ImageDescriptor").item(0);
                int x = Integer.parseInt(imageDescriptor.getAttribute("imageLeftPosition"));
                int y = Integer.parseInt(imageDescriptor.getAttribute("imageTopPosition"));
                g.drawImage(frameImage, x, y, null);
                BufferedImage finalFrame = new BufferedImage(canvas.getWidth(), canvas.getHeight(), 2);
                finalFrame.createGraphics().drawImage((Image)canvas, 0, 0, null);
                nativeFrames.add(ImageUtils.toNativeImage(finalFrame));
                if (!disposal.equals("restoreToBackgroundColor")) continue;
                g.clearRect(x, y, frameImage.getWidth(), frameImage.getHeight());
            }
            if (g != null) {
                g.dispose();
            }
        }
        int[] finalDelays = delayMillis;
        int finalTotalDuration = totalDuration;
        mc.execute(() -> {
            class_2960[] frameLocations = new class_2960[nativeFrames.size()];
            for (int j = 0; j < nativeFrames.size(); ++j) {
                class_1011 ni = (class_1011)nativeFrames.get(j);
                if (ni != null) {
                    class_1043 dyn = new class_1043(ni);
                    frameLocations[j] = mc.method_1531().method_4617("dynamic/" + ImageUtils.sanitize(url + "_frame_" + j), dyn);
                    continue;
                }
                frameLocations[j] = NOT_FOUND_TEXTURE;
            }
            nativeFrames.clear();
            cachedAnimatedTextures.put(url, new AnimatedTexture(frameLocations, finalDelays, finalTotalDuration));
        });
    }

    private static boolean isGif(byte[] bytes) {
        if (bytes == null || bytes.length < 3) {
            return false;
        }
        return bytes[0] == 71 && bytes[1] == 73 && bytes[2] == 70;
    }

    public static class_2960 getOrLoadTexture(String url) {
        if (url == null || url.isEmpty()) {
            return NOT_FOUND_TEXTURE;
        }
        if (cachedAnimatedTextures.containsKey(url)) {
            return cachedAnimatedTextures.get(url).getCurrentFrame();
        }
        if (cachedTextures.containsKey(url)) {
            return cachedTextures.get(url);
        }
        if (blacklist.contains(url)) {
            return NOT_FOUND_TEXTURE;
        }
        if (loading.contains(url)) {
            return LOADING_TEXTURE;
        }
        loading.add(url);
        executor.submit(() -> {
            try {
                ImageUtils.processUrl(url);
            }
            finally {
                loading.remove(url);
            }
        });
        return LOADING_TEXTURE;
    }

    private static byte[] getRawDataFromCache(String url) {
        SoftReference<byte[]> ref = rawDataCache.get(url);
        return ref != null ? ref.get() : null;
    }

    public static void renderImageFromURL(class_4587 ps, class_4597 bufSrc, int packedLight, int packedOverlay, float partialTick, float width, float height, String url) {
        ImageUtils.renderImageFromURL(ps, bufSrc, packedLight, packedOverlay, partialTick, width, height, url, false);
    }

    public static void renderImageFromURL(class_4587 ps, class_4597 bufSrc, int packedLight, int packedOverlay, float partialTick, float width, float height, String url, boolean keepAspectRatio) {
        class_2960 tex = ImageUtils.getOrLoadTexture(url);
        if (tex == null) {
            tex = NOT_FOUND_TEXTURE;
        }
        int uL = packedLight & 0xFFFF;
        int vL = packedLight >> 16 & 0xFFFF;
        int uO = packedOverlay & 0xFFFF;
        int vO = packedOverlay >> 16 & 0xFFFF;
        ps.method_22903();
        ps.method_22904(0.5, 1.01, 0.5);
        ps.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        class_4587.class_4665 p = ps.method_23760();
        class_4588 buf = bufSrc.getBuffer(class_1921.method_23028((class_2960)tex));
        float hw = width / 2.0f;
        float hh = height / 2.0f;
        if (keepAspectRatio) {
            float aspectRatio = width / height;
            if (aspectRatio > 1.0f) {
                hh /= aspectRatio;
            } else {
                hw *= aspectRatio;
            }
        }
        Matrix4f matrix = p.method_23761();
        Vector3f nUp = new Vector3f(0.0f, 1.0f, 0.0f);
        matrix.transformDirection(nUp);
        Vector3f nDown = new Vector3f(0.0f, -1.0f, 0.0f);
        matrix.transformDirection(nDown);
        buf.method_22918(matrix, -hw, -hh, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nUp.x(), nUp.y(), nUp.z()).method_1344();
        buf.method_22918(matrix, hw, -hh, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nUp.x(), nUp.y(), nUp.z()).method_1344();
        buf.method_22918(matrix, hw, hh, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nUp.x(), nUp.y(), nUp.z()).method_1344();
        buf.method_22918(matrix, -hw, hh, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nUp.x(), nUp.y(), nUp.z()).method_1344();
        buf.method_22918(matrix, -hw, hh, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nDown.x(), nDown.y(), nDown.z()).method_1344();
        buf.method_22918(matrix, hw, hh, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nDown.x(), nDown.y(), nDown.z()).method_1344();
        buf.method_22918(matrix, hw, -hh, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nDown.x(), nDown.y(), nDown.z()).method_1344();
        buf.method_22918(matrix, -hw, -hh, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nDown.x(), nDown.y(), nDown.z()).method_1344();
        ps.method_22909();
    }

    public static void renderImageSideDrapesFromURL(class_4587 ps, class_4597 bufSrc, int packedLight, int packedOverlay, float partialTick, float bedWidth, float bedLength, float drapeDepth, String url) {
        class_2960 rightDrapeTex;
        class_2960 leftDrapeTex;
        class_2960 topperTex;
        String key = url + "_split_sides_" + bedWidth + "_" + drapeDepth;
        if (cachedAnimatedSideTopper.containsKey(key)) {
            topperTex = cachedAnimatedSideTopper.get(key).getCurrentFrame();
            leftDrapeTex = cachedAnimatedSideDrapeLeft.get(key).getCurrentFrame();
            rightDrapeTex = cachedAnimatedSideDrapeRight.get(key).getCurrentFrame();
        } else if (cachedSideTopper.containsKey(key)) {
            topperTex = cachedSideTopper.get(key);
            leftDrapeTex = cachedSideDrapeLeft.get(key);
            rightDrapeTex = cachedSideDrapeRight.get(key);
        } else if (pendingSideTransforms.contains(key)) {
            leftDrapeTex = rightDrapeTex = LOADING_TEXTURE;
            topperTex = rightDrapeTex;
        } else {
            leftDrapeTex = rightDrapeTex = ImageUtils.getOrLoadTexture(url);
            topperTex = rightDrapeTex;
            byte[] data = ImageUtils.getRawDataFromCache(url);
            if (data != null) {
                pendingSideTransforms.add(key);
                leftDrapeTex = rightDrapeTex = LOADING_TEXTURE;
                topperTex = rightDrapeTex;
                executor.submit(() -> {
                    block22: {
                        try {
                            int leftW;
                            if (ImageUtils.isGif(data)) {
                                int totalDuration;
                                int[] delays;
                                ArrayList<class_1011> nativeToppers = new ArrayList<class_1011>();
                                ArrayList<class_1011> nativeLefts = new ArrayList<class_1011>();
                                ArrayList<class_1011> nativeRights = new ArrayList<class_1011>();
                                try (ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(data));){
                                    Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
                                    if (!readers.hasNext()) {
                                        throw new IOException("No GIF reader");
                                    }
                                    ImageReader reader = readers.next();
                                    reader.setInput(stream);
                                    int numFrames = reader.getNumImages(true);
                                    delays = new int[numFrames];
                                    int duration = 0;
                                    BufferedImage canvas = null;
                                    Graphics g = null;
                                    for (int i = 0; i < numFrames; ++i) {
                                        BufferedImage frameImage = reader.read(i);
                                        if (canvas == null) {
                                            canvas = new BufferedImage(reader.getWidth(0), reader.getHeight(0), 2);
                                            g = canvas.createGraphics();
                                        }
                                        IIOMetadata metadata = reader.getImageMetadata(i);
                                        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
                                        IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
                                        delays[i] = Integer.parseInt(gce.getAttribute("delayTime")) * 10;
                                        if (delays[i] <= 0) {
                                            delays[i] = 100;
                                        }
                                        duration += delays[i];
                                        String disposal = gce.getAttribute("disposalMethod");
                                        IIOMetadataNode desc = (IIOMetadataNode)root.getElementsByTagName("ImageDescriptor").item(0);
                                        int x = Integer.parseInt(desc.getAttribute("imageLeftPosition"));
                                        int y = Integer.parseInt(desc.getAttribute("imageTopPosition"));
                                        g.drawImage(frameImage, x, y, null);
                                        BufferedImage currentFrameToSplit = new BufferedImage(canvas.getWidth(), canvas.getHeight(), 2);
                                        currentFrameToSplit.createGraphics().drawImage((Image)canvas, 0, 0, null);
                                        int W = currentFrameToSplit.getWidth();
                                        int H = currentFrameToSplit.getHeight();
                                        float totalWidthBlocks = bedWidth + 2.0f * drapeDepth;
                                        if (totalWidthBlocks <= 0.0f) continue;
                                        int leftW2 = Math.round(drapeDepth / totalWidthBlocks * (float)W);
                                        int midW = W - 2 * leftW2;
                                        if (leftW2 <= 0 || midW <= 0 || leftW2 + midW > W) continue;
                                        nativeRights.add(ImageUtils.toNativeImage(currentFrameToSplit.getSubimage(0, 0, leftW2, H)));
                                        nativeToppers.add(ImageUtils.toNativeImage(currentFrameToSplit.getSubimage(leftW2, 0, midW, H)));
                                        nativeLefts.add(ImageUtils.toNativeImage(currentFrameToSplit.getSubimage(leftW2 + midW, 0, leftW2, H)));
                                        if (!disposal.equals("restoreToBackgroundColor")) continue;
                                        g.clearRect(x, y, frameImage.getWidth(), frameImage.getHeight());
                                    }
                                    totalDuration = duration;
                                    if (g != null) {
                                        g.dispose();
                                    }
                                }
                                mc.execute(() -> {
                                    AtomicInteger index = new AtomicInteger(0);
                                    class_2960[] topperLocs = (class_2960[])nativeToppers.stream().map(ni -> mc.method_1531().method_4617("dynamic/" + ImageUtils.sanitize(key + "_topper_" + index.getAndIncrement()), new class_1043(ni))).toArray(class_2960[]::new);
                                    index.set(0);
                                    class_2960[] leftLocs = (class_2960[])nativeLefts.stream().map(ni -> mc.method_1531().method_4617("dynamic/" + ImageUtils.sanitize(key + "_left_" + index.getAndIncrement()), new class_1043(ni))).toArray(class_2960[]::new);
                                    index.set(0);
                                    class_2960[] rightLocs = (class_2960[])nativeRights.stream().map(ni -> mc.method_1531().method_4617("dynamic/" + ImageUtils.sanitize(key + "_right_" + index.getAndIncrement()), new class_1043(ni))).toArray(class_2960[]::new);
                                    cachedAnimatedSideTopper.put(key, new AnimatedTexture(topperLocs, delays, totalDuration));
                                    cachedAnimatedSideDrapeLeft.put(key, new AnimatedTexture(leftLocs, delays, totalDuration));
                                    cachedAnimatedSideDrapeRight.put(key, new AnimatedTexture(rightLocs, delays, totalDuration));
                                    nativeToppers.clear();
                                    nativeLefts.clear();
                                    nativeRights.clear();
                                });
                                break block22;
                            }
                            BufferedImage full = ImageIO.read(new ByteArrayInputStream(data));
                            int W = full.getWidth();
                            int H = full.getHeight();
                            float totalWidthBlocks = bedWidth + 2.0f * drapeDepth;
                            if (totalWidthBlocks <= 0.0f) {
                                return;
                            }
                            int rightW = leftW = Math.round(drapeDepth / totalWidthBlocks * (float)W);
                            int midW = W - leftW - rightW;
                            if (leftW <= 0 || rightW <= 0 || midW <= 0 || leftW + midW > W) {
                                return;
                            }
                            BufferedImage intendedRightDrapeImg = full.getSubimage(0, 0, leftW, H);
                            BufferedImage midImg = full.getSubimage(leftW, 0, midW, H);
                            BufferedImage intendedLeftDrapeImg = full.getSubimage(leftW + midW, 0, rightW, H);
                            mc.execute(() -> {
                                cachedSideDrapeLeft.put(key, ImageUtils.registerTextureFromImage(key + "_drape_left", intendedLeftDrapeImg, true));
                                cachedSideTopper.put(key, ImageUtils.registerTextureFromImage(key + "_topper", midImg, true));
                                cachedSideDrapeRight.put(key, ImageUtils.registerTextureFromImage(key + "_drape_right", intendedRightDrapeImg, true));
                            });
                        }
                        catch (RasterFormatException | IOException e) {
                            System.err.println("Error splitting texture " + key + ": " + e.getMessage());
                            blacklist.add(url);
                        }
                        finally {
                            pendingSideTransforms.remove(key);
                        }
                    }
                });
            }
        }
        int uL = packedLight & 0xFFFF;
        int vL = packedLight >> 16 & 0xFFFF;
        int uO = packedOverlay & 0xFFFF;
        int vO = packedOverlay >> 16 & 0xFFFF;
        ps.method_22903();
        ps.method_46416(0.0f, 1.02f, 0.0f);
        ps.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        class_4587.class_4665 p = ps.method_23760();
        class_4588 buf = bufSrc.getBuffer(class_1921.method_23028((class_2960)topperTex));
        float hw = bedWidth / 2.0f;
        float hl = bedLength / 2.0f;
        hw += 0.01f;
        Matrix4f matrix = p.method_23761();
        Vector3f nUp = new Vector3f(0.0f, 1.0f, 0.0f);
        matrix.transformDirection(nUp);
        Vector3f nDown = new Vector3f(0.0f, -1.0f, 0.0f);
        matrix.transformDirection(nDown);
        buf.method_22918(matrix, -hw, -hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nUp.x(), nUp.y(), nUp.z()).method_1344();
        buf.method_22918(matrix, hw, -hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nUp.x(), nUp.y(), nUp.z()).method_1344();
        buf.method_22918(matrix, hw, hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nUp.x(), nUp.y(), nUp.z()).method_1344();
        buf.method_22918(matrix, -hw, hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nUp.x(), nUp.y(), nUp.z()).method_1344();
        buf.method_22918(matrix, -hw, hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nDown.x(), nDown.y(), nDown.z()).method_1344();
        buf.method_22918(matrix, hw, hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nDown.x(), nDown.y(), nDown.z()).method_1344();
        buf.method_22918(matrix, hw, -hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nDown.x(), nDown.y(), nDown.z()).method_1344();
        buf.method_22918(matrix, -hw, -hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nDown.x(), nDown.y(), nDown.z()).method_1344();
        ps.method_22909();
        ps.method_22903();
        ps.method_46416(-bedWidth / 2.0f - 0.01f, 0.72f, 0.0f);
        ps.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        ps.method_22907(class_7833.field_40713.rotationDegrees(-180.0f));
        p = ps.method_23760();
        buf = bufSrc.getBuffer(class_1921.method_23028((class_2960)leftDrapeTex));
        float hl2 = bedLength / 2.0f;
        float d = drapeDepth;
        matrix = p.method_23761();
        Vector3f fn = new Vector3f(0.0f, 0.0f, 1.0f);
        matrix.transformDirection(fn);
        Vector3f bn = new Vector3f(0.0f, 0.0f, -1.0f);
        matrix.transformDirection(bn);
        buf.method_22918(matrix, -hl2, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(fn.x(), fn.y(), fn.z()).method_1344();
        buf.method_22918(matrix, hl2, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(fn.x(), fn.y(), fn.z()).method_1344();
        buf.method_22918(matrix, hl2, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(fn.x(), fn.y(), fn.z()).method_1344();
        buf.method_22918(matrix, -hl2, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(fn.x(), fn.y(), fn.z()).method_1344();
        buf.method_22918(matrix, -hl2, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(bn.x(), bn.y(), bn.z()).method_1344();
        buf.method_22918(matrix, hl2, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(bn.x(), bn.y(), bn.z()).method_1344();
        buf.method_22918(matrix, hl2, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(bn.x(), bn.y(), bn.z()).method_1344();
        buf.method_22918(matrix, -hl2, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(bn.x(), bn.y(), bn.z()).method_1344();
        ps.method_22909();
        ps.method_22903();
        ps.method_46416(bedWidth / 2.0f + 0.01f, 1.02f, 0.0f);
        ps.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        p = ps.method_23760();
        buf = bufSrc.getBuffer(class_1921.method_23028((class_2960)rightDrapeTex));
        hl2 = bedLength / 2.0f;
        d = drapeDepth;
        matrix = p.method_23761();
        fn = new Vector3f(0.0f, 0.0f, 1.0f);
        matrix.transformDirection(fn);
        bn = new Vector3f(0.0f, 0.0f, -1.0f);
        matrix.transformDirection(bn);
        buf.method_22918(matrix, -hl2, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(fn.x(), fn.y(), fn.z()).method_1344();
        buf.method_22918(matrix, hl2, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(fn.x(), fn.y(), fn.z()).method_1344();
        buf.method_22918(matrix, hl2, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(fn.x(), fn.y(), fn.z()).method_1344();
        buf.method_22918(matrix, -hl2, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(fn.x(), fn.y(), fn.z()).method_1344();
        buf.method_22918(matrix, -hl2, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(bn.x(), bn.y(), bn.z()).method_1344();
        buf.method_22918(matrix, hl2, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(bn.x(), bn.y(), bn.z()).method_1344();
        buf.method_22918(matrix, hl2, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(bn.x(), bn.y(), bn.z()).method_1344();
        buf.method_22918(matrix, -hl2, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(bn.x(), bn.y(), bn.z()).method_1344();
        ps.method_22909();
    }

    public static void renderImageFrontBackDrapesFromURL(class_4587 ps, class_4597 bufSrc, int packedLight, int packedOverlay, float partialTick, float bedWidth, float bedLength, float drapeDepth, String url) {
        class_2960 backDrapeTex;
        class_2960 frontDrapeTex;
        class_2960 topperTex;
        String key = url + "_split_frontback_" + bedLength + "_" + drapeDepth;
        if (cachedAnimatedFrontBackTopper.containsKey(key)) {
            topperTex = cachedAnimatedFrontBackTopper.get(key).getCurrentFrame();
            frontDrapeTex = cachedAnimatedFrontDrape.get(key).getCurrentFrame();
            backDrapeTex = cachedAnimatedBackDrape.get(key).getCurrentFrame();
        } else if (cachedFrontBackTopper.containsKey(key)) {
            topperTex = cachedFrontBackTopper.get(key);
            frontDrapeTex = cachedFrontDrape.get(key);
            backDrapeTex = cachedBackDrape.get(key);
        } else if (pendingFrontBackTransforms.contains(key)) {
            frontDrapeTex = backDrapeTex = LOADING_TEXTURE;
            topperTex = backDrapeTex;
        } else {
            frontDrapeTex = backDrapeTex = ImageUtils.getOrLoadTexture(url);
            topperTex = backDrapeTex;
            byte[] data = ImageUtils.getRawDataFromCache(url);
            if (data != null) {
                pendingFrontBackTransforms.add(key);
                frontDrapeTex = backDrapeTex = LOADING_TEXTURE;
                topperTex = backDrapeTex;
                executor.submit(() -> {
                    block22: {
                        try {
                            int frontH;
                            if (ImageUtils.isGif(data)) {
                                int totalDuration;
                                int[] delays;
                                ArrayList<class_1011> nativeToppers = new ArrayList<class_1011>();
                                ArrayList<class_1011> nativeFronts = new ArrayList<class_1011>();
                                ArrayList<class_1011> nativeBacks = new ArrayList<class_1011>();
                                try (ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(data));){
                                    Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
                                    if (!readers.hasNext()) {
                                        throw new IOException("No GIF reader");
                                    }
                                    ImageReader reader = readers.next();
                                    reader.setInput(stream);
                                    int numFrames = reader.getNumImages(true);
                                    delays = new int[numFrames];
                                    int duration = 0;
                                    BufferedImage canvas = null;
                                    Graphics g = null;
                                    for (int i = 0; i < numFrames; ++i) {
                                        BufferedImage frameImage = reader.read(i);
                                        if (canvas == null) {
                                            canvas = new BufferedImage(reader.getWidth(0), reader.getHeight(0), 2);
                                            g = canvas.createGraphics();
                                        }
                                        IIOMetadata metadata = reader.getImageMetadata(i);
                                        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
                                        IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
                                        delays[i] = Integer.parseInt(gce.getAttribute("delayTime")) * 10;
                                        if (delays[i] <= 0) {
                                            delays[i] = 100;
                                        }
                                        duration += delays[i];
                                        String disposal = gce.getAttribute("disposalMethod");
                                        IIOMetadataNode desc = (IIOMetadataNode)root.getElementsByTagName("ImageDescriptor").item(0);
                                        int x = Integer.parseInt(desc.getAttribute("imageLeftPosition"));
                                        int y = Integer.parseInt(desc.getAttribute("imageTopPosition"));
                                        g.drawImage(frameImage, x, y, null);
                                        BufferedImage currentFrameToSplit = new BufferedImage(canvas.getWidth(), canvas.getHeight(), 2);
                                        currentFrameToSplit.createGraphics().drawImage((Image)canvas, 0, 0, null);
                                        int W = currentFrameToSplit.getWidth();
                                        int H = currentFrameToSplit.getHeight();
                                        float totalLengthBlocks = bedLength + 2.0f * drapeDepth;
                                        if (totalLengthBlocks <= 0.0f) continue;
                                        int frontH2 = Math.round(drapeDepth / totalLengthBlocks * (float)H);
                                        int midH = H - 2 * frontH2;
                                        if (frontH2 <= 0 || midH <= 0 || frontH2 + midH > H) continue;
                                        nativeBacks.add(ImageUtils.toNativeImage(currentFrameToSplit.getSubimage(0, 0, W, frontH2)));
                                        nativeToppers.add(ImageUtils.toNativeImage(currentFrameToSplit.getSubimage(0, frontH2, W, midH)));
                                        nativeFronts.add(ImageUtils.toNativeImage(currentFrameToSplit.getSubimage(0, frontH2 + midH, W, frontH2)));
                                        if (!disposal.equals("restoreToBackgroundColor")) continue;
                                        g.clearRect(x, y, frameImage.getWidth(), frameImage.getHeight());
                                    }
                                    totalDuration = duration;
                                    if (g != null) {
                                        g.dispose();
                                    }
                                }
                                mc.execute(() -> {
                                    AtomicInteger index = new AtomicInteger(0);
                                    class_2960[] topperLocs = (class_2960[])nativeToppers.stream().map(ni -> mc.method_1531().method_4617("dynamic/" + ImageUtils.sanitize(key + "_topper_" + index.getAndIncrement()), new class_1043(ni))).toArray(class_2960[]::new);
                                    index.set(0);
                                    class_2960[] frontLocs = (class_2960[])nativeFronts.stream().map(ni -> mc.method_1531().method_4617("dynamic/" + ImageUtils.sanitize(key + "_front_" + index.getAndIncrement()), new class_1043(ni))).toArray(class_2960[]::new);
                                    index.set(0);
                                    class_2960[] backLocs = (class_2960[])nativeBacks.stream().map(ni -> mc.method_1531().method_4617("dynamic/" + ImageUtils.sanitize(key + "_back_" + index.getAndIncrement()), new class_1043(ni))).toArray(class_2960[]::new);
                                    cachedAnimatedFrontBackTopper.put(key, new AnimatedTexture(topperLocs, delays, totalDuration));
                                    cachedAnimatedFrontDrape.put(key, new AnimatedTexture(frontLocs, delays, totalDuration));
                                    cachedAnimatedBackDrape.put(key, new AnimatedTexture(backLocs, delays, totalDuration));
                                    nativeToppers.clear();
                                    nativeFronts.clear();
                                    nativeBacks.clear();
                                });
                                break block22;
                            }
                            BufferedImage full = ImageIO.read(new ByteArrayInputStream(data));
                            int W = full.getWidth();
                            int H = full.getHeight();
                            float totalLengthBlocks = bedLength + 2.0f * drapeDepth;
                            if (totalLengthBlocks <= 0.0f) {
                                return;
                            }
                            int backH = frontH = Math.round(drapeDepth / totalLengthBlocks * (float)H);
                            int midH = H - frontH - backH;
                            if (frontH <= 0 || backH <= 0 || midH <= 0 || frontH + midH > H) {
                                return;
                            }
                            BufferedImage intendedBackDrapeImg = full.getSubimage(0, 0, W, frontH);
                            BufferedImage midImg = full.getSubimage(0, frontH, W, midH);
                            BufferedImage intendedFrontDrapeImg = full.getSubimage(0, frontH + midH, W, backH);
                            mc.execute(() -> {
                                cachedFrontDrape.put(key, ImageUtils.registerTextureFromImage(key + "_drape_front", intendedFrontDrapeImg, true));
                                cachedFrontBackTopper.put(key, ImageUtils.registerTextureFromImage(key + "_topper_frontback", midImg, true));
                                cachedBackDrape.put(key, ImageUtils.registerTextureFromImage(key + "_drape_back", intendedBackDrapeImg, true));
                            });
                        }
                        catch (RasterFormatException | IOException e) {
                            System.err.println("Error splitting texture " + key + ": " + e.getMessage());
                            blacklist.add(url);
                        }
                        finally {
                            pendingFrontBackTransforms.remove(key);
                        }
                    }
                });
            }
        }
        int uL = packedLight & 0xFFFF;
        int vL = packedLight >> 16 & 0xFFFF;
        int uO = packedOverlay & 0xFFFF;
        int vO = packedOverlay >> 16 & 0xFFFF;
        float topperY = 1.02f;
        float frontDrapeZ = -bedLength / 2.0f - 0.01f;
        float backDrapeZ = bedLength / 2.0f + 0.01f;
        ps.method_22903();
        ps.method_46416(0.0f, topperY, 0.0f);
        ps.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        class_4587.class_4665 p = ps.method_23760();
        class_4588 buf = bufSrc.getBuffer(class_1921.method_23028((class_2960)topperTex));
        float hw = bedWidth / 2.0f;
        float hl = bedLength / 2.0f;
        hl += 0.01f;
        Matrix4f matrix = p.method_23761();
        Vector3f nUp = new Vector3f(0.0f, 1.0f, 0.0f);
        matrix.transformDirection(nUp);
        Vector3f nDown = new Vector3f(0.0f, -1.0f, 0.0f);
        matrix.transformDirection(nDown);
        buf.method_22918(matrix, -hw, -hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nUp.x(), nUp.y(), nUp.z()).method_1344();
        buf.method_22918(matrix, hw, -hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nUp.x(), nUp.y(), nUp.z()).method_1344();
        buf.method_22918(matrix, hw, hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nUp.x(), nUp.y(), nUp.z()).method_1344();
        buf.method_22918(matrix, -hw, hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nUp.x(), nUp.y(), nUp.z()).method_1344();
        buf.method_22918(matrix, -hw, hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nDown.x(), nDown.y(), nDown.z()).method_1344();
        buf.method_22918(matrix, hw, hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nDown.x(), nDown.y(), nDown.z()).method_1344();
        buf.method_22918(matrix, hw, -hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nDown.x(), nDown.y(), nDown.z()).method_1344();
        buf.method_22918(matrix, -hw, -hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nDown.x(), nDown.y(), nDown.z()).method_1344();
        ps.method_22909();
        ps.method_22903();
        ps.method_46416(0.0f, topperY, frontDrapeZ);
        p = ps.method_23760();
        buf = bufSrc.getBuffer(class_1921.method_23028((class_2960)frontDrapeTex));
        hw = bedWidth / 2.0f;
        float d = drapeDepth;
        matrix = p.method_23761();
        Vector3f bn = new Vector3f(0.0f, 0.0f, -1.0f);
        matrix.transformDirection(bn);
        Vector3f fn = new Vector3f(0.0f, 0.0f, 1.0f);
        matrix.transformDirection(fn);
        buf.method_22918(matrix, -hw, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(bn.x(), bn.y(), bn.z()).method_1344();
        buf.method_22918(matrix, hw, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(bn.x(), bn.y(), bn.z()).method_1344();
        buf.method_22918(matrix, hw, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(bn.x(), bn.y(), bn.z()).method_1344();
        buf.method_22918(matrix, -hw, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(bn.x(), bn.y(), bn.z()).method_1344();
        buf.method_22918(matrix, -hw, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(fn.x(), fn.y(), fn.z()).method_1344();
        buf.method_22918(matrix, hw, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(fn.x(), fn.y(), fn.z()).method_1344();
        buf.method_22918(matrix, hw, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(fn.x(), fn.y(), fn.z()).method_1344();
        buf.method_22918(matrix, -hw, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(fn.x(), fn.y(), fn.z()).method_1344();
        ps.method_22909();
        ps.method_22903();
        ps.method_46416(0.0f, topperY, backDrapeZ);
        ps.method_22907(class_7833.field_40713.rotationDegrees(180.0f));
        ps.method_22904(0.0, 0.3, 0.0);
        p = ps.method_23760();
        buf = bufSrc.getBuffer(class_1921.method_23028((class_2960)backDrapeTex));
        hw = bedWidth / 2.0f;
        d = drapeDepth;
        matrix = p.method_23761();
        Vector3f fn2 = new Vector3f(0.0f, 0.0f, 1.0f);
        matrix.transformDirection(fn2);
        Vector3f bn2 = new Vector3f(0.0f, 0.0f, -1.0f);
        matrix.transformDirection(bn2);
        buf.method_22918(matrix, -hw, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(fn2.x(), fn2.y(), fn2.z()).method_1344();
        buf.method_22918(matrix, hw, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(fn2.x(), fn2.y(), fn2.z()).method_1344();
        buf.method_22918(matrix, hw, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(fn2.x(), fn2.y(), fn2.z()).method_1344();
        buf.method_22918(matrix, -hw, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(fn2.x(), fn2.y(), fn2.z()).method_1344();
        buf.method_22918(matrix, -hw, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(bn2.x(), bn2.y(), bn2.z()).method_1344();
        buf.method_22918(matrix, hw, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(bn2.x(), bn2.y(), bn2.z()).method_1344();
        buf.method_22918(matrix, hw, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(bn2.x(), bn2.y(), bn2.z()).method_1344();
        buf.method_22918(matrix, -hw, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(bn2.x(), bn2.y(), bn2.z()).method_1344();
        ps.method_22909();
    }

    public static void renderImageFrontDrapeFromURL(class_4587 ps, class_4597 bufSrc, int packedLight, int packedOverlay, float partialTick, float bedWidth, float bedLength, float drapeDepth, String url) {
        class_2960 frontDrapeTex;
        class_2960 topperTex;
        String key = url + "_split_front_" + bedLength + "_" + drapeDepth;
        if (cachedAnimatedSingleTopper.containsKey(key)) {
            topperTex = cachedAnimatedSingleTopper.get(key).getCurrentFrame();
            frontDrapeTex = cachedAnimatedSingleFrontDrape.get(key).getCurrentFrame();
        } else if (cachedSingleTopper.containsKey(key)) {
            topperTex = cachedSingleTopper.get(key);
            frontDrapeTex = cachedSingleFrontDrape.get(key);
        } else if (pendingSingleFrontTransforms.contains(key)) {
            topperTex = frontDrapeTex = LOADING_TEXTURE;
        } else {
            topperTex = frontDrapeTex = ImageUtils.getOrLoadTexture(url);
            byte[] data = ImageUtils.getRawDataFromCache(url);
            if (data != null) {
                pendingSingleFrontTransforms.add(key);
                topperTex = frontDrapeTex = LOADING_TEXTURE;
                executor.submit(() -> {
                    block22: {
                        try {
                            if (ImageUtils.isGif(data)) {
                                int totalDuration;
                                int[] delays;
                                ArrayList<class_1011> nativeToppers = new ArrayList<class_1011>();
                                ArrayList<class_1011> nativeDrapes = new ArrayList<class_1011>();
                                try (ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(data));){
                                    Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
                                    if (!readers.hasNext()) {
                                        throw new IOException("No GIF reader");
                                    }
                                    ImageReader reader = readers.next();
                                    reader.setInput(stream);
                                    int numFrames = reader.getNumImages(true);
                                    delays = new int[numFrames];
                                    int duration = 0;
                                    BufferedImage canvas = null;
                                    Graphics g = null;
                                    for (int i = 0; i < numFrames; ++i) {
                                        BufferedImage frameImage = reader.read(i);
                                        if (canvas == null) {
                                            canvas = new BufferedImage(reader.getWidth(0), reader.getHeight(0), 2);
                                            g = canvas.createGraphics();
                                        }
                                        IIOMetadata metadata = reader.getImageMetadata(i);
                                        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
                                        IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
                                        delays[i] = Integer.parseInt(gce.getAttribute("delayTime")) * 10;
                                        if (delays[i] <= 0) {
                                            delays[i] = 100;
                                        }
                                        duration += delays[i];
                                        String disposal = gce.getAttribute("disposalMethod");
                                        IIOMetadataNode desc = (IIOMetadataNode)root.getElementsByTagName("ImageDescriptor").item(0);
                                        int x = Integer.parseInt(desc.getAttribute("imageLeftPosition"));
                                        int y = Integer.parseInt(desc.getAttribute("imageTopPosition"));
                                        g.drawImage(frameImage, x, y, null);
                                        BufferedImage currentFrameToSplit = new BufferedImage(canvas.getWidth(), canvas.getHeight(), 2);
                                        currentFrameToSplit.createGraphics().drawImage((Image)canvas, 0, 0, null);
                                        int W = currentFrameToSplit.getWidth();
                                        int H = currentFrameToSplit.getHeight();
                                        float totalLengthBlocks = bedLength + drapeDepth;
                                        if (totalLengthBlocks <= 0.0f) continue;
                                        int drapeH = Math.round(drapeDepth / totalLengthBlocks * (float)H);
                                        int topperH = H - drapeH;
                                        if (drapeH <= 0 || topperH <= 0) continue;
                                        nativeToppers.add(ImageUtils.toNativeImage(currentFrameToSplit.getSubimage(0, 0, W, topperH)));
                                        nativeDrapes.add(ImageUtils.toNativeImage(currentFrameToSplit.getSubimage(0, topperH, W, drapeH)));
                                        if (!disposal.equals("restoreToBackgroundColor")) continue;
                                        g.clearRect(x, y, frameImage.getWidth(), frameImage.getHeight());
                                    }
                                    totalDuration = duration;
                                    if (g != null) {
                                        g.dispose();
                                    }
                                }
                                mc.execute(() -> {
                                    AtomicInteger index = new AtomicInteger(0);
                                    class_2960[] topperLocs = (class_2960[])nativeToppers.stream().map(ni -> mc.method_1531().method_4617("dynamic/" + ImageUtils.sanitize(key + "_topper_" + index.getAndIncrement()), new class_1043(ni))).toArray(class_2960[]::new);
                                    index.set(0);
                                    class_2960[] drapeLocs = (class_2960[])nativeDrapes.stream().map(ni -> mc.method_1531().method_4617("dynamic/" + ImageUtils.sanitize(key + "_drape_" + index.getAndIncrement()), new class_1043(ni))).toArray(class_2960[]::new);
                                    cachedAnimatedSingleTopper.put(key, new AnimatedTexture(topperLocs, delays, totalDuration));
                                    cachedAnimatedSingleFrontDrape.put(key, new AnimatedTexture(drapeLocs, delays, totalDuration));
                                    nativeToppers.clear();
                                    nativeDrapes.clear();
                                });
                                break block22;
                            }
                            BufferedImage full = ImageIO.read(new ByteArrayInputStream(data));
                            int W = full.getWidth();
                            int H = full.getHeight();
                            float totalLengthBlocks = bedLength + drapeDepth;
                            if (totalLengthBlocks <= 0.0f) {
                                return;
                            }
                            int drapeH = Math.round(drapeDepth / totalLengthBlocks * (float)H);
                            int topperH = H - drapeH;
                            if (drapeH <= 0 || topperH <= 0) {
                                return;
                            }
                            BufferedImage topperImg = full.getSubimage(0, 0, W, topperH);
                            BufferedImage drapeImg = full.getSubimage(0, topperH, W, drapeH);
                            mc.execute(() -> {
                                cachedSingleFrontDrape.put(key, ImageUtils.registerTextureFromImage(key + "_drape_front", drapeImg, true));
                                cachedSingleTopper.put(key, ImageUtils.registerTextureFromImage(key + "_topper_front", topperImg, true));
                            });
                        }
                        catch (RasterFormatException | IOException e) {
                            System.err.println("Error splitting texture " + key + ": " + e.getMessage());
                            blacklist.add(url);
                        }
                        finally {
                            pendingSingleFrontTransforms.remove(key);
                        }
                    }
                });
            }
        }
        int uL = packedLight & 0xFFFF;
        int vL = packedLight >> 16 & 0xFFFF;
        int uO = packedOverlay & 0xFFFF;
        int vO = packedOverlay >> 16 & 0xFFFF;
        float topperY = 1.02f;
        float frontDrapeZ = -bedLength / 2.0f - 0.01f;
        ps.method_22903();
        ps.method_46416(0.0f, topperY, 0.0f);
        ps.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        class_4587.class_4665 p = ps.method_23760();
        class_4588 buf = bufSrc.getBuffer(class_1921.method_23028((class_2960)topperTex));
        float hw = bedWidth / 2.0f;
        float hl = bedLength / 2.0f;
        hl += 0.01f;
        Matrix4f matrix = p.method_23761();
        Vector3f nUp = new Vector3f(0.0f, 1.0f, 0.0f);
        matrix.transformDirection(nUp);
        Vector3f nDown = new Vector3f(0.0f, -1.0f, 0.0f);
        matrix.transformDirection(nDown);
        buf.method_22918(matrix, -hw, -hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nUp.x(), nUp.y(), nUp.z()).method_1344();
        buf.method_22918(matrix, hw, -hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nUp.x(), nUp.y(), nUp.z()).method_1344();
        buf.method_22918(matrix, hw, hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nUp.x(), nUp.y(), nUp.z()).method_1344();
        buf.method_22918(matrix, -hw, hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nUp.x(), nUp.y(), nUp.z()).method_1344();
        buf.method_22918(matrix, -hw, hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nDown.x(), nDown.y(), nDown.z()).method_1344();
        buf.method_22918(matrix, hw, hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nDown.x(), nDown.y(), nDown.z()).method_1344();
        buf.method_22918(matrix, hw, -hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nDown.x(), nDown.y(), nDown.z()).method_1344();
        buf.method_22918(matrix, -hw, -hl, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nDown.x(), nDown.y(), nDown.z()).method_1344();
        ps.method_22909();
        ps.method_22903();
        ps.method_46416(0.0f, topperY, frontDrapeZ);
        p = ps.method_23760();
        buf = bufSrc.getBuffer(class_1921.method_23028((class_2960)frontDrapeTex));
        hw = bedWidth / 2.0f;
        float d = drapeDepth;
        matrix = p.method_23761();
        Vector3f nOut = new Vector3f(0.0f, 0.0f, -1.0f);
        matrix.transformDirection(nOut);
        Vector3f nIn = new Vector3f(0.0f, 0.0f, 1.0f);
        matrix.transformDirection(nIn);
        buf.method_22918(matrix, -hw, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nOut.x(), nOut.y(), nOut.z()).method_1344();
        buf.method_22918(matrix, hw, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nOut.x(), nOut.y(), nOut.z()).method_1344();
        buf.method_22918(matrix, hw, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nOut.x(), nOut.y(), nOut.z()).method_1344();
        buf.method_22918(matrix, -hw, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nOut.x(), nOut.y(), nOut.z()).method_1344();
        buf.method_22918(matrix, -hw, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nIn.x(), nIn.y(), nIn.z()).method_1344();
        buf.method_22918(matrix, hw, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nIn.x(), nIn.y(), nIn.z()).method_1344();
        buf.method_22918(matrix, hw, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nIn.x(), nIn.y(), nIn.z()).method_1344();
        buf.method_22918(matrix, -hw, -d, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22917(uO, vO).method_22921(uL, vL).method_22914(nIn.x(), nIn.y(), nIn.z()).method_1344();
        ps.method_22909();
    }

    static {
        BufferedImage notFoundImage = ImageUtils.loadBufferedImageFromResource("picaxe", "textures/blocks/notfound.png");
        BufferedImage loadingImage = ImageUtils.loadBufferedImageFromResource("picaxe", "textures/blocks/loadingimage.png");
        BufferedImage combinedLoadingImage = new BufferedImage(notFoundImage.getWidth() + loadingImage.getWidth(), Math.max(notFoundImage.getHeight(), loadingImage.getHeight()), 2);
        Graphics2D g = combinedLoadingImage.createGraphics();
        g.drawImage((Image)loadingImage, 0, 0, null);
        g.drawImage((Image)notFoundImage, loadingImage.getWidth(), 0, null);
        g.dispose();
        NOT_FOUND_TEXTURE = ImageUtils.registerTextureFromImage("internal:notfound", notFoundImage, true);
        LOADING_TEXTURE = ImageUtils.registerTextureFromImage("internal:loading", combinedLoadingImage, true);
    }

    private record AnimatedTexture(class_2960[] frames, int[] delays, int totalDuration) {
        public class_2960 getCurrentFrame() {
            if (this.frames == null || this.frames.length == 0) {
                return NOT_FOUND_TEXTURE;
            }
            if (this.frames.length <= 1) {
                return this.frames[0];
            }
            if (this.totalDuration == 0) {
                return this.frames[0];
            }
            long timeInAnimation = System.currentTimeMillis() % (long)this.totalDuration;
            int accumulatedDelay = 0;
            for (int i = 0; i < this.delays.length; ++i) {
                if (timeInAnimation >= (long)(accumulatedDelay += this.delays[i])) continue;
                return this.frames[i];
            }
            return this.frames[this.frames.length - 1];
        }
    }
}

