/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.entities;

import java.net.URI;
import java.net.URISyntaxException;
import net.jacobwasbeast.picaxe.ModBlockEntities;
import net.jacobwasbeast.picaxe.api.BannerRenderTypes;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_7225;

public class ImageWallBannerBlockEntity
extends class_2586 {
    public class_1767 color;
    private String imageLocation;
    public BannerRenderTypes renderTypes = BannerRenderTypes.OVER_BANNER;

    public ImageWallBannerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlockEntities.IMAGE_WALL_BANNER_BLOCK_ENTITY.get(), blockPos, blockState);
        this.color = class_1767.field_7952;
        this.imageLocation = "picaxe:blocks/banner";
    }

    public ImageWallBannerBlockEntity(class_2338 blockPos, class_2680 blockState, class_1767 dyeColor) {
        super((class_2591)ModBlockEntities.IMAGE_WALL_BANNER_BLOCK_ENTITY.get(), blockPos, blockState);
        this.color = dyeColor;
        this.imageLocation = "picaxe:blocks/banner";
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public class_1767 getColor() {
        return this.color;
    }

    public BannerRenderTypes getRenderTypes() {
        return this.renderTypes;
    }

    public void setColor(class_1767 dyeColor) {
        this.color = dyeColor;
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.method_5431();
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public void setRenderTypes(BannerRenderTypes renderTypes) {
        this.renderTypes = renderTypes;
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.method_5431();
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public void setImageLocation(String url) {
        URI uri;
        try {
            String encodedUrl = url.replace(" ", "%20");
            uri = new URI(encodedUrl);
            if (!uri.isAbsolute() || uri.getScheme() == null || uri.getHost() == null) {
                throw new URISyntaxException(url, "URL is not absolute");
            }
        }
        catch (URISyntaxException e) {
            if (this.field_11863 != null && this.field_11863.method_8608()) {
                class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43471((String)"picaxe.errors.invalid_url_format"));
            }
            return;
        }
        String path = uri.getPath();
        if (path == null || !path.toLowerCase().endsWith(".png") && !path.toLowerCase().endsWith(".jpg") && !path.toLowerCase().endsWith(".jpeg")) {
            if (this.field_11863 != null && this.field_11863.method_8608()) {
                class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43471((String)"picaxe.errors.invalid_image_extension"));
            }
            return;
        }
        this.imageLocation = uri.toString();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.method_5431();
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        compoundTag.method_10582("imageLocation", this.imageLocation);
        compoundTag.method_10582("color", this.color.method_7792());
        compoundTag.method_10582("id", "picaxe:image_banner");
        if (this.renderTypes != null) {
            compoundTag.method_10582("renderTypes", this.renderTypes.name());
        } else {
            compoundTag.method_10582("renderTypes", BannerRenderTypes.OVER_BANNER.name());
        }
    }

    protected void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        this.imageLocation = compoundTag.method_10558("imageLocation");
        if (!compoundTag.method_10545("imageLocation")) {
            this.imageLocation = "picaxe:blocks/banner";
        }
        this.color = class_1767.method_7793((String)compoundTag.method_10558("color"), (class_1767)class_1767.field_7952);
        if (compoundTag.method_10545("renderTypes")) {
            try {
                this.renderTypes = BannerRenderTypes.valueOf(compoundTag.method_10558("renderTypes"));
            }
            catch (IllegalArgumentException e) {
                this.renderTypes = BannerRenderTypes.OVER_BANNER;
            }
        } else {
            this.renderTypes = BannerRenderTypes.OVER_BANNER;
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }
}

