/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.renderer;

import net.jacobwasbeast.picaxe.blocks.ImageFrameBlock;
import net.jacobwasbeast.picaxe.blocks.entities.ImageFrameBlockEntity;
import net.jacobwasbeast.picaxe.utils.ImageUtils;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ImageFrameBlockRenderer
implements class_827<ImageFrameBlockEntity> {
    private static final class_2960 OAK_WALL_TEXTURE = class_2960.method_43902((String)"minecraft", (String)"textures/block/oak_planks.png");

    public ImageFrameBlockRenderer(class_5614.class_5615 context) {
    }

    public void render(ImageFrameBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_1937 level = blockEntity.method_10997();
        if (level == null) {
            return;
        }
        class_2680 blockState = blockEntity.method_11010();
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)ImageFrameBlock.field_10927);
        float frameWidth = blockEntity.getFrameWidth();
        float frameHeight = blockEntity.getFrameHeight();
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.5, 0.5);
        switch (facing) {
            case field_11033: {
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                break;
            }
            case field_11036: {
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                break;
            }
            case field_11043: {
                break;
            }
            case field_11035: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11039: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
            case field_11034: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
            }
        }
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, (double)0.49f);
        int light = class_761.method_23794((class_1920)level, (class_2338)blockEntity.method_11016().method_10093(facing));
        this.renderDoubleSidedQuad(poseStack, bufferSource.getBuffer(class_1921.method_23572((class_2960)OAK_WALL_TEXTURE)), frameWidth, frameHeight, light, packedOverlay, 220, false);
        poseStack.method_22909();
        poseStack.method_22907(class_7833.field_40713.rotationDegrees(-90.0f));
        poseStack.method_22907(class_7833.field_40713.rotationDegrees(-180.0f));
        poseStack.method_22904(0.0, -0.99, 0.0);
        String imageUrl = blockEntity.getImageUrl();
        if (imageUrl != null && !imageUrl.isBlank()) {
            poseStack.method_22903();
            poseStack.method_22904(-0.5, -0.5, -0.5);
            int faceLight = class_761.method_23794((class_1920)level, (class_2338)blockEntity.method_11016().method_10093(facing));
            boolean keepAspectRatio = !blockEntity.shouldStretchToFit();
            ImageUtils.renderImageFromURL(poseStack, bufferSource, faceLight, packedOverlay, partialTick, frameWidth, frameHeight, imageUrl, keepAspectRatio);
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    private void renderDoubleSidedQuad(class_4587 poseStack, class_4588 vc, float width, float height, int light, int overlay, int color, boolean useNormalizedUV) {
        class_4587.class_4665 pose = poseStack.method_23760();
        Matrix4f matrix = pose.method_23761();
        Vector3f normalPositiveZ = pose.method_56821(new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f());
        Vector3f normalNegativeZ = pose.method_56821(new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f());
        float x0 = -width / 2.0f;
        float x1 = width / 2.0f;
        float y0 = -height / 2.0f;
        float y1 = height / 2.0f;
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = useNormalizedUV ? 1.0f : width * 16.0f;
        float v1 = useNormalizedUV ? 1.0f : height * 16.0f;
        Vector3f v_tl = new Vector3f(x0, y1, 0.0f);
        matrix.transformPosition(v_tl);
        Vector3f v_bl = new Vector3f(x0, y0, 0.0f);
        matrix.transformPosition(v_bl);
        Vector3f v_br = new Vector3f(x1, y0, 0.0f);
        matrix.transformPosition(v_br);
        Vector3f v_tr = new Vector3f(x1, y1, 0.0f);
        matrix.transformPosition(v_tr);
        vc.method_22912(v_tl.x(), v_tl.y(), v_tl.z()).method_1336(color, color, color, 255).method_22913(u0, v0).method_22922(overlay).method_60803(light).method_22914(normalPositiveZ.x(), normalPositiveZ.y(), normalPositiveZ.z());
        vc.method_22912(v_bl.x(), v_bl.y(), v_bl.z()).method_1336(color, color, color, 255).method_22913(u0, v1).method_22922(overlay).method_60803(light).method_22914(normalPositiveZ.x(), normalPositiveZ.y(), normalPositiveZ.z());
        vc.method_22912(v_br.x(), v_br.y(), v_br.z()).method_1336(color, color, color, 255).method_22913(u1, v1).method_22922(overlay).method_60803(light).method_22914(normalPositiveZ.x(), normalPositiveZ.y(), normalPositiveZ.z());
        vc.method_22912(v_tr.x(), v_tr.y(), v_tr.z()).method_1336(color, color, color, 255).method_22913(u1, v0).method_22922(overlay).method_60803(light).method_22914(normalPositiveZ.x(), normalPositiveZ.y(), normalPositiveZ.z());
        vc.method_22912(v_tr.x(), v_tr.y(), v_tr.z()).method_1336(color, color, color, 255).method_22913(u1, v0).method_22922(overlay).method_60803(light).method_22914(normalNegativeZ.x(), normalNegativeZ.y(), normalNegativeZ.z());
        vc.method_22912(v_br.x(), v_br.y(), v_br.z()).method_1336(color, color, color, 255).method_22913(u1, v1).method_22922(overlay).method_60803(light).method_22914(normalNegativeZ.x(), normalNegativeZ.y(), normalNegativeZ.z());
        vc.method_22912(v_bl.x(), v_bl.y(), v_bl.z()).method_1336(color, color, color, 255).method_22913(u0, v1).method_22922(overlay).method_60803(light).method_22914(normalNegativeZ.x(), normalNegativeZ.y(), normalNegativeZ.z());
        vc.method_22912(v_tl.x(), v_tl.y(), v_tl.z()).method_1336(color, color, color, 255).method_22913(u0, v0).method_22922(overlay).method_60803(light).method_22914(normalNegativeZ.x(), normalNegativeZ.y(), normalNegativeZ.z());
    }
}

