/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.gui;

import net.blay09.mods.balm.api.Balm;
import net.jacobwasbeast.picaxe.blocks.entities.ImageFrameBlockEntity;
import net.jacobwasbeast.picaxe.network.UpdateImageFramePayload;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_8710;

public class ImageFrameConfigScreen
extends class_437 {
    private static final int BACKGROUND_COLOR = -436207616;
    private static final int PANEL_COLOR = -870704614;
    private static final int ACCENT_COLOR = -13330213;
    private static final int TEXT_COLOR = -1;
    private static final int SUBTITLE_COLOR = -7829368;
    private static final int ERROR_COLOR = -1618884;
    private static final int SUCCESS_COLOR = -13710223;
    private static final int REMOVE_COLOR = -38091;
    private final ImageFrameBlockEntity blockEntity;
    private class_342 urlInput;
    private class_342 widthInput;
    private class_342 heightInput;
    private class_4185 stretchButton;
    private class_4185 confirmButton;
    private class_4185 cancelButton;
    private class_4185 clearButton;
    private boolean shouldStretch;
    private String urlValue;
    private String widthValue;
    private String heightValue;
    private String errorMessage = "";
    private int errorTimer = 0;
    private float animationProgress = 0.0f;
    private boolean urlChanged = false;

    public ImageFrameConfigScreen(ImageFrameBlockEntity be) {
        super((class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.title"));
        this.blockEntity = be;
        this.shouldStretch = be.shouldStretchToFit();
        this.urlValue = be.getImageUrl();
        this.widthValue = String.valueOf(be.getFrameWidth());
        this.heightValue = String.valueOf(be.getFrameHeight());
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int panelWidth = 360;
        int panelHeight = 240;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        this.urlInput = new class_342(this.field_22793, panelX + 30, panelY + 65, panelWidth - 90, 20, (class_2561)class_2561.method_43471((String)"picaxe.screen.url_input.url"));
        this.urlInput.method_1880(256);
        this.urlInput.method_1852(this.urlValue);
        this.urlInput.method_47404((class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.url_hint"));
        this.urlInput.method_1858(false);
        this.urlInput.method_1863(text -> {
            this.urlChanged = !text.equals(this.blockEntity.getImageUrl());
        });
        this.method_25429((class_364)this.urlInput);
        this.method_48265((class_364)this.urlInput);
        this.clearButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.clear_icon"), button -> {
            this.urlInput.method_1852("");
            this.urlChanged = true;
        }).method_46434(panelX + panelWidth - 55, panelY + 65, 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.clear_tooltip"))).method_46431());
        int inputWidth = (panelWidth - 90) / 2;
        this.widthInput = new class_342(this.field_22793, panelX + 30, panelY + 115, inputWidth, 20, (class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.width"));
        this.widthInput.method_1852(this.widthValue);
        this.widthInput.method_47404((class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.width_hint"));
        this.widthInput.method_1858(false);
        this.widthInput.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.width_tooltip")));
        this.method_25429((class_364)this.widthInput);
        this.heightInput = new class_342(this.field_22793, panelX + 30 + inputWidth + 30, panelY + 115, inputWidth, 20, (class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.height"));
        this.heightInput.method_1852(this.heightValue);
        this.heightInput.method_47404((class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.height_hint"));
        this.heightInput.method_1858(false);
        this.heightInput.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.height_tooltip")));
        this.method_25429((class_364)this.heightInput);
        this.stretchButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)this.getStretchButtonText(), button -> {
            this.shouldStretch = !this.shouldStretch;
            button.method_25355(this.getStretchButtonText());
        }).method_46434(panelX + 30, panelY + 155, panelWidth - 60, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.stretch_tooltip"))).method_46431());
        int buttonWidth = (panelWidth - 90) / 2;
        this.confirmButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.confirm_button"), button -> {
            if (this.validateInputs()) {
                try {
                    int width = Integer.parseInt(this.widthInput.method_1882());
                    int height = Integer.parseInt(this.heightInput.method_1882());
                    String url = this.urlInput.method_1882();
                    class_2338 pos = this.blockEntity.method_11016();
                    Balm.getNetworking().sendToServer((class_8710)new UpdateImageFramePayload(pos, url, width, height, this.shouldStretch));
                    this.field_22787.method_1507(null);
                }
                catch (NumberFormatException e) {
                    this.setError(class_2561.method_43471((String)"picaxe.screen.image_frame.error.invalid_dimensions").getString());
                }
            }
        }).method_46434(panelX + 30, panelY + 190, buttonWidth, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.confirm_tooltip"))).method_46431());
        this.cancelButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.cancel_button"), button -> this.field_22787.method_1507(null)).method_46434(panelX + 30 + buttonWidth + 30, panelY + 190, buttonWidth, 20).method_46431());
    }

    private boolean validateInputs() {
        String url = this.urlInput.method_1882().trim();
        try {
            int width = Integer.parseInt(this.widthInput.method_1882());
            int height = Integer.parseInt(this.heightInput.method_1882());
            if (width <= 0 || height <= 0) {
                this.setError(class_2561.method_43471((String)"picaxe.screen.image_frame.error.negative_dimensions").getString());
                return false;
            }
            if (width > 6 || height > 6) {
                this.setError(class_2561.method_43471((String)"picaxe.screen.image_frame.error.dimensions_too_large").getString());
                return false;
            }
        }
        catch (NumberFormatException e) {
            this.setError(class_2561.method_43471((String)"picaxe.screen.image_frame.error.invalid_dimensions").getString());
            return false;
        }
        return true;
    }

    private void setError(String message) {
        this.errorMessage = message;
        this.errorTimer = 60;
    }

    private class_2561 getStretchButtonText() {
        class_5250 icon = this.shouldStretch ? class_2561.method_43471((String)"picaxe.screen.image_frame.stretch_icon_on") : class_2561.method_43471((String)"picaxe.screen.image_frame.stretch_icon_off");
        class_5250 state = this.shouldStretch ? class_2561.method_43471((String)"picaxe.screen.image_frame.stretch_on") : class_2561.method_43471((String)"picaxe.screen.image_frame.stretch_off");
        return icon.method_27661().method_10852((class_2561)class_2561.method_43469((String)"picaxe.screen.image_frame.stretch_mode", (Object[])new Object[]{state}));
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        this.urlValue = this.urlInput.method_1882();
        this.widthValue = this.widthInput.method_1882();
        this.heightValue = this.heightInput.method_1882();
        boolean wasUrlChanged = this.urlChanged;
        this.method_25423(minecraft, width, height);
        this.urlChanged = wasUrlChanged;
    }

    public void method_25393() {
        super.method_25393();
        if (this.errorTimer > 0) {
            --this.errorTimer;
        }
        this.animationProgress = Math.min(1.0f, this.animationProgress + 0.1f);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        float alpha = class_3532.method_16439((float)partialTick, (float)(this.animationProgress - 0.1f), (float)this.animationProgress);
        guiGraphics.method_25294(0, 0, this.field_22789, this.field_22790, -436207616);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int panelWidth = 360;
        int panelHeight = 240;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        guiGraphics.method_25294(panelX + 2, panelY + 2, panelX + panelWidth + 2, panelY + panelHeight + 2, 0x44000000);
        guiGraphics.method_25294(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -870704614);
        guiGraphics.method_25294(panelX, panelY, panelX + panelWidth, panelY + 3, -13330213);
        guiGraphics.method_27534(this.field_22793, this.field_22785, centerX, panelY + 15, -1);
        guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.subtitle"), centerX, panelY + 30, -7829368);
        guiGraphics.method_25294(panelX + 30, panelY + 50, panelX + panelWidth - 30, panelY + 51, 0x44FFFFFF);
        this.renderInputBackground(guiGraphics, panelX + 30, panelY + 65, panelWidth - 90, 20, this.urlInput.method_25370());
        int inputWidth = (panelWidth - 90) / 2;
        this.renderInputBackground(guiGraphics, panelX + 30, panelY + 115, inputWidth, 20, this.widthInput.method_25370());
        this.renderInputBackground(guiGraphics, panelX + 30 + inputWidth + 30, panelY + 115, inputWidth, 20, this.heightInput.method_25370());
        guiGraphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.url_label"), panelX + 30, panelY + 52, -7829368);
        guiGraphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"picaxe.screen.image_frame.dimensions_label"), panelX + 30, panelY + 102, -7829368);
        if (this.urlInput.method_1882().trim().isEmpty()) {
            guiGraphics.method_25294(panelX + 10, panelY + 65, panelX + 13, panelY + 85, -38091);
            class_5250 removeMode = class_2561.method_43471((String)"picaxe.screen.image_frame.remove_mode");
            guiGraphics.method_27535(this.field_22793, (class_2561)removeMode, panelX + 30, panelY + 90, -38091);
        } else if (this.urlChanged) {
            guiGraphics.method_25294(panelX + 10, panelY + 65, panelX + 13, panelY + 85, -13710223);
        }
        if (this.errorTimer > 0 && !this.errorMessage.isEmpty()) {
            int errorAlpha = Math.min(255, this.errorTimer * 255 / 60);
            int errorColor = errorAlpha << 24 | 0xE74C3C;
            guiGraphics.method_25300(this.field_22793, this.errorMessage, centerX, panelY + panelHeight - 15, errorColor);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.urlInput.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.widthInput.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.heightInput.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderInputBackground(class_332 guiGraphics, int x, int y, int width, int height, boolean focused) {
        int bgColor = focused ? -14013910 : -14737633;
        int borderColor = focused ? -13330213 : -12961222;
        guiGraphics.method_25294(x, y, x + width, y + height, bgColor);
        guiGraphics.method_25294(x - 1, y - 1, x + width + 1, y, borderColor);
        guiGraphics.method_25294(x - 1, y + height, x + width + 1, y + height + 1, borderColor);
        guiGraphics.method_25294(x - 1, y, x, y + height, borderColor);
        guiGraphics.method_25294(x + width, y, x + width + 1, y + height, borderColor);
    }

    public boolean method_25421() {
        return false;
    }
}

