/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.gui;

import net.blay09.mods.balm.api.Balm;
import net.jacobwasbeast.picaxe.items.PicAxeItem;
import net.jacobwasbeast.picaxe.network.UpdatePicAxeUrlPayload;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_8710;

public class URLInputScreen
extends class_437 {
    private static final int BACKGROUND_COLOR = -436207616;
    private static final int PANEL_COLOR = -870704614;
    private static final int ACCENT_COLOR = -13330213;
    private static final int TEXT_COLOR = -1;
    private static final int SUBTITLE_COLOR = -7829368;
    private static final int ERROR_COLOR = -1618884;
    private static final int SUCCESS_COLOR = -13710223;
    private static final int REMOVE_COLOR = -38091;
    private final class_1268 hand;
    private class_342 urlInput;
    private class_4185 confirmButton;
    private class_4185 cancelButton;
    private class_4185 clearButton;
    private String currentUrl;
    private String errorMessage = "";
    private int errorTimer = 0;
    private float animationProgress = 0.0f;
    private boolean urlChanged = false;

    public URLInputScreen(class_1657 player, class_1268 hand) {
        super((class_2561)class_2561.method_43471((String)"picaxe.screen.url_input.title"));
        this.hand = hand;
        class_1799 itemStack = player.method_5998(hand);
        this.currentUrl = PicAxeItem.getURL(itemStack);
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int panelWidth = 360;
        int panelHeight = 180;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        this.urlInput = new class_342(this.field_22793, panelX + 30, panelY + 65, panelWidth - 90, 20, (class_2561)class_2561.method_43471((String)"picaxe.screen.url_input.url"));
        this.urlInput.method_1880(256);
        this.urlInput.method_1852(this.currentUrl);
        this.urlInput.method_47404((class_2561)class_2561.method_43471((String)"picaxe.screen.url_input.hint"));
        this.urlInput.method_1858(false);
        this.urlInput.method_1863(text -> {
            this.urlChanged = !text.equals(this.currentUrl);
        });
        this.method_25429((class_364)this.urlInput);
        this.method_48265((class_364)this.urlInput);
        this.clearButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"picaxe.screen.url_input.clear_icon"), button -> {
            this.urlInput.method_1852("");
            this.urlChanged = true;
        }).method_46434(panelX + panelWidth - 55, panelY + 65, 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"picaxe.screen.url_input.clear_tooltip"))).method_46431());
        int buttonWidth = (panelWidth - 90) / 2;
        this.confirmButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"picaxe.screen.url_input.confirm_button"), button -> {
            if (this.validateInput()) {
                Balm.getNetworking().sendToServer((class_8710)new UpdatePicAxeUrlPayload(this.urlInput.method_1882(), this.hand));
                this.field_22787.method_1507(null);
            }
        }).method_46434(panelX + 30, panelY + 130, buttonWidth, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"picaxe.screen.url_input.confirm_tooltip"))).method_46431());
        this.cancelButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"picaxe.screen.url_input.cancel_button"), button -> this.field_22787.method_1507(null)).method_46434(panelX + 30 + buttonWidth + 30, panelY + 130, buttonWidth, 20).method_46431());
    }

    private boolean validateInput() {
        String url = this.urlInput.method_1882().trim();
        if (url.isEmpty()) {
            return true;
        }
        if (!this.isValidUrl(url)) {
            this.setError(class_2561.method_43471((String)"picaxe.screen.url_input.error.invalid").getString());
            return false;
        }
        return true;
    }

    private boolean isValidUrl(String url) {
        return url.startsWith("http://") || url.startsWith("https://") || url.startsWith("file://") || url.endsWith(".png") || url.endsWith(".jpg") || url.endsWith(".jpeg") || url.endsWith(".gif") || url.endsWith(".webp");
    }

    private void setError(String message) {
        this.errorMessage = message;
        this.errorTimer = 60;
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        String s = this.urlInput.method_1882();
        this.method_25423(minecraft, width, height);
        this.urlInput.method_1852(s);
    }

    public void method_25393() {
        super.method_25393();
        if (this.errorTimer > 0) {
            --this.errorTimer;
        }
        this.animationProgress = Math.min(1.0f, this.animationProgress + 0.1f);
    }

    public void method_25419() {
        super.method_25419();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        float alpha = class_3532.method_16439((float)partialTick, (float)(this.animationProgress - 0.1f), (float)this.animationProgress);
        guiGraphics.method_25294(0, 0, this.field_22789, this.field_22790, -436207616);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int panelWidth = 360;
        int panelHeight = 180;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        guiGraphics.method_25294(panelX + 2, panelY + 2, panelX + panelWidth + 2, panelY + panelHeight + 2, 0x44000000);
        guiGraphics.method_25294(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -870704614);
        guiGraphics.method_25294(panelX, panelY, panelX + panelWidth, panelY + 3, -13330213);
        guiGraphics.method_27534(this.field_22793, this.field_22785, centerX, panelY + 15, -1);
        guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"picaxe.screen.url_input.subtitle"), centerX, panelY + 30, -7829368);
        guiGraphics.method_25294(panelX + 30, panelY + 50, panelX + panelWidth - 30, panelY + 51, 0x44FFFFFF);
        this.renderInputBackground(guiGraphics, panelX + 30, panelY + 65, panelWidth - 90, 20, this.urlInput.method_25370());
        guiGraphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"picaxe.screen.url_input.label"), panelX + 30, panelY + 52, -7829368);
        if (!this.currentUrl.isEmpty() && this.urlChanged) {
            class_5250 currentLabel = class_2561.method_43469((String)"picaxe.screen.url_input.current", (Object[])new Object[]{this.currentUrl.length() > 40 ? this.currentUrl.substring(0, 37) + "..." : this.currentUrl});
            guiGraphics.method_27535(this.field_22793, (class_2561)currentLabel, panelX + 30, panelY + 95, -10066330);
        }
        if (this.urlChanged) {
            int statusColor = this.urlInput.method_1882().trim().isEmpty() ? -1618884 : -13710223;
            guiGraphics.method_25294(panelX + 10, panelY + 65, panelX + 13, panelY + 85, statusColor);
        }
        if (this.errorTimer > 0 && !this.errorMessage.isEmpty()) {
            int errorAlpha = Math.min(255, this.errorTimer * 255 / 60);
            int errorColor = errorAlpha << 24 | 0xE74C3C;
            guiGraphics.method_25300(this.field_22793, this.errorMessage, centerX, panelY + 110, errorColor);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.urlInput.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderInputBackground(class_332 guiGraphics, int x, int y, int width, int height, boolean focused) {
        int bgColor = focused ? -14013910 : -14737633;
        int borderColor = focused ? -13330213 : -12961222;
        guiGraphics.method_25294(x, y, x + width, y + height, bgColor);
        guiGraphics.method_25294(x - 1, y - 1, x + width + 1, y, borderColor);
        guiGraphics.method_25294(x - 1, y + height, x + width + 1, y + height + 1, borderColor);
        guiGraphics.method_25294(x - 1, y, x, y + height, borderColor);
        guiGraphics.method_25294(x + width, y, x + width + 1, y + height, borderColor);
    }

    public boolean method_25421() {
        return false;
    }
}

