/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.items;

import java.util.function.Consumer;
import net.jacobwasbeast.picaxe.api.BannerRenderTypes;
import net.jacobwasbeast.picaxe.api.BedRenderTypes;
import net.jacobwasbeast.picaxe.blocks.ImageBannerBlock;
import net.jacobwasbeast.picaxe.blocks.ImageBedBlock;
import net.jacobwasbeast.picaxe.blocks.ImageFrameBlock;
import net.jacobwasbeast.picaxe.blocks.ImageWallBannerBlock;
import net.jacobwasbeast.picaxe.blocks.ModBlocks;
import net.jacobwasbeast.picaxe.blocks.SixSidedImageBlock;
import net.jacobwasbeast.picaxe.blocks.entities.ImageBannerBlockEntity;
import net.jacobwasbeast.picaxe.blocks.entities.ImageBedBlockEntity;
import net.jacobwasbeast.picaxe.blocks.entities.ImageFrameBlockEntity;
import net.jacobwasbeast.picaxe.blocks.entities.SixSidedImageBlockEntity;
import net.jacobwasbeast.picaxe.component.ModDataComponents;
import net.jacobwasbeast.picaxe.utils.ClientUtils;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2185;
import net.minecraft.class_2215;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2546;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2587;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_9331;
import net.minecraft.class_9886;

public class PicAxeItem
extends class_1743 {
    public static final String DEFAULT_URL = "picaxe:blocks/bed";

    public PicAxeItem(class_1792.class_1793 properties) {
        super(class_9886.field_52587, 1.0f, 1.0f, properties.method_7889(1).method_7895(100).method_57349((class_9331)ModDataComponents.IMAGE_URL.get(), (Object)DEFAULT_URL));
    }

    public static void setURL(class_1799 stack, String url) {
        if (stack.method_7909() instanceof PicAxeItem) {
            stack.method_57379((class_9331)ModDataComponents.IMAGE_URL.get(), (Object)url);
        }
    }

    public static String getURL(class_1799 stack) {
        return (String)stack.method_58695((class_9331)ModDataComponents.IMAGE_URL.get(), (Object)DEFAULT_URL);
    }

    public class_1269 method_7884(class_1838 useOnContext) {
        class_1657 player = useOnContext.method_8036();
        if (player == null) {
            return class_1269.field_5814;
        }
        if (player.method_18276()) {
            if (useOnContext.method_8045().field_9236) {
                class_1268 hand = player.method_6058();
                ClientUtils.OpenURLInputScreen(player, hand);
            }
            return class_1269.field_5811;
        }
        class_1937 level = useOnContext.method_8045();
        class_2338 clickedPos = useOnContext.method_8037();
        class_2680 blockState = level.method_8320(clickedPos);
        class_2248 block = blockState.method_26204();
        class_1799 heldStack = useOnContext.method_8041();
        if (block instanceof SixSidedImageBlock) {
            if (player.method_7357().method_7904(heldStack)) {
                return class_1269.field_5814;
            }
            player.method_7357().method_62835(heldStack, 20);
            class_2586 class_25862 = level.method_8321(clickedPos);
            if (class_25862 instanceof SixSidedImageBlockEntity) {
                SixSidedImageBlockEntity imageBlockEntity = (SixSidedImageBlockEntity)class_25862;
                class_2350 face = useOnContext.method_8038();
                String imageUrl = PicAxeItem.getURL(heldStack);
                imageBlockEntity.setImageUrl(face, imageUrl);
                if (imageUrl.isEmpty()) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"picaxe.image_block.remove_face", (Object[])new Object[]{face.method_10151()}), true);
                } else {
                    player.method_7353((class_2561)class_2561.method_43469((String)"picaxe.image_block.set_face", (Object[])new Object[]{face.method_10151(), imageUrl}), true);
                }
            }
            return class_1269.field_5812;
        }
        if (block instanceof ImageFrameBlock) {
            class_2586 face;
            if (level.field_9236 && (face = level.method_8321(clickedPos)) instanceof ImageFrameBlockEntity) {
                ImageFrameBlockEntity imageFrameEntity = (ImageFrameBlockEntity)face;
                imageFrameEntity.setConfiguration(imageFrameEntity.getImageUrl(), imageFrameEntity.getFrameWidth(), imageFrameEntity.getFrameHeight(), imageFrameEntity.shouldStretchToFit());
                ClientUtils.OpenImageFrameConfig(player, imageFrameEntity);
            }
            return class_1269.field_5812;
        }
        if (block instanceof class_2244) {
            if (player.method_7357().method_7904(heldStack)) {
                return class_1269.field_5814;
            }
            player.method_7357().method_62835(heldStack, 20);
            if (block instanceof ImageBedBlock) {
                class_2338 headPos = blockState.method_11654((class_2769)class_2244.field_9967) == class_2742.field_12557 ? clickedPos.method_10093((class_2350)blockState.method_11654((class_2769)class_2244.field_11177)) : clickedPos;
                Object imageUrl = level.method_8321(headPos);
                if (imageUrl instanceof ImageBedBlockEntity) {
                    ImageBedBlockEntity imageBedEntity = (ImageBedBlockEntity)((Object)imageUrl);
                    imageUrl = PicAxeItem.getURL(heldStack);
                    if (imageBedEntity.getImageLocation().equals(imageUrl)) {
                        int max = BedRenderTypes.values().length;
                        int currentIndex = imageBedEntity.getRenderTypes().ordinal();
                        int nextIndex = (currentIndex + 1) % max;
                        imageBedEntity.setRenderTypes(BedRenderTypes.values()[nextIndex]);
                        player.method_7353((class_2561)class_2561.method_43469((String)"picaxe.image_bed.render_type", (Object[])new Object[]{imageBedEntity.getRenderTypes().name().toLowerCase()}), true);
                    } else {
                        imageBedEntity.setImageLocation((String)imageUrl);
                        player.method_7353((class_2561)class_2561.method_43469((String)"picaxe.image_bed.set", (Object[])new Object[]{imageUrl}), true);
                    }
                }
            } else {
                this.updateBedEntity(blockState, clickedPos, level, heldStack);
                player.method_7353((class_2561)class_2561.method_43469((String)"picaxe.image_bed.set", (Object[])new Object[]{PicAxeItem.getURL(heldStack)}), true);
            }
            return class_1269.field_5812;
        }
        if (block instanceof class_2185) {
            if (player.method_7357().method_7904(heldStack)) {
                return class_1269.field_5814;
            }
            player.method_7357().method_62835(heldStack, 20);
            if (block instanceof ImageBannerBlock || block instanceof ImageWallBannerBlock) {
                class_2586 imageBedEntity = level.method_8321(clickedPos);
                if (imageBedEntity instanceof ImageBannerBlockEntity) {
                    ImageBannerBlockEntity imageBannerEntity = (ImageBannerBlockEntity)imageBedEntity;
                    String imageUrl = PicAxeItem.getURL(heldStack);
                    if (imageBannerEntity.getImageLocation().equals(imageUrl)) {
                        int max = BannerRenderTypes.values().length;
                        if (max > 0) {
                            int currentIndex = imageBannerEntity.getRenderTypes().ordinal();
                            int nextIndex = (currentIndex + 1) % max;
                            imageBannerEntity.setRenderTypes(BannerRenderTypes.values()[nextIndex]);
                            player.method_7353((class_2561)class_2561.method_43469((String)"picaxe.image_banner.render_type", (Object[])new Object[]{imageBannerEntity.getRenderTypes().name().toLowerCase()}), true);
                        } else {
                            player.method_7353((class_2561)class_2561.method_43471((String)"picaxe.image_banner.already_set"), true);
                        }
                    } else {
                        imageBannerEntity.setImageLocation(imageUrl);
                        player.method_7353((class_2561)class_2561.method_43469((String)"picaxe.image_banner.set", (Object[])new Object[]{imageUrl}), true);
                    }
                }
            } else {
                this.updateBannerEntity(blockState, clickedPos, level, heldStack);
                player.method_7353((class_2561)class_2561.method_43469((String)"picaxe.image_banner.set", (Object[])new Object[]{PicAxeItem.getURL(heldStack)}), true);
            }
            return class_1269.field_5812;
        }
        return super.method_7884(useOnContext);
    }

    public void updateBedEntity(class_2680 blockState, class_2338 clickedPos, class_1937 level, class_1799 stack) {
        class_2338 headPosForColor = blockState.method_11654((class_2769)class_2244.field_9967) == class_2742.field_12560 ? clickedPos : clickedPos.method_10093((class_2350)blockState.method_11654((class_2769)class_2244.field_11177));
        class_1767 color = class_1767.field_7952;
        class_2586 class_25862 = level.method_8321(headPosForColor);
        if (class_25862 instanceof class_2587) {
            class_2587 bedEntity = (class_2587)class_25862;
            color = bedEntity.method_11018();
        }
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)class_2244.field_11177);
        class_2742 part = (class_2742)blockState.method_11654((class_2769)class_2244.field_9967);
        class_2338 otherPartPos = part == class_2742.field_12560 ? clickedPos.method_10093(facing.method_10153()) : clickedPos.method_10093(facing);
        ImageBedBlock imageBed = ModBlocks.IMAGE_BED_BLOCK;
        class_2680 newFoot = (class_2680)((class_2680)imageBed.method_9564().method_11657((class_2769)class_2244.field_11177, (Comparable)facing)).method_11657((class_2769)class_2244.field_9967, (Comparable)class_2742.field_12557);
        class_2680 newHead = (class_2680)((class_2680)imageBed.method_9564().method_11657((class_2769)class_2244.field_11177, (Comparable)facing)).method_11657((class_2769)class_2244.field_9967, (Comparable)class_2742.field_12560);
        class_2338 headPos = part == class_2742.field_12560 ? clickedPos : otherPartPos;
        class_2338 footPos = part == class_2742.field_12557 ? clickedPos : otherPartPos;
        level.method_8652(footPos, class_2246.field_10124.method_9564(), 18);
        level.method_8652(headPos, class_2246.field_10124.method_9564(), 18);
        level.method_8652(footPos, newFoot, 3);
        level.method_8652(headPos, newHead, 3);
        class_2586 class_25863 = level.method_8321(headPos);
        if (class_25863 instanceof ImageBedBlockEntity) {
            ImageBedBlockEntity imageBedEntity = (ImageBedBlockEntity)class_25863;
            imageBedEntity.setColor(color);
            imageBedEntity.setImageLocation(PicAxeItem.getURL(stack));
        }
    }

    public void updateBannerEntity(class_2680 blockState, class_2338 clickedPos, class_1937 level, class_1799 stack) {
        class_2680 newState;
        if (level.method_8608()) {
            return;
        }
        class_2248 block = blockState.method_26204();
        if (!(block instanceof class_2215) && !(block instanceof class_2546)) {
            return;
        }
        class_1767 color = block instanceof class_2546 ? ((class_2546)block).method_9303() : (block instanceof class_2215 ? ((class_2215)block).method_9303() : class_1767.field_7952);
        if (block instanceof class_2546) {
            ImageWallBannerBlock newBlock = ModBlocks.IMAGE_WALL_BANNER_BLOCK;
            newState = (class_2680)newBlock.method_9564().method_11657((class_2769)class_2546.field_11722, (Comparable)((class_2350)blockState.method_11654((class_2769)class_2546.field_11722)));
        } else {
            ImageBannerBlock newBlock = ModBlocks.IMAGE_BANNER_BLOCK;
            newState = (class_2680)newBlock.method_9564().method_11657((class_2769)class_2215.field_9924, (Comparable)((Integer)blockState.method_11654((class_2769)class_2215.field_9924)));
        }
        level.method_8652(clickedPos, newState, 3);
        class_2586 class_25862 = level.method_8321(clickedPos);
        if (class_25862 instanceof ImageBannerBlockEntity) {
            ImageBannerBlockEntity imageBannerEntity = (ImageBannerBlockEntity)class_25862;
            imageBannerEntity.setColor(color);
            imageBannerEntity.setImageLocation(PicAxeItem.getURL(stack));
        }
    }

    public void method_67187(class_1799 itemStack, class_1792.class_9635 tooltipContext, class_10712 tooltipDisplay, Consumer<class_2561> consumer, class_1836 tooltipFlag) {
        super.method_67187(itemStack, tooltipContext, tooltipDisplay, consumer, tooltipFlag);
        consumer.accept((class_2561)class_2561.method_43470((String)"URL: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)PicAxeItem.getURL(itemStack)).method_27692(class_124.field_1075)));
        consumer.accept((class_2561)class_2561.method_43473());
        consumer.accept((class_2561)class_2561.method_43471((String)"tooltip.picaxe.when_used").method_27692(class_124.field_1063));
        consumer.accept((class_2561)class_2561.method_43471((String)"tooltip.picaxe.use_action").method_27692(class_124.field_1054));
        consumer.accept((class_2561)class_2561.method_43471((String)"tooltip.picaxe.sneak_use_action").method_27692(class_124.field_1054));
    }
}

