/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.gui;

import net.blay09.mods.balm.api.Balm;
import net.jacobwasbeast.picaxe.items.PicAxeItem;
import net.jacobwasbeast.picaxe.network.UpdatePicAxeUrlPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class URLInputScreen
extends Screen {
    private static final int BACKGROUND_COLOR = -436207616;
    private static final int PANEL_COLOR = -870704614;
    private static final int ACCENT_COLOR = -13330213;
    private static final int TEXT_COLOR = -1;
    private static final int SUBTITLE_COLOR = -7829368;
    private static final int ERROR_COLOR = -1618884;
    private static final int SUCCESS_COLOR = -13710223;
    private static final int REMOVE_COLOR = -38091;
    private final InteractionHand hand;
    private EditBox urlInput;
    private Button confirmButton;
    private Button cancelButton;
    private Button clearButton;
    private String currentUrl;
    private String errorMessage = "";
    private int errorTimer = 0;
    private float animationProgress = 0.0f;
    private boolean urlChanged = false;

    public URLInputScreen(Player player, InteractionHand hand) {
        super((Component)Component.translatable((String)"picaxe.screen.url_input.title"));
        this.hand = hand;
        ItemStack itemStack = player.getItemInHand(hand);
        this.currentUrl = PicAxeItem.getURL(itemStack);
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 360;
        int panelHeight = 180;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        this.urlInput = new EditBox(this.font, panelX + 30, panelY + 65, panelWidth - 90, 20, (Component)Component.translatable((String)"picaxe.screen.url_input.url"));
        this.urlInput.setMaxLength(256);
        this.urlInput.setValue(this.currentUrl);
        this.urlInput.setHint((Component)Component.translatable((String)"picaxe.screen.url_input.hint"));
        this.urlInput.setBordered(false);
        this.urlInput.setResponder(text -> {
            this.urlChanged = !text.equals(this.currentUrl);
        });
        this.addWidget((GuiEventListener)this.urlInput);
        this.setInitialFocus((GuiEventListener)this.urlInput);
        this.clearButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"picaxe.screen.url_input.clear_icon"), button -> {
            this.urlInput.setValue("");
            this.urlChanged = true;
        }).bounds(panelX + panelWidth - 55, panelY + 65, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"picaxe.screen.url_input.clear_tooltip"))).build());
        int buttonWidth = (panelWidth - 90) / 2;
        this.confirmButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"picaxe.screen.url_input.confirm_button"), button -> {
            if (this.validateInput()) {
                Balm.getNetworking().sendToServer((CustomPacketPayload)new UpdatePicAxeUrlPayload(this.urlInput.getValue(), this.hand));
                this.minecraft.setScreen(null);
            }
        }).bounds(panelX + 30, panelY + 130, buttonWidth, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"picaxe.screen.url_input.confirm_tooltip"))).build());
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"picaxe.screen.url_input.cancel_button"), button -> this.minecraft.setScreen(null)).bounds(panelX + 30 + buttonWidth + 30, panelY + 130, buttonWidth, 20).build());
    }

    private boolean validateInput() {
        String url = this.urlInput.getValue().trim();
        if (url.isEmpty()) {
            return true;
        }
        if (!this.isValidUrl(url)) {
            this.setError(Component.translatable((String)"picaxe.screen.url_input.error.invalid").getString());
            return false;
        }
        return true;
    }

    private boolean isValidUrl(String url) {
        return url.startsWith("http://") || url.startsWith("https://") || url.startsWith("file://") || url.endsWith(".png") || url.endsWith(".jpg") || url.endsWith(".jpeg") || url.endsWith(".gif") || url.endsWith(".webp");
    }

    private void setError(String message) {
        this.errorMessage = message;
        this.errorTimer = 60;
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String s = this.urlInput.getValue();
        this.init(minecraft, width, height);
        this.urlInput.setValue(s);
    }

    public void tick() {
        super.tick();
        if (this.errorTimer > 0) {
            --this.errorTimer;
        }
        this.animationProgress = Math.min(1.0f, this.animationProgress + 0.1f);
    }

    public void onClose() {
        super.onClose();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.urlInput.render(guiGraphics, mouseX, mouseY, partialTick);
        float alpha = Mth.lerp((float)partialTick, (float)(this.animationProgress - 0.1f), (float)this.animationProgress);
        guiGraphics.fill(0, 0, this.width, this.height, -436207616);
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 360;
        int panelHeight = 180;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        guiGraphics.fill(panelX + 2, panelY + 2, panelX + panelWidth + 2, panelY + panelHeight + 2, 0x44000000);
        guiGraphics.fill(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -870704614);
        guiGraphics.fill(panelX, panelY, panelX + panelWidth, panelY + 3, -13330213);
        guiGraphics.drawCenteredString(this.font, this.title, centerX, panelY + 15, -1);
        guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"picaxe.screen.url_input.subtitle"), centerX, panelY + 30, -7829368);
        guiGraphics.fill(panelX + 30, panelY + 50, panelX + panelWidth - 30, panelY + 51, 0x44FFFFFF);
        this.renderInputBackground(guiGraphics, panelX + 30, panelY + 65, panelWidth - 90, 20, this.urlInput.isFocused());
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"picaxe.screen.url_input.label"), panelX + 30, panelY + 52, -7829368);
        if (!this.currentUrl.isEmpty() && this.urlChanged) {
            MutableComponent currentLabel = Component.translatable((String)"picaxe.screen.url_input.current", (Object[])new Object[]{this.currentUrl.length() > 40 ? this.currentUrl.substring(0, 37) + "..." : this.currentUrl});
            guiGraphics.drawString(this.font, (Component)currentLabel, panelX + 30, panelY + 95, -10066330);
        }
        if (this.urlChanged) {
            int statusColor = this.urlInput.getValue().trim().isEmpty() ? -1618884 : -13710223;
            guiGraphics.fill(panelX + 10, panelY + 65, panelX + 13, panelY + 85, statusColor);
        }
        if (this.errorTimer > 0 && !this.errorMessage.isEmpty()) {
            int errorAlpha = Math.min(255, this.errorTimer * 255 / 60);
            int errorColor = errorAlpha << 24 | 0xE74C3C;
            guiGraphics.drawCenteredString(this.font, this.errorMessage, centerX, panelY + 110, errorColor);
        }
    }

    private void renderInputBackground(GuiGraphics guiGraphics, int x, int y, int width, int height, boolean focused) {
        int bgColor = focused ? -14013910 : -14737633;
        int borderColor = focused ? -13330213 : -12961222;
        guiGraphics.fill(x, y, x + width, y + height, bgColor);
        guiGraphics.fill(x - 1, y - 1, x + width + 1, y, borderColor);
        guiGraphics.fill(x - 1, y + height, x + width + 1, y + height + 1, borderColor);
        guiGraphics.fill(x - 1, y, x, y + height, borderColor);
        guiGraphics.fill(x + width, y, x + width + 1, y + height, borderColor);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

