/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import net.jacobwasbeast.picaxe.blocks.entities.SixSidedImageBlockEntity;
import net.jacobwasbeast.picaxe.items.SixSidedImageBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class SixSidedImageBlock
extends BaseEntityBlock {
    public static final MapCodec<SixSidedImageBlock> CODEC = SixSidedImageBlock.simpleCodec(SixSidedImageBlock::new);

    public SixSidedImageBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(3.0f));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SixSidedImageBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof SixSidedImageBlockEntity) {
            SixSidedImageBlockEntity fourSided = (SixSidedImageBlockEntity)blockEntity;
            ItemStack itemStackToDrop = SixSidedImageBlockItem.create(fourSided.getImages());
            return Collections.singletonList(itemStackToDrop);
        }
        return super.getDrops(state, builder);
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos blockPos, BlockState blockState) {
        level.levelEvent((Entity)player, 2001, blockPos, SixSidedImageBlock.getId((BlockState)Blocks.OAK_PLANKS.defaultBlockState()));
    }
}

