/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.entities;

import net.jacobwasbeast.picaxe.api.BedRenderTypes;
import net.jacobwasbeast.picaxe.blocks.ModBlocks;
import net.jacobwasbeast.picaxe.blocks.entities.ModBlockEntities;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ImageBedBlockEntity
extends BlockEntity {
    public DyeColor color;
    private String imageLocation;
    public BedRenderTypes renderTypes = BedRenderTypes.DRAPE_SIDES_FULL;

    public ImageBedBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.IMAGE_BED_BLOCK_ENTITY.get(), blockPos, blockState);
        this.color = DyeColor.WHITE;
        this.imageLocation = "picaxe:blocks/bed";
        this.renderTypes = BedRenderTypes.DRAPE_SIDES_FULL;
    }

    public ImageBedBlockEntity(BlockPos blockPos, BlockState blockState, DyeColor dyeColor) {
        super((BlockEntityType)ModBlockEntities.IMAGE_BED_BLOCK_ENTITY.get(), blockPos, blockState);
        this.color = dyeColor;
        this.imageLocation = "picaxe:blocks/bed";
        this.renderTypes = BedRenderTypes.DRAPE_SIDES_FULL;
    }

    public ImageBedBlockEntity(BlockEntityRendererProvider.Context context) {
        super((BlockEntityType)ModBlockEntities.IMAGE_BED_BLOCK_ENTITY.get(), BlockPos.ZERO, ModBlocks.IMAGE_BED_BLOCK.defaultBlockState());
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putString("imageLocation", this.imageLocation);
        compoundTag.putString("color", this.color.getName());
        if (this.renderTypes != null) {
            compoundTag.putString("renderTypes", this.renderTypes.name());
        } else {
            compoundTag.putString("renderTypes", BedRenderTypes.DRAPE_SIDES_FULL.name());
        }
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.imageLocation = (String)compoundTag.getString("imageLocation").get();
        if (!compoundTag.contains("imageLocation")) {
            this.imageLocation = "picaxe:blocks/bed";
        }
        this.color = DyeColor.byName((String)((String)compoundTag.getString("color").get()), (DyeColor)DyeColor.WHITE);
        if (!compoundTag.contains("color")) {
            this.color = DyeColor.WHITE;
        }
        if (compoundTag.contains("renderTypes")) {
            try {
                this.renderTypes = BedRenderTypes.valueOf((String)compoundTag.getString("renderTypes").get());
            }
            catch (IllegalArgumentException e) {
                this.renderTypes = BedRenderTypes.DRAPE_SIDES_FULL;
            }
        } else {
            this.renderTypes = BedRenderTypes.DRAPE_SIDES_FULL;
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public DyeColor getColor() {
        return this.color;
    }

    public BedRenderTypes getRenderTypes() {
        return this.renderTypes;
    }

    public void setColor(DyeColor dyeColor) {
        this.color = dyeColor;
        if (this.level != null && !this.level.isClientSide) {
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void setRenderTypes(BedRenderTypes renderTypes) {
        this.renderTypes = renderTypes;
        if (this.level != null && !this.level.isClientSide) {
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void setImageLocation(String url) {
        this.imageLocation = url;
        if (this.level != null && !this.level.isClientSide()) {
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void loadFromItemStackComponents(ItemStack copy) {
        if (copy.has(DataComponents.BLOCK_ENTITY_DATA)) {
            CompoundTag tag = ((CustomData)copy.get(DataComponents.BLOCK_ENTITY_DATA)).copyTag();
            if (tag.contains("imageLocation")) {
                this.imageLocation = (String)tag.getString("imageLocation").get();
            }
            if (tag.contains("color")) {
                this.color = DyeColor.byName((String)((String)tag.getString("color").get()), (DyeColor)DyeColor.WHITE);
            }
            if (tag.contains("renderTypes")) {
                try {
                    this.renderTypes = BedRenderTypes.valueOf((String)tag.getString("renderTypes").get());
                }
                catch (IllegalArgumentException e) {
                    this.renderTypes = BedRenderTypes.DRAPE_SIDES_FULL;
                }
            }
        } else {
            this.imageLocation = "picaxe:blocks/bed";
            this.color = DyeColor.WHITE;
            this.renderTypes = BedRenderTypes.DRAPE_SIDES_FULL;
        }
    }
}

