/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.entities;

import java.util.EnumMap;
import java.util.Map;
import net.jacobwasbeast.picaxe.blocks.entities.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SixSidedImageBlockEntity
extends BlockEntity {
    private final Map<Direction, String> imageUrls = new EnumMap<Direction, String>(Direction.class);

    public SixSidedImageBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SIX_SIDED_IMAGE_BLOCK_ENTITY.get(), pos, state);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            this.imageUrls.put(dir, "");
        }
        for (Direction dir : Direction.Plane.VERTICAL) {
            this.imageUrls.put(dir, "");
        }
    }

    public String getImageUrl(Direction direction) {
        return this.imageUrls.getOrDefault(direction, "");
    }

    public void setImageUrl(Direction direction, String url) {
        this.imageUrls.put(direction, url);
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("id", "picaxe:four_sided_image_block");
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            if (this.imageUrls.containsKey(dir)) {
                tag.putString("image_url_" + dir.getName(), this.imageUrls.get(dir));
                continue;
            }
            tag.putString("image_url_" + dir.getName(), "");
        }
        for (Direction dir : Direction.Plane.VERTICAL) {
            if (this.imageUrls.containsKey(dir)) {
                tag.putString("image_url_" + dir.getName(), this.imageUrls.get(dir));
                continue;
            }
            tag.putString("image_url_" + dir.getName(), "");
        }
    }

    protected void loadAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            if (tag.contains("image_url_" + dir.getName())) {
                this.imageUrls.put(dir, (String)tag.getString("image_url_" + dir.getName()).get());
                continue;
            }
            this.imageUrls.put(dir, "");
        }
        for (Direction dir : Direction.Plane.VERTICAL) {
            if (tag.contains("image_url_" + dir.getName())) {
                this.imageUrls.put(dir, (String)tag.getString("image_url_" + dir.getName()).get());
                continue;
            }
            this.imageUrls.put(dir, "");
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void loadFromItemStackComponents(ItemStack stack) {
        CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (customData != null) {
            this.loadAdditional(customData.copyTag(), null);
        } else {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                this.imageUrls.put(dir, "");
            }
            for (Direction dir : Direction.Plane.VERTICAL) {
                this.imageUrls.put(dir, "");
            }
        }
    }

    public Map<Direction, String> getImages() {
        return Map.copyOf(this.imageUrls);
    }
}

