/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.jacobwasbeast.picaxe.blocks.ImageBannerBlock;
import net.jacobwasbeast.picaxe.blocks.ImageWallBannerBlock;
import net.jacobwasbeast.picaxe.blocks.entities.ImageBannerBlockEntity;
import net.jacobwasbeast.picaxe.utils.ImageUtils;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class ImageBannerBlockRenderer
implements BlockEntityRenderer<ImageBannerBlockEntity> {
    private final ModelPart standingPole;
    private final ModelPart standingBar;
    private final ModelPart standingFlag;
    private final ModelPart wallBar;
    private final ModelPart wallFlag;

    public ImageBannerBlockRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart standingModelRoot = context.bakeLayer(ModelLayers.STANDING_BANNER);
        this.standingPole = standingModelRoot.getChild("pole");
        this.standingBar = standingModelRoot.getChild("bar");
        ModelPart flagModelRoot = context.bakeLayer(ModelLayers.STANDING_BANNER_FLAG);
        this.standingFlag = flagModelRoot.getChild("flag");
        ModelPart modelRoot2 = context.bakeLayer(ModelLayers.WALL_BANNER);
        this.wallBar = modelRoot2.getChild("bar");
        ModelPart flagModelRoot2 = context.bakeLayer(ModelLayers.STANDING_BANNER_FLAG);
        this.wallFlag = flagModelRoot2.getChild("flag");
    }

    public void render(ImageBannerBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 vec3) {
        boolean isWallBanner;
        boolean bl = isWallBanner = blockEntity.getBlockState().getBlock() instanceof ImageWallBannerBlock && blockEntity.getLevel() != null;
        if (isWallBanner) {
            this.renderWallBanner(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay, vec3);
        } else if (blockEntity.getBlockState().getBlock() instanceof ImageBannerBlock) {
            this.renderStanding(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay, vec3);
        }
    }

    public void renderStanding(ImageBannerBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 vec3) {
        String imageUrl = blockEntity.getImageLocation();
        BlockState blockState = blockEntity.getBlockState();
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        float yRotation = -RotationSegment.convertToDegrees((int)((Integer)blockState.getValue((Property)BannerBlock.ROTATION)));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(yRotation));
        poseStack.pushPose();
        poseStack.scale(0.6666667f, -0.6666667f, -0.6666667f);
        VertexConsumer poleAndBarConsumer = ModelBakery.BANNER_BASE.buffer(bufferSource, RenderType::entitySolid);
        this.standingPole.render(poseStack, poleAndBarConsumer, packedLight, packedOverlay);
        this.standingBar.render(poseStack, poleAndBarConsumer, packedLight, packedOverlay);
        long gameTime = 0L;
        if (blockEntity.getLevel() != null) {
            gameTime = blockEntity.getLevel().getGameTime();
        }
        BlockPos blockPos = blockEntity.getBlockPos();
        float f1 = ((float)Math.floorMod((long)(blockPos.getX() * 7 + blockPos.getY() * 9 + blockPos.getZ() * 13) + gameTime, 100L) + partialTick) / 100.0f;
        this.standingFlag.xRot = (-0.0125f + 0.01f * Mth.cos((float)((float)Math.PI * 2 * f1))) * (float)Math.PI;
        BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (int)packedOverlay, (ModelPart)this.standingFlag, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)blockEntity.getColor(), (BannerPatternLayers)BannerPatternLayers.EMPTY);
        if (imageUrl != null && !imageUrl.equals("picaxe:blocks/banner") && !imageUrl.isBlank()) {
            poseStack.pushPose();
            this.standingFlag.translateAndRotate(poseStack);
            poseStack.scale(-1.0f, 1.0f, 1.0f);
            poseStack.scale(0.1f, 0.1f, 0.1f);
            poseStack.scale(0.625f, 0.625f, 0.625f);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            poseStack.translate(-0.5f, -3.05f, -20.48f);
            ImageUtils.renderImageFromURL(poseStack, bufferSource, packedLight, packedOverlay, partialTick, 20.0f, 40.0f, imageUrl);
            poseStack.popPose();
        }
        poseStack.popPose();
        poseStack.popPose();
    }

    public void renderWallBanner(ImageBannerBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 vec3) {
        String imageUrl = blockEntity.getImageLocation();
        BlockState blockState = blockEntity.getBlockState();
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        float degrees = 0.0f;
        switch ((Direction)blockState.getValue((Property)WallBannerBlock.FACING)) {
            case NORTH: {
                degrees = 180.0f;
                break;
            }
            case SOUTH: {
                degrees = 0.0f;
                break;
            }
            case WEST: {
                degrees = -90.0f;
                break;
            }
            case EAST: {
                degrees = 90.0f;
            }
        }
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(degrees));
        poseStack.pushPose();
        poseStack.scale(0.6666667f, -0.6666667f, -0.6666667f);
        VertexConsumer poleAndBarConsumer = ModelBakery.BANNER_BASE.buffer(bufferSource, RenderType::entitySolid);
        this.wallBar.render(poseStack, poleAndBarConsumer, packedLight, packedOverlay);
        long gameTime = blockEntity.getLevel().getGameTime();
        BlockPos blockPos = blockEntity.getBlockPos();
        float f1 = ((float)Math.floorMod((long)(blockPos.getX() * 7 + blockPos.getY() * 9 + blockPos.getZ() * 13) + gameTime, 100L) + partialTick) / 100.0f;
        this.wallFlag.xRot = (-0.0125f + 0.01f * Mth.cos((float)((float)Math.PI * 2 * f1))) * (float)Math.PI;
        this.wallFlag.z = 10.5f;
        this.wallFlag.y = -20.5f;
        BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (int)packedOverlay, (ModelPart)this.wallFlag, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)blockEntity.getColor(), (BannerPatternLayers)BannerPatternLayers.EMPTY);
        if (imageUrl != null && !imageUrl.equals("picaxe:blocks/banner") && !imageUrl.isBlank()) {
            poseStack.pushPose();
            this.wallFlag.translateAndRotate(poseStack);
            poseStack.scale(-1.0f, 1.0f, 1.0f);
            poseStack.scale(0.1f, 0.1f, 0.1f);
            poseStack.scale(0.625f, 0.625f, 0.625f);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            poseStack.translate(-0.5f, -3.05f, -20.48f);
            ImageUtils.renderImageFromURL(poseStack, bufferSource, packedLight, packedOverlay, partialTick, 20.0f, 40.0f, imageUrl);
            poseStack.popPose();
        }
        poseStack.popPose();
        poseStack.popPose();
    }
}

