/*
 * Decompiled with CFR 0.152.
 */
package me.dery.scamreports.client;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;

@Environment(value=EnvType.CLIENT)
public class ScamReportsClient
implements ClientModInitializer {
    private static ScamReportsClient INSTANCE;
    private final Set<UUID> scammers = new HashSet<UUID>();

    public void onInitializeClient() {
        INSTANCE = this;
        try {
            HttpsURLConnection urlConnection = (HttpsURLConnection)new URL("https://scamsdonut.sparked.network/json").openConnection();
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(urlConnection.getInputStream()));
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginObject();
                reader.skipValue();
                reader.beginObject();
                while (reader.peek() != JsonToken.END_OBJECT) {
                    String name = reader.nextName();
                    if (name.equals("uuid")) {
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue;
                        }
                        String uuid = reader.nextString();
                        if (uuid.equals("null")) continue;
                        this.scammers.add(UUID.fromString(uuid.replaceFirst("([0-9A-Za-z]{8})([0-9A-Za-z]{4})([0-9A-Za-z]{4})([0-9A-Za-z]{4})([0-9A-Za-z]{12})", "$1-$2-$3-$4-$5")));
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                reader.endObject();
            }
            reader.endArray();
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            if (this.scammers.size() == 0) {
                client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_371)class_370.class_371.field_39915, (class_2561)class_2561.method_43470((String)"Scam-Reports not working"), (class_2561)class_2561.method_43470((String)"We couldn't load the scammer list. The mod will not work!")));
            }
        });
    }

    public boolean isScammer(UUID uuid) {
        return this.scammers.contains(uuid);
    }

    public static ScamReportsClient getINSTANCE() {
        return INSTANCE;
    }
}

