/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.morestatistics.network;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import me.fallenbreath.morestatistics.MoreStatisticsMod;
import me.fallenbreath.morestatistics.MoreStatisticsRegistry;
import me.fallenbreath.morestatistics.MoreStatisticsScoreboardCriterion;
import me.fallenbreath.morestatistics.network.MoreStatisticsPayload;
import me.fallenbreath.morestatistics.network.Network;
import me.fallenbreath.morestatistics.utils.IdentifierUtil;
import me.fallenbreath.morestatistics.utils.Util;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3445;

public class ServerHandler {
    private static final Object LOCK = new Object();
    private static final Map<class_3222, Set<class_2960>> acceptedStats = new WeakHashMap<class_3222, Set<class_2960>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleClientPacket(MoreStatisticsPayload payload, class_3222 player) {
        int id = payload.getPacketId();
        switch (id) {
            case 1: {
                class_2487 nbt = Objects.requireNonNull(payload.getNbt());
                List list = Util.nbt2StringList(Util.getNbtOrEmpty(nbt, "data")).stream().map(IdentifierUtil::of).collect(Collectors.toList());
                MoreStatisticsMod.LOGGER.debug("Received accepted stats list from player {}: {}", (Object)player.method_5477().getString(), list);
                Object object = LOCK;
                synchronized (object) {
                    acceptedStats.put(player, Sets.newHashSet(list));
                    break;
                }
            }
            case 2: {
                MoreStatisticsMod.LOGGER.debug("Received scoreboard criterion query from player {}", (Object)player.method_5477().getString());
                player.field_13987.method_14364((class_2596)Network.S2C.packet(1, nbt2 -> nbt2.method_10566("data", (class_2520)Util.stringList2Nbt(MoreStatisticsScoreboardCriterion.getCriterionNameList()))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canSendStat(class_3222 player, class_3445<?> stat) {
        Object key = stat.method_14951();
        if (key instanceof class_2960) {
            class_2960 statId = (class_2960)key;
            if (MoreStatisticsRegistry.getStatsSet().contains(statId)) {
                Object object = LOCK;
                synchronized (object) {
                    return acceptedStats.getOrDefault(player, Collections.emptySet()).contains(statId);
                }
            }
        }
        return true;
    }
}

