/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.morestatistics.network;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.fallenbreath.morestatistics.MoreStatisticsMod;
import me.fallenbreath.morestatistics.MoreStatisticsRegistry;
import me.fallenbreath.morestatistics.network.MoreStatisticsPayload;
import me.fallenbreath.morestatistics.network.Network;
import me.fallenbreath.morestatistics.utils.Util;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_634;
import net.minecraft.class_746;

public class ClientHandler {
    private static Set<String> SCOREBOARD_CRITERION_NAMES = Collections.emptySet();

    public static void handleServerPacket(MoreStatisticsPayload payload, class_746 player) {
        int id = payload.getPacketId();
        switch (id) {
            case 1: {
                class_2487 nbt = Objects.requireNonNull(payload.getNbt());
                SCOREBOARD_CRITERION_NAMES = Sets.newHashSet(Util.nbt2StringList(Util.getNbtOrEmpty(nbt, "data")));
                MoreStatisticsMod.LOGGER.debug("Received CRITERION NAMES: {}", SCOREBOARD_CRITERION_NAMES);
            }
        }
    }

    public static Set<String> getScoreboardCriterionNames() {
        return SCOREBOARD_CRITERION_NAMES;
    }

    public static void sendAcceptedStatList(class_634 clientPlayNetworkHandler) {
        List myAcceptedStats = MoreStatisticsRegistry.getStatsSet().stream().map(class_2960::toString).collect(Collectors.toList());
        clientPlayNetworkHandler.method_52787((class_2596)Network.C2S.packet(1, nbt -> nbt.method_10566("data", (class_2520)Util.stringList2Nbt(myAcceptedStats))));
    }

    public static void requestScoreboardCriterionList(class_634 clientPlayNetworkHandler) {
        clientPlayNetworkHandler.method_52787((class_2596)Network.C2S.packet(2, nbt -> {}));
    }
}

