/*
 * Decompiled with CFR 0.152.
 */
package subaraki.pga.render.layer;

import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3882;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import subaraki.pga.capability.ScreenData;
import subaraki.pga.config.ConfigHandler;

public class CommonLayer<T extends class_1309, M extends class_583<T>>
extends class_3887<T, M> {
    private static final class_2960 CLOUD = class_2960.method_60655((String)"publicguiannouncement", (String)"textures/gui/cloud.png");
    private static final float PIXELSCALE = 0.0625f;

    public CommonLayer(class_3883<T, M> renderer) {
        super(renderer);
    }

    protected static void blitRect(class_4587 matrixStack, class_4588 builder, int packedLight, int overlay, float x0, float y0, float xt, float yt, float width, float height, int tWidth, int tHeight, boolean mirrored) {
        float pixelScale = 0.0625f;
        float tx0 = xt / ((float)tWidth * pixelScale);
        float ty0 = yt / ((float)tHeight * pixelScale);
        float tx1 = tx0 + width / ((float)tWidth * pixelScale);
        float ty1 = ty0 + height / ((float)tHeight * pixelScale);
        float x1 = x0 - width;
        float y1 = y0 + height;
        if (mirrored) {
            x1 *= -1.0f;
        }
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        Matrix3f normal = matrixStack.method_23760().method_23762();
        builder.method_22918(matrix, x0, y1, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(tx0, ty1).method_22922(overlay).method_22921(packedLight, 0).method_60831(matrixStack.method_23760(), 0.0f, 0.0f, 1.0f);
        builder.method_22918(matrix, x1, y1, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(tx1, ty1).method_22922(overlay).method_22921(packedLight, 0).method_60831(matrixStack.method_23760(), 0.0f, 0.0f, 1.0f);
        builder.method_22918(matrix, x1, y0, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(tx1, ty0).method_22922(overlay).method_22921(packedLight, 0).method_60831(matrixStack.method_23760(), 0.0f, 0.0f, 1.0f);
        builder.method_22918(matrix, x0, y0, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(tx0, ty0).method_22922(overlay).method_22921(packedLight, 0).method_60831(matrixStack.method_23760(), 0.0f, 0.0f, 1.0f);
    }

    public void render(class_4587 stack, class_4597 buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (class_310.method_1551().field_1755 instanceof class_490 || class_310.method_1551().field_1755 instanceof class_481) {
            return;
        }
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 renderedPlayer = (class_1657)entity;
        this.getDataOptional(renderedPlayer).ifPresent(data -> {
            class_2960 resLoc;
            if (data.getClientScreen() != null && (resLoc = data.lookupResloc()) != null) {
                int gui_size_x = data.getClientScreen().getSizeX();
                int gui_size_y = data.getClientScreen().getSizeY();
                int texture_size_x = data.getClientScreen().getTexX();
                int texture_size_y = data.getClientScreen().getTexY();
                stack.method_22903();
                if (ConfigHandler.renderDefault()) {
                    class_583 patt0$temp = this.method_17165();
                    if (patt0$temp instanceof class_3882) {
                        class_3882 headedModel = (class_3882)patt0$temp;
                        headedModel.method_2838().method_22703(stack);
                    }
                } else {
                    float f = class_3532.method_17821((float)limbSwingAmount, (float)renderedPlayer.field_6220, (float)renderedPlayer.field_6283);
                    stack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - f));
                }
                float headToCenterOffset = 0.25f;
                float centerX = (float)gui_size_x / 2.0f * 0.0625f;
                float centerY = (float)gui_size_y / 2.0f * 0.0625f;
                float sizeX = (float)gui_size_x * 0.0625f;
                float sizeY = (float)gui_size_y * 0.0625f;
                float translateX = centerX * 0.0625f;
                float translateY = -centerY * 0.0625f - headToCenterOffset;
                if (ConfigHandler.renderDefault()) {
                    this.renderOnFace(stack, buffer, resLoc, sizeX, sizeY, texture_size_x, texture_size_y, translateX, translateY, packedLight);
                } else {
                    stack.method_46416(translateX - sizeX * 0.0625f, translateY - sizeY * 0.0625f, 0.0f);
                    stack.method_22905(0.0625f, 0.0625f, 0.0625f);
                    if (class_310.method_1551().field_1719 != null && !renderedPlayer.method_5667().equals(class_310.method_1551().field_1719.method_5667()) && !ConfigHandler.bubbleDefault().equals("NONE")) {
                        this.rotateToCamera(stack, renderedPlayer);
                    }
                    this.renderCloud(stack, renderedPlayer, buffer, gui_size_x, gui_size_y, packedLight);
                    this.renderScreenAroundCloud(stack, renderedPlayer, buffer, resLoc, sizeX, sizeY, texture_size_x, texture_size_y, packedLight);
                }
                stack.method_22909();
            }
        });
    }

    protected Optional<? extends ScreenData> getDataOptional(class_1657 player) {
        return Optional.empty();
    }

    private void renderCloud(class_4587 stack, class_1657 player, class_4597 buffer, int gui_size_x, int gui_size_y, int packedLight) {
        stack.method_22903();
        float stretchX = (float)gui_size_x / 255.0f;
        float stretchY = (float)gui_size_y / 255.0f;
        stack.method_22905(stretchX, stretchY, 0.0f);
        class_4588 builder = buffer.getBuffer(class_1921.method_23584((class_2960)CLOUD));
        CommonLayer.blitRect(stack, builder, packedLight, class_4608.field_21444, 0.0f, 0.0f, 0.0f, 0.0f, 15.9375f, 15.9375f, 255, 255, true);
        stack.method_22909();
    }

    private void renderScreenAroundCloud(class_4587 stack, class_1657 player, class_4597 buffer, class_2960 guiTex, float sizeX, float sizeY, int texture_size_x, int texture_size_y, int packedLight) {
        for (double i = -0.1; i <= 0.1; i += 0.2) {
            stack.method_22903();
            stack.method_22904((double)(sizeX / 4.0f), (double)(sizeY / 4.0f), i);
            stack.method_22905(0.5f, 0.5f, 0.5f);
            class_4588 builder = buffer.getBuffer(class_1921.method_23584((class_2960)guiTex));
            CommonLayer.blitRect(stack, builder, packedLight, class_4608.field_21444, 0.0f, 0.0f, 0.0f, 0.0f, sizeX, sizeY, texture_size_x, texture_size_y, true);
            stack.method_22909();
        }
    }

    private void renderOnFace(class_4587 stack, class_4597 buffer, class_2960 guiTex, float sizeX, float sizeY, int texture_size_x, int texture_size_y, float translateX, float translateY, int packedLight) {
        stack.method_46416(translateX, translateY, -0.75f);
        stack.method_22905(0.0625f, 0.0625f, 0.0625f);
        class_4588 builder = buffer.getBuffer(class_1921.method_23584((class_2960)guiTex));
        CommonLayer.blitRect(stack, builder, packedLight, class_4608.field_21444, 0.0f, 0.0f, 0.0f, 0.0f, sizeX, sizeY, texture_size_x, texture_size_y, false);
    }

    private void rotateToCamera(class_4587 stack, class_1657 player) {
        float off = 6.0f;
        stack.method_46416(off, 0.0f, 0.0f);
        if (ConfigHandler.bubbleDefault().equals("PLAYER")) {
            class_243 cam = class_310.method_1551().field_1719.method_19538();
            class_243 play = player.method_19538();
            float rotY = (float)Math.atan2(cam.field_1352 - play.field_1352, cam.field_1350 - play.field_1350);
            stack.method_22907(class_7833.field_40716.rotation(-rotY));
        } else if (ConfigHandler.bubbleDefault().equals("CAMERA")) {
            float rotY = class_310.method_1551().field_1719.method_36454();
            stack.method_22907(class_7833.field_40716.rotationDegrees(rotY));
        }
        stack.method_46416(-off, 0.0f, 0.0f);
    }
}

