/*
 * Decompiled with CFR 0.152.
 */
package subaraki.pga.util;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import subaraki.pga.config.ConfigHandler;
import subaraki.pga.mod.CommonScreenMod;
import subaraki.pga.util.ScreenEntry;
import subaraki.pga.util.VanillaMenus;

public class ScreenPackReader
extends class_4080<ArrayList<JsonObject>> {
    public static final ScreenEntry MISSING_SCREEN = new ScreenEntry("missing.class", "publicguiannouncement:textures/gui/missing.png", 0, 0, 0, 0);
    private static HashMap<String, ScreenEntry> mappedScreens = new HashMap();
    private static final List<String> missingEntries = new ArrayList<String>();
    private static final Logger log = LogManager.getLogger((String)"Missing Entries");

    public static ScreenEntry getEntryForSimpleClassName(String simpleclassname) {
        if (mappedScreens.containsKey(simpleclassname)) {
            return mappedScreens.get(simpleclassname);
        }
        if (!missingEntries.contains(simpleclassname)) {
            missingEntries.add(simpleclassname);
        }
        return MISSING_SCREEN;
    }

    public static void printMissing() {
        log.info("************************************");
        log.info("************************************");
        if (missingEntries == null || missingEntries.isEmpty()) {
            log.info("No Missing Entries in Public Gui Announcement Encountered so far ... keep playing !");
        } else {
            log.info("Printing all missing entries encountered in Public GUI Announcement");
        }
        for (String entry : missingEntries) {
            log.info(entry);
        }
        missingEntries.clear();
    }

    protected ArrayList<JsonObject> prepare(class_3300 resourceManager, class_3695 profilerFiller) {
        ArrayList theJsonFiles = Lists.newArrayList();
        try {
            Set jsonfiles = resourceManager.method_14488("load_screens", filename -> filename.method_12832().endsWith(".json")).keySet();
            ArrayList jsons = new ArrayList();
            for (class_2960 resLoc : jsonfiles) {
                jsons.addAll(resourceManager.method_14489(resLoc));
            }
            Gson gson = new GsonBuilder().create();
            for (class_3298 res : jsons) {
                InputStream stream = res.method_14482();
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
                JsonObject json = je.getAsJsonObject();
                if (!json.has("screens")) continue;
                theJsonFiles.add(json);
            }
        }
        catch (IOException e) {
            CommonScreenMod.LOG.warn("************************************");
            CommonScreenMod.LOG.warn("!*!*!*!*!");
            CommonScreenMod.LOG.warn("No Screens Detected. You will not be able to use ");
            CommonScreenMod.LOG.warn("the Public Gui Announcement Mod correctly.");
            CommonScreenMod.LOG.warn("Make sure to select or set some in the resourcepack gui !");
            CommonScreenMod.LOG.warn("Or verify your pga json in assets/any_modid/load_screens  !");
            CommonScreenMod.LOG.warn("!*!*!*!*!");
            CommonScreenMod.LOG.warn("************************************");
            e.printStackTrace();
        }
        return theJsonFiles;
    }

    protected void apply(ArrayList<JsonObject> o, class_3300 resourceManager, class_3695 profilerFiller) {
        ConfigHandler.reload();
        if (o != null && !o.isEmpty()) {
            Runnable run = () -> {
                for (JsonObject json : o) {
                    if (!json.has("screens")) continue;
                    JsonArray array = json.getAsJsonArray("screens");
                    for (int i = 0; i < array.size(); ++i) {
                        JsonArray list;
                        JsonObject jsonObject = array.get(i).getAsJsonObject();
                        String fullName = jsonObject.get("class").getAsString();
                        String path = jsonObject.get("texture").getAsString();
                        int sizeX = 0;
                        int sizeY = 0;
                        int texX = 0;
                        int texY = 0;
                        if (jsonObject.has("size") && (list = jsonObject.getAsJsonArray("size")).size() == 2) {
                            sizeX = list.get(0).getAsInt();
                            sizeY = list.get(1).getAsInt();
                        }
                        if (jsonObject.has("texSize") && (list = jsonObject.getAsJsonArray("texSize")).size() == 2) {
                            texX = list.get(0).getAsInt();
                            texY = list.get(1).getAsInt();
                        }
                        if (jsonObject.has("fullSize")) {
                            int size;
                            texX = texY = (size = jsonObject.get("fullSize").getAsInt());
                            sizeY = texY;
                            sizeX = texY;
                        }
                        ScreenEntry entry2 = new ScreenEntry(fullName, path, sizeX, sizeY, texX, texY);
                        CommonScreenMod.LOG.info(String.format("Loaded %s for %s : file size %d x %d , tex size %d x %d", entry2.getResLoc(), entry2.getRefName(), entry2.getTexX(), entry2.getTexY(), entry2.getSizeX(), entry2.getSizeY()));
                        mappedScreens.put(entry2.getRefName(), entry2);
                    }
                }
                VanillaMenus.getVanillaMenus().forEach(entry -> {
                    if (!mappedScreens.containsKey(entry.getRefName())) {
                        mappedScreens.put(entry.getRefName(), (ScreenEntry)entry);
                    }
                });
            };
            run.run();
        }
    }
}

