/*
 * Decompiled with CFR 0.152.
 */
package subaraki.pga.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import subaraki.pga.capability.ScreenData;
import subaraki.pga.config.ConfigHandler;

public class CommonLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation CLOUD = new ResourceLocation("publicguiannouncement", "textures/gui/cloud.png");
    private static final float PIXELSCALE = 0.0625f;

    public CommonLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    protected static void blitRect(PoseStack matrixStack, VertexConsumer builder, int packedLight, int overlay, float x0, float y0, float xt, float yt, float width, float height, int tWidth, int tHeight, boolean mirrored) {
        float pixelScale = 0.0625f;
        float tx0 = xt / ((float)tWidth * pixelScale);
        float ty0 = yt / ((float)tHeight * pixelScale);
        float tx1 = tx0 + width / ((float)tWidth * pixelScale);
        float ty1 = ty0 + height / ((float)tHeight * pixelScale);
        float x1 = x0 - width;
        float y1 = y0 + height;
        if (mirrored) {
            x1 *= -1.0f;
        }
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        Matrix3f normal = matrixStack.m_85850_().m_252943_();
        builder.m_252986_(matrix, x0, y1, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(tx0, ty1).m_86008_(overlay).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix, x1, y1, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(tx1, ty1).m_86008_(overlay).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix, x1, y0, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(tx1, ty0).m_86008_(overlay).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix, x0, y0, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(tx0, ty0).m_86008_(overlay).m_85969_(packedLight).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (Minecraft.m_91087_().f_91080_ instanceof InventoryScreen || Minecraft.m_91087_().f_91080_ instanceof CreativeModeInventoryScreen) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player renderedPlayer = (Player)entity;
        this.getDataOptional(renderedPlayer).ifPresent(data -> {
            ResourceLocation resLoc;
            if (data.getClientScreen() != null && (resLoc = data.lookupResloc()) != null) {
                int gui_size_x = data.getClientScreen().getSizeX();
                int gui_size_y = data.getClientScreen().getSizeY();
                int texture_size_x = data.getClientScreen().getTexX();
                int texture_size_y = data.getClientScreen().getTexY();
                stack.m_85836_();
                if (ConfigHandler.renderDefault()) {
                    EntityModel patt4180$temp = this.m_117386_();
                    if (patt4180$temp instanceof HeadedModel) {
                        HeadedModel headedModel = (HeadedModel)patt4180$temp;
                        headedModel.m_5585_().m_104299_(stack);
                    }
                } else {
                    float f = Mth.m_14189_((float)limbSwingAmount, (float)renderedPlayer.f_20884_, (float)renderedPlayer.f_20883_);
                    stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - f));
                }
                float headToCenterOffset = 0.25f;
                float centerX = (float)gui_size_x / 2.0f * 0.0625f;
                float centerY = (float)gui_size_y / 2.0f * 0.0625f;
                float sizeX = (float)gui_size_x * 0.0625f;
                float sizeY = (float)gui_size_y * 0.0625f;
                float translateX = centerX * 0.0625f;
                float translateY = -centerY * 0.0625f - headToCenterOffset;
                if (ConfigHandler.renderDefault()) {
                    this.renderOnFace(stack, buffer, resLoc, sizeX, sizeY, texture_size_x, texture_size_y, translateX, translateY, packedLight);
                } else {
                    stack.m_252880_(translateX - sizeX * 0.0625f, translateY - sizeY * 0.0625f, 0.0f);
                    stack.m_85841_(0.0625f, 0.0625f, 0.0625f);
                    if (Minecraft.m_91087_().f_91075_ != null && !renderedPlayer.m_20148_().equals(Minecraft.m_91087_().f_91075_.m_20148_()) && !ConfigHandler.bubbleDefault().equals("NONE")) {
                        this.rotateToCamera(stack, renderedPlayer);
                    }
                    this.renderCloud(stack, renderedPlayer, buffer, gui_size_x, gui_size_y, packedLight);
                    this.renderScreenAroundCloud(stack, renderedPlayer, buffer, resLoc, sizeX, sizeY, texture_size_x, texture_size_y, packedLight);
                }
                stack.m_85849_();
            }
        });
    }

    protected Optional<? extends ScreenData> getDataOptional(Player player) {
        return Optional.empty();
    }

    private void renderCloud(PoseStack stack, Player player, MultiBufferSource buffer, int gui_size_x, int gui_size_y, int packedLight) {
        stack.m_85836_();
        float stretchX = (float)gui_size_x / 255.0f;
        float stretchY = (float)gui_size_y / 255.0f;
        stack.m_85841_(stretchX, stretchY, 0.0f);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110476_((ResourceLocation)CLOUD));
        CommonLayer.blitRect(stack, builder, packedLight, OverlayTexture.f_118083_, 0.0f, 0.0f, 0.0f, 0.0f, 15.9375f, 15.9375f, 255, 255, true);
        stack.m_85849_();
    }

    private void renderScreenAroundCloud(PoseStack stack, Player player, MultiBufferSource buffer, ResourceLocation guiTex, float sizeX, float sizeY, int texture_size_x, int texture_size_y, int packedLight) {
        for (double i = -0.1; i <= 0.1; i += 0.2) {
            stack.m_85836_();
            stack.m_85837_((double)(sizeX / 4.0f), (double)(sizeY / 4.0f), i);
            stack.m_85841_(0.5f, 0.5f, 0.5f);
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110476_((ResourceLocation)guiTex));
            CommonLayer.blitRect(stack, builder, packedLight, OverlayTexture.f_118083_, 0.0f, 0.0f, 0.0f, 0.0f, sizeX, sizeY, texture_size_x, texture_size_y, true);
            stack.m_85849_();
        }
    }

    private void renderOnFace(PoseStack stack, MultiBufferSource buffer, ResourceLocation guiTex, float sizeX, float sizeY, int texture_size_x, int texture_size_y, float translateX, float translateY, int packedLight) {
        stack.m_252880_(translateX, translateY, -0.75f);
        stack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110476_((ResourceLocation)guiTex));
        CommonLayer.blitRect(stack, builder, packedLight, OverlayTexture.f_118083_, 0.0f, 0.0f, 0.0f, 0.0f, sizeX, sizeY, texture_size_x, texture_size_y, false);
    }

    private void rotateToCamera(PoseStack stack, Player player) {
        float off = 6.0f;
        stack.m_252880_(off, 0.0f, 0.0f);
        if (ConfigHandler.bubbleDefault().equals("PLAYER")) {
            Vec3 cam = Minecraft.m_91087_().f_91075_.m_20182_();
            Vec3 play = player.m_20182_();
            float rotY = (float)Math.atan2(cam.f_82479_ - play.f_82479_, cam.f_82481_ - play.f_82481_);
            stack.m_252781_(Axis.f_252436_.m_252961_(-rotY));
        } else if (ConfigHandler.bubbleDefault().equals("CAMERA")) {
            float rotY = Minecraft.m_91087_().f_91075_.m_146908_();
            stack.m_252781_(Axis.f_252436_.m_252977_(rotY));
        }
        stack.m_252880_(-off, 0.0f, 0.0f);
    }
}

