/*
 * Decompiled with CFR 0.152.
 */
package subaraki.pga.event.client;

import java.util.UUID;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import subaraki.pga.capability.ForgeScreenData;
import subaraki.pga.event.CommonGuiOpenEvent;
import subaraki.pga.network.NetworkHandler;
import subaraki.pga.network.packet_server.SPacketSync;
import subaraki.pga.network.packet_server.SPacketTracking;
import subaraki.pga.util.ClientReferences;

@Mod.EventBusSubscriber(modid="publicguiannouncement", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class OpenGuiEventHandler {
    @SubscribeEvent
    public static void openGuiEvent(ScreenEvent.Opening event) {
    }

    @SubscribeEvent
    public static void closingGuiEvent(ScreenEvent.Closing event) {
    }

    public static void openGui(Screen screen) {
        OpenGuiEventHandler.sendUpdateScreenPacket(screen);
    }

    public static void closeGui() {
        OpenGuiEventHandler.sendUpdateScreenPacket(null);
    }

    private static void sendUpdateScreenPacket(Screen screen) {
        if (ClientReferences.getClientPlayer() != null) {
            String resultName = CommonGuiOpenEvent.onOpen(ForgeScreenData.get(ClientReferences.getClientPlayer()).resolve(), screen);
            NetworkHandler.NETWORK.sendToServer((Object)new SPacketSync(resultName));
            UUID uuid = ClientReferences.getClientPlayer().m_20148_();
            NetworkHandler.NETWORK.sendToServer((Object)new SPacketTracking(uuid, resultName));
        }
    }
}

