/*
 * Decompiled with CFR 0.152.
 */
package subaraki.pga.network.packet_client;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import subaraki.pga.capability.ForgeScreenData;
import subaraki.pga.network.IPacketBase;
import subaraki.pga.network.NetworkHandler;
import subaraki.pga.util.ClientReferences;

public class CPacketTracking
implements IPacketBase {
    private UUID uuid;
    private String name;

    public CPacketTracking() {
    }

    public CPacketTracking(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public CPacketTracking(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.name);
        buf.m_130077_(this.uuid);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.name = buf.m_130277_();
        this.uuid = buf.m_130259_();
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ForgeScreenData.get(ClientReferences.getClientPlayerByUUID(this.uuid)).ifPresent(screenData -> screenData.setClientScreen(this.name)));
        context.get().setPacketHandled(true);
    }

    @Override
    public void encrypt(int id) {
        NetworkHandler.NETWORK.registerMessage(id, CPacketTracking.class, CPacketTracking::encode, CPacketTracking::new, CPacketTracking::handle);
    }
}

