package com.github.razorplay01.cpa.platform.common.animation.animations.base;

import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import net.minecraft.class_1282;
import net.minecraft.class_8111;

import static com.github.razorplay01.cpa.ModTemplate.CONFIG;
import static com.github.razorplay01.cpa.ModTemplate.getAnimation;

public class DeathAnimation implements ICustomAnimation {
    @Override
    public void playAnimation(AnimationContext context) {
        if (!CONFIG.getMainAnimations().deathAnimations.isEnabled()) {
            context.mainAnimationContainer().disableAnimation();
        } else {
            // Determina la animación según la causa de la muerte
            String animationId = getDeathAnimationId(context);
            configureAnimationContainer(context, animationId);

            context.mainAnimationContainer().setCurrentAnimation(getAnimation(animationId));
            context.mainAnimationContainer().setCurrentAnimationId(animationId);
        }
    }

    private static void configureAnimationContainer(AnimationContext context, String animationId) {
        switch (animationId) {
            case "death_burn" -> {
                context.mainAnimationContainer().setAnimationSpeed(CONFIG.getMainAnimations().deathAnimations.deathBurnAnimationConfig.getSpeedMultiplier());
                context.mainAnimationContainer().setAnimationFadeTime(CONFIG.getMainAnimations().deathAnimations.deathBurnAnimationConfig.getFadeTime());
                context.mainAnimationContainer().setAnimationPriority(CONFIG.getMainAnimations().deathAnimations.deathBurnAnimationConfig.getPriority());
            }
            case "death_explosion" -> {
                context.mainAnimationContainer().setAnimationSpeed(CONFIG.getMainAnimations().deathAnimations.deathExplosionAnimationConfig.getSpeedMultiplier());
                context.mainAnimationContainer().setAnimationFadeTime(CONFIG.getMainAnimations().deathAnimations.deathExplosionAnimationConfig.getFadeTime());
                context.mainAnimationContainer().setAnimationPriority(CONFIG.getMainAnimations().deathAnimations.deathExplosionAnimationConfig.getPriority());
            }
            case "death_drown" -> {
                context.mainAnimationContainer().setAnimationSpeed(CONFIG.getMainAnimations().deathAnimations.deathDrownAnimationConfig.getSpeedMultiplier());
                context.mainAnimationContainer().setAnimationFadeTime(CONFIG.getMainAnimations().deathAnimations.deathDrownAnimationConfig.getFadeTime());
                context.mainAnimationContainer().setAnimationPriority(CONFIG.getMainAnimations().deathAnimations.deathDrownAnimationConfig.getPriority());
            }
            default -> {
                context.mainAnimationContainer().setAnimationSpeed(CONFIG.getMainAnimations().deathAnimations.getSpeedMultiplier());
                context.mainAnimationContainer().setAnimationSpeed(CONFIG.getMainAnimations().deathAnimations.getFadeTime());
                context.mainAnimationContainer().setAnimationSpeed(CONFIG.getMainAnimations().deathAnimations.getPriority());
            }
        }
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        return context.player().method_6032() <= 0;
    }

    private String getDeathAnimationId(AnimationContext context) {
        class_1282 lastDamageSource = context.player().method_6081();
        if (lastDamageSource != null) {
            if (lastDamageSource.method_49708(class_8111.field_42335) || lastDamageSource.method_49708(class_8111.field_42337) || lastDamageSource.method_49708(class_8111.field_51566)) {
                return AnimationsId.DEATH_BURN_ANIMATION.getAnimationId();
            } else if (lastDamageSource.method_49708(class_8111.field_42331) || lastDamageSource.method_49708(class_8111.field_42332)) {
                return AnimationsId.DEATH_EXPLOSION_ANIMATION.getAnimationId();
            } else if (lastDamageSource.method_49708(class_8111.field_42342)) {
                return AnimationsId.DEATH_DROWN_ANIMATION.getAnimationId();
            }
        }
        return AnimationsId.DEATH_DEFAULT_ANIMATION.getAnimationId();
    }
}
