/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.config;

import java.util.List;
import lombok.Generated;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="cpa")
public class ClientConfig
implements ConfigData {
    @ConfigEntry.Category(value="general")
    @ConfigEntry.Gui.CollapsibleObject
    private General general = new General();
    @ConfigEntry.Category(value="main_animations")
    @ConfigEntry.Gui.CollapsibleObject
    private MainAnimations mainAnimations = new MainAnimations();
    @ConfigEntry.Category(value="overlay_animations")
    @ConfigEntry.Gui.CollapsibleObject
    private OverlayAnimations overlayAnimations = new OverlayAnimations();
    @ConfigEntry.Category(value="special_animations")
    @ConfigEntry.Gui.CollapsibleObject
    private SpecialAnimations specialAnimations = new SpecialAnimations();

    @Generated
    public General getGeneral() {
        return this.general;
    }

    @Generated
    public MainAnimations getMainAnimations() {
        return this.mainAnimations;
    }

    @Generated
    public OverlayAnimations getOverlayAnimations() {
        return this.overlayAnimations;
    }

    @Generated
    public SpecialAnimations getSpecialAnimations() {
        return this.specialAnimations;
    }

    public static class General {
        @ConfigEntry.Gui.Tooltip
        private float animationSpeedMultiplier = 1.0f;
        @ConfigEntry.Gui.Tooltip
        private float animationFadeTimeMultiplier = 1.0f;
        @ConfigEntry.Gui.Tooltip
        private List<String> upHandDisableAnimationIds = List.of("bow", "trident", "water", "boat_forward", "boat_turn", "climbing", "sleep", "crawl");

        @Generated
        public float getAnimationSpeedMultiplier() {
            return this.animationSpeedMultiplier;
        }

        @Generated
        public float getAnimationFadeTimeMultiplier() {
            return this.animationFadeTimeMultiplier;
        }

        @Generated
        public List<String> getUpHandDisableAnimationIds() {
            return this.upHandDisableAnimationIds;
        }
    }

    public static class MainAnimations {
        @ConfigEntry.Gui.CollapsibleObject
        public IdleAnimations idleAnimations = new IdleAnimations();
        @ConfigEntry.Gui.CollapsibleObject
        public MoveAnimations moveAnimations = new MoveAnimations();
        @ConfigEntry.Gui.CollapsibleObject
        public InWaterAnimations inWaterAnimations = new InWaterAnimations();
        @ConfigEntry.Gui.CollapsibleObject
        public MountAnimations mountAnimations = new MountAnimations();
        @ConfigEntry.Gui.CollapsibleObject
        public ExtraAnimations extraAnimations = new ExtraAnimations();
        @ConfigEntry.Gui.CollapsibleObject
        public DeathAnimations deathAnimations = new DeathAnimations();
    }

    public static class OverlayAnimations {
        @ConfigEntry.Gui.CollapsibleObject
        public UseItemAnimation useItemAnimation = new UseItemAnimation();
        @ConfigEntry.Gui.CollapsibleObject
        public SwordAnimations swordAnimations = new SwordAnimations();
        @ConfigEntry.Gui.CollapsibleObject
        public ToolsAnimations toolsAnimations = new ToolsAnimations();
    }

    public static class SpecialAnimations {
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig upHandAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig itemSwapAnimationConfig = new AnimationConfig(true, 1.5f, 0, 1);
    }

    public static class ToolsAnimations {
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig pickaxeAnimationsConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig axeAnimationsConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig shovelAnimationsConfig = new AnimationConfig();

        @Generated
        public AnimationConfig getPickaxeAnimationsConfig() {
            return this.pickaxeAnimationsConfig;
        }

        @Generated
        public AnimationConfig getAxeAnimationsConfig() {
            return this.axeAnimationsConfig;
        }

        @Generated
        public AnimationConfig getShovelAnimationsConfig() {
            return this.shovelAnimationsConfig;
        }
    }

    public static class SwordAnimations {
        @ConfigEntry.Gui.CollapsibleObject
        boolean isEnabled = true;
        @ConfigEntry.Gui.CollapsibleObject
        public SwordAnimationConfig swordAttack1AnimationConfig = new SwordAnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public SwordAnimationConfig swordAttack2AnimationConfig = new SwordAnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public SwordAnimationConfig swordAttack3AnimationConfig = new SwordAnimationConfig();

        @Generated
        public boolean isEnabled() {
            return this.isEnabled;
        }
    }

    public static class UseItemAnimation {
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig bowAnimationsConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig eatingAnimationsConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig shieldAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig tridentAnimationConfig = new AnimationConfig();
    }

    public static class DeathAnimations {
        boolean isEnabled = false;
        float speedMultiplier = 1.0f;
        int fadeTime = 10;
        int priority = 0;
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig deathBurnAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig deathExplosionAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig deathDrownAnimationConfig = new AnimationConfig();

        @Generated
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Generated
        public float getSpeedMultiplier() {
            return this.speedMultiplier;
        }

        @Generated
        public int getFadeTime() {
            return this.fadeTime;
        }

        @Generated
        public int getPriority() {
            return this.priority;
        }

        @Generated
        public AnimationConfig getDeathBurnAnimationConfig() {
            return this.deathBurnAnimationConfig;
        }

        @Generated
        public AnimationConfig getDeathExplosionAnimationConfig() {
            return this.deathExplosionAnimationConfig;
        }

        @Generated
        public AnimationConfig getDeathDrownAnimationConfig() {
            return this.deathDrownAnimationConfig;
        }
    }

    public static class ExtraAnimations {
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig fallingAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig climbingAnimationsConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig crawlingAnimationsConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig elytraAnimationsConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig sleepingAnimationsConfig = new AnimationConfig();
    }

    public static class BoatAnimations {
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig boatTurnAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig boatForwardAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig boatIdleAnimationConfig = new AnimationConfig();
    }

    public static class HorseAnimations {
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig horseIdleAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig horseRunningAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig horseRunningBackwardsAnimationConfig = new AnimationConfig();
    }

    public static class MountAnimations {
        @ConfigEntry.Gui.CollapsibleObject
        public HorseAnimations horseAnimations = new HorseAnimations();
        @ConfigEntry.Gui.CollapsibleObject
        public BoatAnimations boatAnimations = new BoatAnimations();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig minecartAnimationsConfig = new AnimationConfig();
    }

    public static class InWaterAnimations {
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig inWaterUpAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig inWaterSwimAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig inWaterForwardAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig inWaterBackwardsAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig inWaterIdleAnimationConfig = new AnimationConfig();
    }

    public static class MoveAnimations {
        @ConfigEntry.Gui.Tooltip
        private float animationMoveSpeedMultiplier = 4.0f;
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig walkingAnimationConfig = new AnimationConfig(true, 1.0f, 3, 0);
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig walkingBackwardsAnimationConfig = new AnimationConfig(true, 1.0f, 3, 0);
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig walkingSneakAnimationConfig = new AnimationConfig(true, 1.0f, 3, 0);
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig walkingSneakBackwardsAnimationConfig = new AnimationConfig(true, 1.0f, 3, 0);
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig runningAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig onFenceWalkAnimationConfig = new AnimationConfig(true, 1.0f, 3, 0);

        @Generated
        public float getAnimationMoveSpeedMultiplier() {
            return this.animationMoveSpeedMultiplier;
        }
    }

    public static class TurnAnimations {
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig turningStandingAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig turningSneakAnimationConfig = new AnimationConfig();
    }

    public static class IdleAnimations {
        @ConfigEntry.Gui.CollapsibleObject
        public TurnAnimations turnAnimations = new TurnAnimations();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig idleStandingAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig idleSneakAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig idleCreativeFlyingAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig onFenceAnimationConfig = new AnimationConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public AnimationConfig onEdgeAnimationConfig = new AnimationConfig();
    }

    public static class SwordAnimationConfig {
        float speedMultiplier = 1.0f;
        int fadeTime = 10;
        int priority = 0;

        @Generated
        public float getSpeedMultiplier() {
            return this.speedMultiplier;
        }

        @Generated
        public int getFadeTime() {
            return this.fadeTime;
        }

        @Generated
        public int getPriority() {
            return this.priority;
        }
    }

    public static class AnimationConfig {
        boolean isEnabled = true;
        float speedMultiplier = 1.0f;
        int fadeTime = 10;
        int priority = 0;

        @Generated
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Generated
        public float getSpeedMultiplier() {
            return this.speedMultiplier;
        }

        @Generated
        public int getFadeTime() {
            return this.fadeTime;
        }

        @Generated
        public int getPriority() {
            return this.priority;
        }

        @Generated
        public AnimationConfig(boolean isEnabled, float speedMultiplier, int fadeTime, int priority) {
            this.isEnabled = isEnabled;
            this.speedMultiplier = speedMultiplier;
            this.fadeTime = fadeTime;
            this.priority = priority;
        }

        @Generated
        public AnimationConfig() {
        }
    }
}

