/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.animation.animations.base;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.util.Util;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;

public class BoatTurnAnimations
implements ICustomAnimation {
    @Override
    public void playAnimation(AnimationContext context) {
        Entity vehicle = context.player().getVehicle();
        if (Util.isBoat(vehicle)) {
            if (!ModTemplate.CONFIG.getMainAnimations().mountAnimations.boatAnimations.boatTurnAnimationConfig.isEnabled()) {
                context.mainAnimationContainer().disableAnimation();
                return;
            }
            Util.configureAnimationContainer(ModTemplate.CONFIG.getMainAnimations().mountAnimations.boatAnimations.boatTurnAnimationConfig, context.mainAnimationContainer());
            BoatTurnAnimations.playBoatTurnAnimation(context, (Boat)vehicle);
        }
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        return context.player().isPassenger() && context.playerData().getMovementSpeed() > 0.0 && !context.playerData().isMovingBackwards();
    }

    private static void playBoatTurnAnimation(AnimationContext context, Boat boat) {
        boolean isLeftPaddleMoving = boat.getPaddleState(0);
        boolean isRightPaddleMoving = boat.getPaddleState(1);
        if (isLeftPaddleMoving) {
            AnimationContainer.setAnimation(context.mainAnimationContainer(), AnimationsId.BOAT_TURN_LEFT_ANIMATION);
        } else if (isRightPaddleMoving) {
            AnimationContainer.setAnimation(context.mainAnimationContainer(), AnimationsId.BOAT_TURN_RIGHT_ANIMATION);
        }
    }
}

