/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.animation.animations.overlay;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.util.Util;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.enums.BodyParts;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.RawAnimation;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractFadeModifier;
import com.zigythebird.playeranimcore.bones.AdvancedPlayerAnimBone;
import com.zigythebird.playeranimcore.easing.EasingType;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;

public class CrossbowAnimation
implements ICustomAnimation {
    private boolean wasMainArmDisabled = false;
    private boolean wasOffArmDisabled = false;
    private ItemStack lastMainHandItem = ItemStack.EMPTY;
    private ItemStack lastOffHandItem = ItemStack.EMPTY;
    private boolean needToForceEnableMainArm = false;
    private boolean needToForceEnableOffArm = false;
    private BodyParts mainArmToEnable = null;
    private BodyParts offArmToEnable = null;

    @Override
    public void playAnimation(AnimationContext context) {
        if (this.needToForceEnableMainArm && this.mainArmToEnable != null) {
            this.forceEnableBodyPart(context, this.mainArmToEnable);
            this.needToForceEnableMainArm = false;
            this.mainArmToEnable = null;
        }
        if (this.needToForceEnableOffArm && this.offArmToEnable != null) {
            this.forceEnableBodyPart(context, this.offArmToEnable);
            this.needToForceEnableOffArm = false;
            this.offArmToEnable = null;
        }
        if (context.player().isUsingItem() && context.player().getUseItem().getItem() instanceof CrossbowItem) {
            Util.disableBothArms(context);
            this.wasMainArmDisabled = true;
            this.wasOffArmDisabled = true;
            return;
        }
        ItemStack currentMainHandItem = context.player().getMainHandItem();
        ItemStack currentOffHandItem = context.player().getOffhandItem();
        if (context.playerData().getMainArmPose().equals((Object)HumanoidModel.ArmPose.CROSSBOW_HOLD)) {
            context.iAnimationControl().disableBodyPartAnimationInAllContainers(context.player().getMainArm() == HumanoidArm.RIGHT ? BodyParts.RIGHT_ARM : BodyParts.LEFT_ARM);
            this.wasMainArmDisabled = true;
        } else if (!(!this.wasMainArmDisabled || currentMainHandItem.getItem() instanceof CrossbowItem && currentMainHandItem.equals(this.lastMainHandItem))) {
            this.wasMainArmDisabled = false;
            this.needToForceEnableMainArm = true;
            this.mainArmToEnable = context.player().getMainArm() == HumanoidArm.RIGHT ? BodyParts.RIGHT_ARM : BodyParts.LEFT_ARM;
            this.forceEnableBodyPart(context, this.mainArmToEnable);
        }
        if (context.playerData().getOffArmPose().equals((Object)HumanoidModel.ArmPose.CROSSBOW_HOLD)) {
            context.iAnimationControl().disableBodyPartAnimationInAllContainers(context.player().getMainArm() == HumanoidArm.RIGHT ? BodyParts.LEFT_ARM : BodyParts.RIGHT_ARM);
            this.wasOffArmDisabled = true;
        } else if (!(!this.wasOffArmDisabled || currentOffHandItem.getItem() instanceof CrossbowItem && currentOffHandItem.equals(this.lastOffHandItem))) {
            this.wasOffArmDisabled = false;
            this.needToForceEnableOffArm = true;
            this.offArmToEnable = context.player().getMainArm() == HumanoidArm.RIGHT ? BodyParts.LEFT_ARM : BodyParts.RIGHT_ARM;
            this.forceEnableBodyPart(context, this.offArmToEnable);
        }
        this.lastMainHandItem = currentMainHandItem.copy();
        this.lastOffHandItem = currentOffHandItem.copy();
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        boolean holdingCrossbow = context.player().getMainHandItem().getItem() instanceof CrossbowItem || context.player().getOffhandItem().getItem() instanceof CrossbowItem;
        return holdingCrossbow || this.wasMainArmDisabled || this.wasOffArmDisabled;
    }

    private void forceEnableBodyPart(AnimationContext context, BodyParts bodyPart) {
        String partIdToEnable = bodyPart.getPartId();
        context.mainAnimationContainer().getDisabledBoneIds().remove(partIdToEnable);
        context.overlayAnimationContainer().getDisabledBoneIds().remove(partIdToEnable);
        context.specialAnimationContainer().getDisabledBoneIds().remove(partIdToEnable);
        this.forceAnimationChange(context);
        this.updateAnimationController(context.mainAnimationContainer(), partIdToEnable);
        this.updateAnimationController(context.overlayAnimationContainer(), partIdToEnable);
        this.updateAnimationController(context.specialAnimationContainer(), partIdToEnable);
    }

    private void updateAnimationController(AnimationContainer container, String partIdToEnable) {
        container.getAnimationController().setPostAnimationSetupConsumer(getBoneFunc -> {
            ((AdvancedPlayerAnimBone)getBoneFunc.apply(partIdToEnable)).setEnabled(true);
            for (String boneId : container.getDisabledBoneIds()) {
                if (boneId.equals(partIdToEnable)) continue;
                ((AdvancedPlayerAnimBone)getBoneFunc.apply(boneId)).setEnabled(false);
            }
        });
    }

    private void forceAnimationChange(AnimationContext context) {
        Animation currentMainAnimation = context.mainAnimationContainer().getAnimationController().getCurrentAnimation().animation();
        Animation currentOverlayAnimation = context.overlayAnimationContainer().getAnimationController().getCurrentAnimation().animation();
        Animation currentSpecialAnimation = context.specialAnimationContainer().getAnimationController().getCurrentAnimation().animation();
        RawAnimation blankAnimation = RawAnimation.begin().thenPlay(ModTemplate.getAnimation(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId()));
        context.mainAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)1, (EasingType)EasingType.EASE_IN_OUT_SINE), blankAnimation, false);
        context.overlayAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)1, (EasingType)EasingType.EASE_IN_OUT_SINE), blankAnimation, false);
        context.specialAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)1, (EasingType)EasingType.EASE_IN_OUT_SINE), blankAnimation, false);
        if (currentMainAnimation != null) {
            context.mainAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)2, (EasingType)EasingType.EASE_IN_OUT_SINE), currentMainAnimation, false);
        }
        if (currentOverlayAnimation != null) {
            context.overlayAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)2, (EasingType)EasingType.EASE_IN_OUT_SINE), currentOverlayAnimation, false);
        }
        if (currentSpecialAnimation != null) {
            context.specialAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)2, (EasingType)EasingType.EASE_IN_OUT_SINE), currentSpecialAnimation, false);
        }
    }
}

