/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.util;

import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.config.ClientConfig;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.enums.BodyParts;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.AdjustmentModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.MirrorModifier;
import com.zigythebird.playeranimcore.math.Vec3f;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class Util {
    public static final String RIGHT_PREFIX = "right_";
    public static final String LEFT_PREFIX = "left_";

    private Util() {
    }

    public static List<Float> getCustomModelDataId(ItemStack itemStack) {
        return Optional.of(itemStack.getComponentsPatch()).map(componentsPatch -> componentsPatch.get(DataComponents.CUSTOM_MODEL_DATA)).flatMap(optional -> optional.map(CustomModelData::floats)).orElse(List.of(Float.valueOf(0.0f)));
    }

    public static boolean isBoat(Object vehicle) {
        return vehicle instanceof Boat;
    }

    public static boolean isHorse(Object vehicle) {
        return vehicle instanceof Horse || vehicle instanceof SkeletonHorse || vehicle instanceof ZombieHorse || vehicle instanceof Donkey || vehicle instanceof Mule;
    }

    public static void configureAnimationContainer(ClientConfig.AnimationConfig config, AnimationContainer animationContainer) {
        animationContainer.setAnimationSpeed(config.getSpeedMultiplier());
        animationContainer.setAnimationFadeTime(config.getFadeTime());
        animationContainer.setAnimationPriority(config.getPriority());
    }

    public static boolean containsAnyAnimation(AnimationContainer container, List<String> animations) {
        String currentAnimation = container.getCurrentAnimationId();
        if (animations == null || animations.isEmpty()) {
            return false;
        }
        return animations.stream().anyMatch(currentAnimation::contains);
    }

    public static void disableBothArms(AnimationContext context) {
        context.iAnimationControl().disableBodyPartAnimationInAllContainers(BodyParts.LEFT_ARM);
        context.iAnimationControl().disableBodyPartAnimationInAllContainers(BodyParts.RIGHT_ARM);
    }

    public static void addModifiersToContainer(AnimationContainer container) {
        for (AbstractModifier modifier : container.getAnimationModifiers().values()) {
            container.getAnimationController().addModifierLast(modifier);
            if (!(modifier instanceof MirrorModifier)) continue;
            MirrorModifier mirrorModifier = (MirrorModifier)modifier;
            mirrorModifier.enabled = false;
        }
    }

    public static boolean isSwingingSwordOrTools(AbstractClientPlayer player, AnimationContainer animationContainer) {
        return player.swinging && (player.getMainHandItem().getItem() instanceof ShovelItem || player.getMainHandItem().getItem().getDefaultInstance().getComponents().has(DataComponents.TOOL) || player.getMainHandItem().getItem() instanceof AxeItem || player.getMainHandItem().getItem().getDefaultInstance().getComponents().has(DataComponents.WEAPON) || player.getMainHandItem().getItem() instanceof TridentItem) && player.swingingArm.equals((Object)InteractionHand.MAIN_HAND) && !animationContainer.getCurrentAnimationId().equalsIgnoreCase(AnimationsId.SLEEP_ANIMATION.getAnimationId());
    }

    public static Optional<AdjustmentModifier.PartModifier> handleFirstPersonPass(String partName, float pitchRadians) {
        float xRot = 0.0f;
        float offsetY = 0.0f;
        float offsetZ = 0.0f;
        if (partName.equals("body")) {
            if (pitchRadians < 0.0f) {
                xRot -= pitchRadians;
                float offset = Math.abs((float)Math.sin(pitchRadians));
                offsetY += offset * 0.5f;
                offsetZ -= offset;
            }
        } else if (partName.equals("right_arm") || partName.equals("left_arm")) {
            xRot = pitchRadians;
        } else {
            return Optional.empty();
        }
        return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(xRot, 0.0f, 0.0f), new Vec3f(0.0f, offsetY, offsetZ)));
    }

    public static Optional<AdjustmentModifier.PartModifier> handleThirdPersonPass(String partName, float pitchRadians) {
        float xRot = 0.0f;
        switch (partName) {
            case "right_arm": 
            case "left_arm": {
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(xRot += pitchRadians * 0.5f, 0.0f, 0.0f), new Vec3f(0.0f, 0.0f, 0.0f)));
    }

    public static boolean isSword(ItemStack itemStack) {
        Weapon weapon = (Weapon)itemStack.get(DataComponents.WEAPON);
        if (weapon != null) {
            ItemAttributeModifiers attributes = (ItemAttributeModifiers)itemStack.get(DataComponents.ATTRIBUTE_MODIFIERS);
            if (attributes != null) {
                for (ItemAttributeModifiers.Entry entry : attributes.modifiers()) {
                    if (!entry.attribute().equals((Object)Attributes.ATTACK_DAMAGE)) continue;
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isShovel(ItemStack itemStack) {
        Tool tool = (Tool)itemStack.get(DataComponents.TOOL);
        if (tool != null) {
            BlockState dirtState = Blocks.DIRT.defaultBlockState();
            return tool.isCorrectForDrops(dirtState);
        }
        return false;
    }

    public static boolean isPickaxe(ItemStack itemStack) {
        Tool tool = (Tool)itemStack.get(DataComponents.TOOL);
        if (tool != null) {
            BlockState stoneState = Blocks.STONE.defaultBlockState();
            return tool.isCorrectForDrops(stoneState);
        }
        return false;
    }

    public static boolean isAxe(ItemStack itemStack) {
        Tool tool = (Tool)itemStack.get(DataComponents.TOOL);
        if (tool != null) {
            BlockState oakLogState = Blocks.OAK_LOG.defaultBlockState();
            return tool.isCorrectForDrops(oakLogState);
        }
        return false;
    }
}

