/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.animation.animations.base;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.platform.common.util.Util;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;

public class BoatForwardAnimation
implements ICustomAnimation {
    @Override
    public void playAnimation(AnimationContext context) {
        BoatForwardAnimation.handleBoatAnimation(context);
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        Entity vehicle = context.player().getVehicle();
        return context.player().isPassenger() && Util.isBoat(vehicle);
    }

    private static void handleBoatAnimation(AnimationContext context) {
        Boat boat = (Boat)context.player().getVehicle();
        if (!ModTemplate.CONFIG.getMainAnimations().mountAnimations.boatAnimations.boatForwardAnimationConfig.isEnabled()) {
            context.mainAnimationContainer().disableAnimation();
            return;
        }
        Util.configureAnimationContainer(ModTemplate.CONFIG.getMainAnimations().mountAnimations.boatAnimations.boatForwardAnimationConfig, context.mainAnimationContainer());
        boolean isLeftPaddleMoving = boat.getPaddleState(0);
        boolean isRightPaddleMoving = boat.getPaddleState(1);
        if (BoatForwardAnimation.shouldPlayAnimation(context, isLeftPaddleMoving, isRightPaddleMoving)) {
            context.mainAnimationContainer().setCurrentAnimation(ModTemplate.getAnimation(AnimationsId.BOAT_FORWARD_ANIMATION.getAnimationId()));
            context.mainAnimationContainer().setCurrentAnimationId(AnimationsId.BOAT_FORWARD_ANIMATION.getAnimationId());
        }
    }

    private static boolean shouldPlayAnimation(AnimationContext context, boolean isLeftPaddleMoving, boolean isRightPaddleMoving) {
        return context.playerData().getMovementSpeed() > 0.0 && !context.playerData().isMovingBackwards() && isLeftPaddleMoving && isRightPaddleMoving;
    }
}

