package com.github.razorplay01.cpa.platform.common.util;

import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.util.enums.BodyParts;
import com.zigythebird.playeranimcore.animation.layered.modifier.AdjustmentModifier;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonMode;
import com.zigythebird.playeranimcore.math.Vec3f;
import java.util.Optional;
import net.minecraft.class_1306;
import net.minecraft.class_1753;
import net.minecraft.class_1819;

import static com.github.razorplay01.cpa.platform.common.util.Util.*;

public class CustomModifiers {
	private CustomModifiers() {
		// []
	}

	public static AdjustmentModifier createBowModifier(/*? if <=1.21.8 {*//*AbstractClientPlayer player*//*?} else {*/ net.minecraft.class_11890 player/*?}*/) {
		return new AdjustmentModifier(partName -> {
			boolean isUsingBow = player.method_6115() && player.method_6030().method_7909() instanceof class_1753;
			if (!isUsingBow) return Optional.empty();
			boolean isRight = (player.method_6068() != class_1306.field_6183 || !(player.method_6079().method_7909() instanceof class_1753)) && (player.method_6068() != class_1306.field_6182 || !(player.method_6047().method_7909() instanceof class_1753));

			float pitch = (float) Math.toRadians(player.method_36455());
			if (partName.equals(BodyParts.RIGHT_ARM.getPartId()) || partName.equals(BodyParts.LEFT_ARM.getPartId())) {
				return Optional.of(new AdjustmentModifier.PartModifier(
						new Vec3f(0, 0, isRight ? -pitch : pitch),
						new Vec3f(0, pitch, 0))
				);
			}
			return Optional.empty();
		});
	}

	public static AdjustmentModifier createShieldModifier(/*? if <=1.21.8 {*//*AbstractClientPlayer player*//*?} else {*/ net.minecraft.class_11890 player/*?}*/) {
		return new AdjustmentModifier(partName -> {
			boolean isUsingShield = player.method_6115() && player.method_6030().method_7909() instanceof class_1819;
			if (!isUsingShield) return Optional.empty();

			float limitedPitch = Math.clamp(player.method_36455(), -45, 45);
			float pitch = (float) Math.toRadians(limitedPitch) * 0.5f;

			if (partName.equals(BodyParts.LEFT_ARM.getPartId()) || partName.equals(BodyParts.RIGHT_ARM.getPartId())) {
				return Optional.of(new AdjustmentModifier.PartModifier(
						new Vec3f(pitch, 0, 0),             //rotation
						Vec3f.ZERO                                //position
				));
			}
			return Optional.empty();
		});
	}

	public static AdjustmentModifier createSwingModifier(/*? if <=1.21.8 {*//*AbstractClientPlayer player*//*?} else {*/ net.minecraft.class_11890 player/*?}*/, AnimationContainer animationContainer) {
		return new AdjustmentModifier(partName -> {
			if (!isSwingingSwordOrTools(player, animationContainer)) {
				return Optional.empty();
			}

			float pitchRadians = (float) Math.toRadians(player.method_36455());
			if (FirstPersonMode.isFirstPersonPass()) {
				return handleFirstPersonPass(partName, pitchRadians);
			} else {
				return handleThirdPersonPass(partName, pitchRadians);
			}
		});
	}
}
