/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.animation.animations.base;

import com.github.razorplay01.cpa.CustomPlayerAnimations;
import com.github.razorplay01.cpa.animation.AnimationContainer;
import com.github.razorplay01.cpa.config.ClientConfig;
import com.github.razorplay01.cpa.util.enums.AnimationsId;
import com.github.razorplay01.cpa.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.util.records.AnimationContext;

public class WalkSneakAnimation
implements ICustomAnimation {
    @Override
    public void playAnimation(AnimationContext context) {
        if (!CustomPlayerAnimations.CONFIG.getMainAnimations().moveAnimations.walkingSneakAnimationConfig.isEnabled()) {
            context.mainAnimationContainer().disableAnimation();
            return;
        }
        WalkSneakAnimation.configureWalkSneakAnimation(context);
        WalkSneakAnimation.setWalkSneakAnimation(context);
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        return context.playerData().getMovementSpeed() > 0.0 && !context.playerData().isMovingBackwards() && context.player().method_18276() && !context.player().method_5765();
    }

    private static void configureWalkSneakAnimation(AnimationContext context) {
        AnimationContainer animationContainer = context.mainAnimationContainer();
        ClientConfig.AnimationConfig config = CustomPlayerAnimations.CONFIG.getMainAnimations().moveAnimations.walkingSneakAnimationConfig;
        animationContainer.setAnimationSpeed(WalkSneakAnimation.calculateAnimationSpeed(context));
        animationContainer.setAnimationFadeTime(config.getFadeTime());
        animationContainer.setAnimationPriority(config.getPriority());
    }

    private static float calculateAnimationSpeed(AnimationContext context) {
        return (float)(5.0 * context.playerData().getMovementSpeed() * (double)CustomPlayerAnimations.CONFIG.getMainAnimations().moveAnimations.getAnimationMoveSpeedMultiplier() * (double)CustomPlayerAnimations.CONFIG.getMainAnimations().moveAnimations.walkingSneakAnimationConfig.getSpeedMultiplier());
    }

    private static void setWalkSneakAnimation(AnimationContext context) {
        context.mainAnimationContainer().setCurrentAnimation(CustomPlayerAnimations.getAnimation(AnimationsId.WALK_SNEAK_ANIMATION.getAnimationId()));
        context.mainAnimationContainer().setCurrentAnimationId(AnimationsId.WALK_SNEAK_ANIMATION.getAnimationId());
    }
}

