/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.animation.animations.base;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.mixin.InventoryAccessor;
import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.config.ClientConfig;
import com.github.razorplay01.cpa.platform.common.util.PlayerData;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import net.minecraft.class_11890;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2399;
import net.minecraft.class_2541;
import net.minecraft.class_3736;
import net.minecraft.class_4776;
import net.minecraft.class_4777;
import net.minecraft.class_4950;
import net.minecraft.class_4951;
import net.minecraft.class_5635;

public class ClimbAnimations
implements ICustomAnimation {
    @Override
    public void playAnimation(AnimationContext context) {
        if (!ModTemplate.CONFIG.getMainAnimations().extraAnimations.climbingAnimationsConfig.isEnabled()) {
            context.mainAnimationContainer().disableAnimation();
            return;
        }
        class_2248 block = ClimbAnimations.getPlayerBlock(context);
        if (ClimbAnimations.isLadderOrVine(block)) {
            ClimbAnimations.handleLadderOrVineAnimation(context);
        } else if (ClimbAnimations.isClimbablePlant(block)) {
            ClimbAnimations.handleClimbablePlantAnimation(context);
        } else if (ClimbAnimations.isPowderSnow(block)) {
            ClimbAnimations.handlePowderSnowAnimation(context);
        }
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        return !context.player().method_24828() || !context.player().method_5765();
    }

    private static class_2248 getPlayerBlock(AnimationContext context) {
        return context.player().method_73183().method_8320(context.player().method_24515()).method_26204();
    }

    private static boolean isLadderOrVine(class_2248 block) {
        return block instanceof class_2399 || block instanceof class_2541;
    }

    private static boolean isClimbablePlant(class_2248 block) {
        return block instanceof class_4950 || block instanceof class_4951 || block instanceof class_4777 || block instanceof class_4776 || block instanceof class_3736;
    }

    private static boolean isPowderSnow(class_2248 block) {
        return block instanceof class_5635;
    }

    private static void handleLadderOrVineAnimation(AnimationContext context) {
        ClimbAnimations.setBodyRotationInLeadderAndVineBlocks(context);
        ClimbAnimations.playClimbAnimation(context);
    }

    private static void handleClimbablePlantAnimation(AnimationContext context) {
        ClimbAnimations.setBodyRotationOnClimbableBlocks(context);
        ClimbAnimations.playClimbAnimation(context);
    }

    private static void handlePowderSnowAnimation(AnimationContext context) {
        if (ClimbAnimations.hasLeatherBoots(context)) {
            ClimbAnimations.playClimbAnimation(context);
        }
    }

    private static boolean hasLeatherBoots(AnimationContext context) {
        class_11890 class_118902 = context.player();
        if (!(class_118902 instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)class_118902;
        class_1799 itemStack = ((InventoryAccessor)player.method_31548()).getEquipment().method_66659(class_1304.field_6166);
        return String.valueOf(itemStack.method_63693()).contains("leather_boots");
    }

    public static void playClimbAnimation(AnimationContext context) {
        if (!context.player().method_6101()) {
            return;
        }
        ClimbAnimations.configureAnimationContainer(context);
        ClimbAnimations.setClimbingAnimation(context);
    }

    private static void configureAnimationContainer(AnimationContext context) {
        ClientConfig.AnimationConfig config = ModTemplate.CONFIG.getMainAnimations().extraAnimations.climbingAnimationsConfig;
        AnimationContainer animationContainer = context.mainAnimationContainer();
        animationContainer.setAnimationSpeed(config.getSpeedMultiplier());
        animationContainer.setAnimationFadeTime(config.getFadeTime());
        animationContainer.setAnimationPriority(config.getPriority());
    }

    private static void setClimbingAnimation(AnimationContext context) {
        class_11890 player = context.player();
        PlayerData playerData = context.playerData();
        boolean isCrouching = player.method_18276();
        double verticalSpeed = playerData.getVectorY();
        if (verticalSpeed > 0.0) {
            context.mainAnimationContainer().setCurrentAnimation(isCrouching ? ModTemplate.getAnimation(AnimationsId.CLIMB_SNEAK_ANIMATION.getAnimationId()) : ModTemplate.getAnimation(AnimationsId.CLIMB_ANIMATION.getAnimationId()));
            context.mainAnimationContainer().setCurrentAnimationId(isCrouching ? AnimationsId.CLIMB_SNEAK_ANIMATION.getAnimationId() : AnimationsId.CLIMB_ANIMATION.getAnimationId());
        } else if (verticalSpeed < 0.0) {
            context.mainAnimationContainer().setCurrentAnimation(ModTemplate.getAnimation(AnimationsId.CLIMB_BACKWARDS_ANIMATION.getAnimationId()));
            context.mainAnimationContainer().setCurrentAnimationId(AnimationsId.CLIMB_BACKWARDS_ANIMATION.getAnimationId());
        } else {
            context.mainAnimationContainer().setCurrentAnimation(isCrouching ? ModTemplate.getAnimation(AnimationsId.CLIMB_IDLE_SNEAK_ANIMATION.getAnimationId()) : ModTemplate.getAnimation(AnimationsId.CLIMB_IDLE_ANIMATION.getAnimationId()));
            context.mainAnimationContainer().setCurrentAnimationId(isCrouching ? AnimationsId.CLIMB_IDLE_SNEAK_ANIMATION.getAnimationId() : AnimationsId.CLIMB_IDLE_ANIMATION.getAnimationId());
        }
    }

    private static void setBodyRotationInLeadderAndVineBlocks(AnimationContext context) {
        if (!(context.player().method_6030().method_7909() instanceof class_1753)) {
            String blockStateString = String.valueOf(context.player().method_73183().method_8320(context.player().method_24515()));
            context.playerData().setPlayerBodyYaw(context.player().method_73188());
            context.playerData().setPlayerHeadYaw(context.player().method_5791());
            if (blockStateString.contains("facing=north") || blockStateString.contains("south=true")) {
                context.playerData().setPlayerBodyYaw(0.0f);
            } else if (blockStateString.contains("facing=south") || blockStateString.contains("north=true")) {
                context.playerData().setPlayerBodyYaw(180.0f);
            } else if (blockStateString.contains("facing=west") || blockStateString.contains("east=true")) {
                context.playerData().setPlayerBodyYaw(270.0f);
            } else if (blockStateString.contains("facing=east") || blockStateString.contains("west=true")) {
                context.playerData().setPlayerBodyYaw(90.0f);
            }
            context.playerData().setPlayerBodyYaw((context.playerData().getPlayerBodyYaw() % 360.0f + 360.0f) % 360.0f);
            context.playerData().setPlayerHeadYaw((context.playerData().getPlayerHeadYaw() % 360.0f + 360.0f) % 360.0f);
            context.player().method_5636(context.playerData().getPlayerBodyYaw());
            context.playerData().setPlayerHeadYaw(context.playerData().getPlayerHeadYaw() - context.playerData().getPlayerBodyYaw());
            context.playerData().setPlayerHeadYaw((context.playerData().getPlayerHeadYaw() % 360.0f + 360.0f) % 360.0f);
            if (context.playerData().getPlayerHeadYaw() > 90.0f && context.playerData().getPlayerHeadYaw() <= 180.0f) {
                context.player().method_5847(context.playerData().getPlayerBodyYaw() + 90.0f);
            } else if (context.playerData().getPlayerHeadYaw() > 180.0f && context.playerData().getPlayerHeadYaw() < 270.0f) {
                context.player().method_5847(context.playerData().getPlayerBodyYaw() + 270.0f);
            }
        }
    }

    private static void setBodyRotationOnClimbableBlocks(AnimationContext context) {
        if (!(context.player().method_6030().method_7909() instanceof class_1753)) {
            context.playerData().setPrevPlayerBodyYaw((float)Math.toDegrees(Math.atan2((double)context.player().method_24515().method_10260() + 0.5 - context.playerData().getPlayerPosition().field_1350, (double)context.player().method_24515().method_10263() + 0.5 - context.playerData().getPlayerPosition().field_1352)) - 90.0f);
            context.playerData().setPlayerHeadYaw(context.player().method_5791());
            context.playerData().setPrevPlayerBodyYaw((context.playerData().getPlayerBodyYaw() % 360.0f + 360.0f) % 360.0f);
            context.playerData().setPlayerHeadYaw((context.playerData().getPlayerHeadYaw() % 360.0f + 360.0f) % 360.0f);
            context.player().method_5636(context.playerData().getPlayerBodyYaw());
            context.playerData().setPlayerHeadYaw(context.playerData().getPlayerHeadYaw() - context.playerData().getPlayerBodyYaw());
            context.playerData().setPlayerHeadYaw((context.playerData().getPlayerHeadYaw() % 360.0f + 360.0f) % 360.0f);
            if (context.playerData().getPlayerHeadYaw() > 90.0f && context.playerData().getPlayerHeadYaw() <= 180.0f) {
                context.player().method_5847(context.playerData().getPlayerBodyYaw() + 90.0f);
            } else if (context.playerData().getPlayerHeadYaw() > 180.0f && context.playerData().getPlayerHeadYaw() < 270.0f) {
                context.player().method_5847(context.playerData().getPlayerBodyYaw() + 270.0f);
            }
        }
    }
}

