package com.github.razorplay01.cpa.platform.common.animation.animations.base;

import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import net.minecraft.class_1690;

import static com.github.razorplay01.cpa.ModTemplate.CONFIG;
import static com.github.razorplay01.cpa.platform.common.util.Util.configureAnimationContainer;
import static com.github.razorplay01.cpa.platform.common.util.Util.isBoat;

public class BoatTurnAnimations implements ICustomAnimation {
    @Override
    public void playAnimation(AnimationContext context) {
        var vehicle = context.player().method_5854();
        if (isBoat(vehicle)) {
            if (!CONFIG.getMainAnimations().mountAnimations.boatAnimations.boatTurnAnimationConfig.isEnabled()) {
                context.mainAnimationContainer().disableAnimation();
                return;
            }

            configureAnimationContainer(CONFIG.getMainAnimations().mountAnimations.boatAnimations.boatTurnAnimationConfig, context.mainAnimationContainer());

            playBoatTurnAnimation(context, (class_1690) vehicle);
        }
    }

    public boolean shouldPlayAnimation(AnimationContext context) {
        return context.player().method_5765() && context.playerData().getMovementSpeed() > 0 && !context.playerData().isMovingBackwards();
    }

    private static void playBoatTurnAnimation(AnimationContext context, class_1690 boat) {
        boolean isLeftPaddleMoving = boat.method_64491(0);
        boolean isRightPaddleMoving = boat.method_64491(1);

        if (isLeftPaddleMoving) {
			AnimationContainer.setAnimation(context.mainAnimationContainer(), AnimationsId.BOAT_TURN_LEFT_ANIMATION);
        } else if (isRightPaddleMoving) {
			AnimationContainer.setAnimation(context.mainAnimationContainer(), AnimationsId.BOAT_TURN_RIGHT_ANIMATION);
        }
    }
}
