/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.animation.animations.base;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.util.Util;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import net.minecraft.class_1282;
import net.minecraft.class_8111;

public class DeathAnimation
implements ICustomAnimation {
    @Override
    public void playAnimation(AnimationContext context) {
        if (!ModTemplate.CONFIG.getMainAnimations().deathAnimations.isEnabled()) {
            context.mainAnimationContainer().disableAnimation();
        } else {
            AnimationsId animationId = this.getDeathAnimationId(context);
            DeathAnimation.configureAnimations(context, animationId);
            AnimationContainer.setAnimation(context.mainAnimationContainer(), animationId);
        }
    }

    private static void configureAnimations(AnimationContext context, AnimationsId animationId) {
        switch (animationId) {
            case DEATH_BURN_ANIMATION: {
                Util.configureAnimationContainer(ModTemplate.CONFIG.getMainAnimations().deathAnimations.deathBurnAnimationConfig, context.mainAnimationContainer());
                break;
            }
            case DEATH_EXPLOSION_ANIMATION: {
                Util.configureAnimationContainer(ModTemplate.CONFIG.getMainAnimations().deathAnimations.deathExplosionAnimationConfig, context.mainAnimationContainer());
                break;
            }
            case DEATH_DROWN_ANIMATION: {
                Util.configureAnimationContainer(ModTemplate.CONFIG.getMainAnimations().deathAnimations.deathDrownAnimationConfig, context.mainAnimationContainer());
                break;
            }
            default: {
                Util.configureAnimationContainer(ModTemplate.CONFIG.getMainAnimations().deathAnimations.deathAnimationConfig, context.mainAnimationContainer());
            }
        }
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        return context.player().method_6032() <= 0.0f;
    }

    private AnimationsId getDeathAnimationId(AnimationContext context) {
        class_1282 lastDamageSource = context.player().method_6081();
        if (lastDamageSource == null) {
            return AnimationsId.DEATH_DEFAULT_ANIMATION;
        }
        if (lastDamageSource.method_49708(class_8111.field_42335) || lastDamageSource.method_49708(class_8111.field_42337) || lastDamageSource.method_49708(class_8111.field_51566)) {
            return this.getAnimationIfEnabled(ModTemplate.CONFIG.getMainAnimations().deathAnimations.deathBurnAnimationConfig.isEnabled(), AnimationsId.DEATH_BURN_ANIMATION);
        }
        if (lastDamageSource.method_49708(class_8111.field_42331) || lastDamageSource.method_49708(class_8111.field_42332)) {
            return this.getAnimationIfEnabled(ModTemplate.CONFIG.getMainAnimations().deathAnimations.deathExplosionAnimationConfig.isEnabled(), AnimationsId.DEATH_EXPLOSION_ANIMATION);
        }
        if (lastDamageSource.method_49708(class_8111.field_42342)) {
            return this.getAnimationIfEnabled(ModTemplate.CONFIG.getMainAnimations().deathAnimations.deathDrownAnimationConfig.isEnabled(), AnimationsId.DEATH_DROWN_ANIMATION);
        }
        return AnimationsId.DEATH_DEFAULT_ANIMATION;
    }

    private AnimationsId getAnimationIfEnabled(boolean isEnabled, AnimationsId specificAnimationId) {
        return isEnabled ? specificAnimationId : AnimationsId.DEATH_DEFAULT_ANIMATION;
    }
}

