/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.animation.animations.special;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.util.Util;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.enums.Modifiers;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import com.zigythebird.playeranimcore.animation.layered.modifier.MirrorModifier;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1306;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_742;
import net.minecraft.class_7923;

public class UpHandAnimation
implements ICustomAnimation {
    @Override
    public void playAnimation(AnimationContext context) {
        boolean shouldPlay;
        HandStates handStates = UpHandAnimation.determineHandStates(context.player());
        UpHandAnimation.handleHandStateChange(handStates, context.mainAnimationContainer(), context);
        boolean configEnabled = ModTemplate.CONFIG.getSpecialAnimations().upHandAnimationConfig.isEnabled();
        boolean bl = shouldPlay = configEnabled && UpHandAnimation.shouldPlayHandAnimation(handStates, context);
        if (shouldPlay) {
            UpHandAnimation.playHandAnimations(handStates, context);
        } else {
            String currId = context.specialAnimationContainer().getCurrentAnimationId();
            if (currId.contains(AnimationsId.UP_HAND_ANIMATION.getAnimationId())) {
                context.specialAnimationContainer().disableAnimation();
            }
        }
        UpHandAnimation.updateLastHandStates(handStates, context);
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        return true;
    }

    private static HandStates determineHandStates(class_742 player) {
        return new HandStates(UpHandAnimation.isHandUp(player.method_6047()), UpHandAnimation.isHandUp(player.method_6079()));
    }

    private static void handleHandStateChange(HandStates currentStates, AnimationContainer mainContainer, AnimationContext context) {
        boolean prevOff;
        boolean prevMain = context.playerData().getPrevMainHandUp();
        if (currentStates.hasChanged(prevMain, prevOff = context.playerData().getPrevOffHandUp())) {
            mainContainer.disableAnimation();
        }
    }

    private static boolean shouldPlayHandAnimation(HandStates states, AnimationContext context) {
        return (states.isMainHandUp || states.isOffHandUp) && !UpHandAnimation.isBlockingAnimation(context.overlayAnimationContainer(), context.mainAnimationContainer());
    }

    private static boolean isBlockingAnimation(AnimationContainer overlay, AnimationContainer main) {
        return Util.containsAnyAnimation(overlay, ModTemplate.CONFIG.getSpecialAnimations().getUpHandDisableAnimationIds()) || Util.containsAnyAnimation(main, ModTemplate.CONFIG.getSpecialAnimations().getUpHandDisableAnimationIds());
    }

    private static void playHandAnimations(HandStates states, AnimationContext context) {
        if (states.isMainHandUp) {
            UpHandAnimation.setUpHandAnimation(context, context.player().method_6068());
        }
        if (states.isOffHandUp) {
            UpHandAnimation.setUpHandAnimation(context, UpHandAnimation.getOppositeArm(context.player().method_6068()));
        }
    }

    private static class_1306 getOppositeArm(class_1306 arm) {
        return arm == class_1306.field_6183 ? class_1306.field_6182 : class_1306.field_6183;
    }

    private static void updateLastHandStates(HandStates states, AnimationContext context) {
        context.playerData().setPrevMainHandUp(states.isMainHandUp);
        context.playerData().setPrevOffHandUp(states.isOffHandUp);
    }

    private static void setUpHandAnimation(AnimationContext context, class_1306 arm) {
        context.specialAnimationContainer().setAnimationSpeed(ModTemplate.CONFIG.getSpecialAnimations().upHandAnimationConfig.getSpeedMultiplier());
        context.specialAnimationContainer().setAnimationFadeTime(ModTemplate.CONFIG.getSpecialAnimations().upHandAnimationConfig.getFadeTime());
        context.specialAnimationContainer().setAnimationPriority(ModTemplate.CONFIG.getSpecialAnimations().upHandAnimationConfig.getPriority());
        context.specialAnimationContainer().setCurrentAnimation(ModTemplate.getAnimation(AnimationsId.UP_HAND_ANIMATION.getAnimationId()));
        boolean isMainRightArm = arm == class_1306.field_6183;
        String animationId = (isMainRightArm ? "right_" : "left_") + AnimationsId.UP_HAND_ANIMATION.getAnimationId();
        context.specialAnimationContainer().setCurrentAnimationId(animationId);
        ((MirrorModifier)context.specialAnimationContainer().getAnimationModifiers().get((Object)Modifiers.MIRROR_MODIFIER.getModifierId())).enabled = isMainRightArm;
    }

    private static boolean isHandUp(class_1799 itemStack) {
        return UpHandAnimation.getUpHandItems().contains(itemStack.method_7909());
    }

    public static Set<class_1792> getUpHandItems() {
        return ModTemplate.CONFIG.getSpecialAnimations().upHandItemIds.stream().map(idStr -> {
            class_1792 item;
            class_2960 id = idStr.contains(":") ? class_2960.method_12829((String)idStr) : class_2960.method_60655((String)"minecraft", (String)idStr.toLowerCase());
            if (id != null && class_7923.field_41178.method_10223(id).isPresent() && (item = (class_1792)((class_6880.class_6883)class_7923.field_41178.method_10223(id).get()).comp_349()) != class_1802.field_8162) {
                return item;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    record HandStates(boolean isMainHandUp, boolean isOffHandUp) {
        boolean hasChanged(boolean lastMainState, boolean lastOffState) {
            return lastMainState != this.isMainHandUp || lastOffState != this.isOffHandUp;
        }
    }
}

