package com.github.razorplay01.cpa.mixin;

import com.github.razorplay01.cpa.platform.common.util.MapRenderer;
import com.github.razorplay01.cpa.platform.common.util.interfaces.HumanoidRenderStateAccessor;
import net.minecraft.class_10055;
import net.minecraft.class_10426;
import net.minecraft.class_10444;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3881;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_989;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;


@Mixin(class_989.class)
public abstract class ItemInHandLayerMixin<S extends class_10426, M extends class_583<S> & class_3881> extends class_3887<S, M> {

	protected ItemInHandLayerMixin(class_3883<S, M> renderLayerParent) {
		super(renderLayerParent);
	}

	//? if <=1.21.8 {
	@Inject(method = "renderArmWithItem", at = @At("HEAD"), cancellable = true)
	private void renderArmWithItem(S armedEntityRenderState, class_10444 itemStackRenderState, class_1306 humanoidArm, class_4587 poseStack, class_4597 multiBufferSource, int i, CallbackInfo ci) {
		if (!(armedEntityRenderState instanceof class_10055 playerRenderState)) return;
		class_1309 livingEntity = ((HumanoidRenderStateAccessor) playerRenderState).getLivingEntity();
		if (!(livingEntity instanceof class_1657)) {
			return;
		}
		this.onRenderItem(livingEntity, this.method_17165(), humanoidArm, poseStack, multiBufferSource, i, ci);
	}

	@Unique
	public void onRenderItem(class_1309 entity, class_583<?> model, class_1306 arm, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo info) {
		if (!(model instanceof class_572<?> humanoid)) {
			return;
		}
		if (!isArmVisible(humanoid, arm)) {
			return;
		}

		boolean isMainHand = arm == entity.method_6068();
		class_1799 heldItem = isMainHand ? entity.method_6047() : entity.method_6079();

		if (heldItem.method_7909().equals(class_1802.field_8204)) {
			renderMapInHand(humanoid, arm, matrices, vertexConsumers, light, heldItem);
			info.cancel();
		}
	}

	@Unique
	private boolean isArmVisible(class_572<?> humanoid, class_1306 arm) {
		return (arm == class_1306.field_6183 && humanoid.field_3401.field_3665) ||
				(arm == class_1306.field_6182 && humanoid.field_27433.field_3665);
	}

	@Unique
	private void renderMapInHand(class_572<?> humanoid, class_1306 arm, class_4587 matrices,
								 class_4597 vertexConsumers, int light, class_1799 itemStack) {
		matrices.method_22903();
		humanoid.method_2803(arm, matrices);

		matrices.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
		matrices.method_22907(class_7833.field_40716.rotationDegrees(200.0f));

		boolean isLeftHand = arm == class_1306.field_6182;
		matrices.method_22904((isLeftHand ? -1 : 1) / 16.0f, 0.125, -0.625);

		MapRenderer.renderFirstPersonMap(matrices, vertexConsumers, light, itemStack);

		matrices.method_22909();
	}
	//?} else {
	/*@Inject(method = "submitArmWithItem(Lnet/minecraft/client/renderer/entity/state/ArmedEntityRenderState;Lnet/minecraft/client/renderer/item/ItemStackRenderState;Lnet/minecraft/world/entity/HumanoidArm;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;I)V", at = @At("HEAD"), cancellable = true)
	private void renderArmWithItem(S armedEntityRenderState, ItemStackRenderState itemStackRenderState, HumanoidArm humanoidArm, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int i, CallbackInfo ci) {
		if (!(armedEntityRenderState instanceof AvatarRenderState playerRenderState)) return;
		LivingEntity livingEntity = ((HumanoidRenderStateAccessor) playerRenderState).getLivingEntity();
		if (!(livingEntity instanceof Player player)) {
			return;
		}
		ItemStack itemStack = null;
		if (itemStackRenderState instanceof ExtendedItemStackRenderState ext && ext.getItemStack() != null) {
			itemStack = ext.getItemStack();
		} else {
			return;
		}
		this.onRenderItem(player, this.getParentModel(), itemStack,
				humanoidArm, poseStack, submitNodeCollector, armedEntityRenderState, i, ci);
	}

	@Unique
	public void onRenderItem(LivingEntity entity, EntityModel<?> model, ItemStack itemStack, HumanoidArm arm,
							 PoseStack poseStack,
							 SubmitNodeCollector submitNodeCollector,
							 net.minecraft.client.renderer.entity.state.LivingEntityRenderState livingEntityRenderState,
							 int light, CallbackInfo info) {
		if (!(model instanceof HumanoidModel<?> humanoid)) {
			return;
		}
		if (!isArmVisible(humanoid, arm)) {
			return;
		}

		boolean isMainHand = arm == entity.getMainArm();
		ItemStack heldItem = isMainHand ? entity.getMainHandItem() : entity.getOffhandItem();

		if (heldItem.getItem().equals(Items.FILLED_MAP)) {
			renderMapInHand(entity, humanoid, itemStack, arm, poseStack, submitNodeCollector, livingEntityRenderState, light);
			info.cancel();
		}
	}

	@Unique
	private boolean isArmVisible(HumanoidModel<?> humanoid, HumanoidArm arm) {
		return (arm == HumanoidArm.RIGHT && humanoid.rightArm.visible) ||
				(arm == HumanoidArm.LEFT && humanoid.leftArm.visible);
	}

	@Unique
	private void renderMapInHand(LivingEntity entity, HumanoidModel<?> humanoid, ItemStack itemStack, HumanoidArm arm,
								 PoseStack poseStack,
								 SubmitNodeCollector submitNodeCollector,
								 net.minecraft.client.renderer.entity.state.LivingEntityRenderState livingEntityRenderState,
								 int light) {
		poseStack.pushPose();
		humanoid.translateToHand((HumanoidRenderState) livingEntityRenderState, arm, poseStack);

		poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
		poseStack.mulPose(Axis.YP.rotationDegrees(200.0f));

		boolean isLeftHand = arm == HumanoidArm.LEFT;
		poseStack.translate((isLeftHand ? -1 : 1) / 16.0f, 0.125, -0.625);

		MapRenderer.renderFirstPersonMap(poseStack, submitNodeCollector, light, itemStack, !entity.getOffhandItem().isEmpty(), entity.getMainArm() == HumanoidArm.LEFT);

		poseStack.popPose();
	}
	*///?}
}
