package com.github.razorplay01.cpa.mixin;

import com.github.razorplay01.cpa.platform.common.util.interfaces.ExtendedItemStackRenderState;
import com.github.razorplay01.cpa.platform.common.util.interfaces.HumanoidRenderStateAccessor;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import net.minecraft.class_10042;
import net.minecraft.class_10055;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import static com.github.razorplay01.cpa.ModTemplate.CONFIG;

@Mixin(class_922.class)
public abstract class LivingEntityRendererMixin<T extends class_1309, S extends class_10042, M extends class_583<? super S>> extends class_897<T, S> implements class_3883<S, M> {
	protected LivingEntityRendererMixin(class_5617.class_5618 context) {
		super(context);
	}

	//? if <=1.21.8 {
	@WrapWithCondition(
			method = "setupRotations(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;FF)V",
			at = @At(
					value = "INVOKE",
					target = "Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionfc;)V",
					ordinal = 1
			)
	)
	private boolean disableDeathRotationForPlayer(class_4587 instance, Quaternionfc quaternionfc, S livingEntityRenderState) {
		if (!(livingEntityRenderState instanceof class_10055 playerRenderState)) return true;
		if (!(((HumanoidRenderStateAccessor) playerRenderState).getLivingEntity() instanceof class_1657)) return true;
		return CONFIG.getMainAnimations().deathAnimations.isEnabled();
	}
//?} else {
	/*@WrapWithCondition(
			method = "setupRotations(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;FF)V",
			at = @At(
					value = "INVOKE",
					target = "Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionfc;)V",
					ordinal = 1
			)
	)
	private boolean disableDeathRotationForPlayer(PoseStack instance, Quaternionfc quaternionfc, S livingEntityRenderState) {
		if (!(livingEntityRenderState instanceof AvatarRenderState playerRenderState)) return true;
		if (!(((HumanoidRenderStateAccessor) playerRenderState).getLivingEntity() instanceof Avatar)) return true;
		return CONFIG.getMainAnimations().deathAnimations.isEnabled();
	}

	@Inject(method = "extractRenderState(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;F)V", at = @At("HEAD"))
	private void addEntityToRenderState(LivingEntity livingEntity,
										net.minecraft.client.renderer.entity.state.LivingEntityRenderState livingEntityRenderState, float f,
										CallbackInfo ci) {
		if (livingEntityRenderState instanceof ArmedEntityRenderState armed) {
			((ExtendedItemStackRenderState) armed.leftHandItem)
					.setItemStack(livingEntity.getItemHeldByArm(HumanoidArm.LEFT));
			((ExtendedItemStackRenderState) armed.rightHandItem)
					.setItemStack(livingEntity.getItemHeldByArm(HumanoidArm.RIGHT));
		}
	}
	*///?}
}
