package com.github.razorplay01.cpa.mixin;

import com.github.razorplay01.cpa.platform.common.util.interfaces.HumanoidRenderStateAccessor;
import com.github.razorplay01.cpa.platform.common.util.interfaces.IAnimationControl;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_1306;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

//? if <=1.21.8 {
@Mixin(class_1007.class)
public abstract class PlayerEntityRendererMixin {
	@Inject(method = "extractRenderState(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;F)V",
			at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/entity/player/PlayerRenderer;getArmPose(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/world/entity/HumanoidArm;)Lnet/minecraft/client/model/HumanoidModel$ArmPose;",
					shift = At.Shift.BY))
	private void setModelPose(class_742 abstractClientPlayer, class_10055 playerRenderState, float f, CallbackInfo ci) {
		((IAnimationControl) abstractClientPlayer).setMainArmPose(PlayerRendererAccesor.getArmPose(abstractClientPlayer, abstractClientPlayer.method_6068() == class_1306.field_6183 ? class_1306.field_6183 : class_1306.field_6182));
		((IAnimationControl) abstractClientPlayer).setOffArmPose(PlayerRendererAccesor.getArmPose(abstractClientPlayer, abstractClientPlayer.method_6068() == class_1306.field_6183 ? class_1306.field_6182 : class_1306.field_6183));
	}

	@Inject(method = "extractRenderState(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;F)V", at = @At("RETURN"))
	private void onExtractRenderState(class_742 abstractClientPlayer, class_10055 playerRenderState, float f, CallbackInfo ci) {
		((HumanoidRenderStateAccessor) playerRenderState).setLivingEntity(abstractClientPlayer);
	}
	}
//?} else {
/*@Mixin(AvatarRenderer.class)
public abstract class PlayerEntityRendererMixin<AvatarlikeEntity extends Avatar & ClientAvatarEntity> extends LivingEntityRenderer<AvatarlikeEntity, AvatarRenderState, PlayerModel> {
	protected PlayerEntityRendererMixin(EntityRendererProvider.Context context, PlayerModel entityModel, float f) {
		super(context, entityModel, f);
	}

	@Inject(
			method = "extractRenderState(Lnet/minecraft/world/entity/Avatar;Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;F)V",
			at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/entity/player/AvatarRenderer;getArmPose(Lnet/minecraft/world/entity/Avatar;Lnet/minecraft/world/entity/HumanoidArm;)Lnet/minecraft/client/model/HumanoidModel$ArmPose;",
					shift = At.Shift.BY))
	private void setModelPose(AvatarlikeEntity avatarlikeEntity, AvatarRenderState avatarRenderState, float f, CallbackInfo ci) {
		if (avatarlikeEntity instanceof Avatar avatar) {
			((IAnimationControl) avatar).setMainArmPose(PlayerRendererAccesor.getArmPose(avatarlikeEntity, avatarlikeEntity.getMainHandItem(), InteractionHand.MAIN_HAND));
			((IAnimationControl) avatar).setOffArmPose(PlayerRendererAccesor.getArmPose(avatarlikeEntity, avatarlikeEntity.getOffhandItem(), InteractionHand.OFF_HAND));
		}
	}

	@Inject(
			method = "extractRenderState(Lnet/minecraft/world/entity/Avatar;Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;F)V",
			at = @At("RETURN"))
	private void onExtractRenderState(AvatarlikeEntity avatar, AvatarRenderState avatarRenderState, float f, CallbackInfo ci) {
		((HumanoidRenderStateAccessor) avatarRenderState).setLivingEntity(avatar);
	}
}
		*///?}
