package com.github.razorplay01.cpa.platform.common.util;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_2354;
import net.minecraft.class_2389;
import net.minecraft.class_243;
import net.minecraft.class_2544;
import net.minecraft.class_572;
import net.minecraft.class_742;
import net.minecraft.world.item.*;
import net.minecraft.world.level.block.*;
import org.joml.Vector3f;

import static java.lang.Math.*;
import static java.lang.Math.sin;
import static net.minecraft.class_1268.field_5808;
import static net.minecraft.class_1268.field_5810;

@Getter
@Setter
@NoArgsConstructor
public class PlayerData {
	private class_243 playerPosition;
	private class_243 prevPlayerPosition = new class_243(0, 0, 0);
	private double movementSpeed = 0;
	private float playerHeadYaw = 0;
	private float playerBodyYaw = 0;
	private float prevPlayerBodyYaw = 0;
	private float bodyYawDelta = 0;
	private float vectorX = 0;
	private float vectorY = 0;
	private float vectorZ = 0;
	private int flychecker = 0;
	private boolean isMovingBackwards = false;
	private boolean isOnFence = false;
	private boolean isOnEdge = false;
	private boolean prevOnGround = false;
	private class_1268 rightHand = field_5808;
	private class_1268 leftHand = field_5810;
	private class_572.class_573 mainArmPose = class_572.class_573.field_3409;
	private class_572.class_573 offArmPose = class_572.class_573.field_3409;
	private class_1799 mainHandItem = class_1799.field_8037;
	private class_1799 offHandItem = class_1799.field_8037;
	private int movementTicks;
	private boolean prevMainHandUp = false;
	private boolean prevOffHandUp = false;

	public void update(/*? if <=1.21.8 {*/class_742 player/*?} else {*/ /*net.minecraft.world.entity.Avatar player*//*?}*/) {
		if (player == null) return;
		updateHandOrientation(player.method_6068());
		updatePlayerPosition(player.method_5791(), player.method_43078(), player.method_19538());
		updateMovementInfo(player.field_6283);
		updateEnvironmentInfo(player);
		updateFlyChecker(player);
		updateMovementTicks(player);
	}

	private void updateMovementTicks(/*? if <=1.21.8 {*/class_742 player/*?} else {*/ /*net.minecraft.world.entity.Avatar player*//*?}*/) {
		if (getMovementSpeed() > 0 && !isMovingBackwards() && !player.method_18276() && !player.method_5765()) {
			setMovementTicks(getMovementTicks() + 1);
		} else {
			setMovementTicks(0);
		}
	}

	private void updateHandOrientation(class_1306 mainHand) {
		if (mainHand == class_1306.field_6183) {
			setRightHand(field_5808);
			setLeftHand(field_5810);
		} else {
			setRightHand(field_5810);
			setLeftHand(field_5808);
		}
	}

	private void updatePlayerPosition(float headYRot, float visualRotationYInDegress, class_243 playerPosition) {
		setPlayerBodyYaw(visualRotationYInDegress);
		setPlayerHeadYaw(headYRot);
		setPlayerPosition(playerPosition);
		setVectorX((float) (getPlayerPosition().x - getPrevPlayerPosition().x));
		setVectorY((float) (getPlayerPosition().y - getPrevPlayerPosition().y));
		setVectorZ((float) (getPlayerPosition().z - getPrevPlayerPosition().z));
		setMovementSpeed(sqrt(getVectorX() * getVectorX() + getVectorZ() * getVectorZ()));
		setBodyYawDelta(getPlayerBodyYaw() - getPrevPlayerBodyYaw());
	}

	private void updateMovementInfo(float yBodyRot) {
		double bodyYawRadians = toRadians(yBodyRot + 90);
		Vector3f movementVector = new Vector3f(getVectorX(), 0, getVectorZ());
		Vector3f lookVector = new Vector3f((float) cos(bodyYawRadians), 0, (float) sin(bodyYawRadians));
		setMovingBackwards(movementVector.length() > 0 && movementVector.dot(lookVector) < 0);
	}

	private void updateEnvironmentInfo(/*? if <=1.21.8 {*/class_742 player/*?} else {*/ /*net.minecraft.world.entity.Avatar player*//*?}*/) {
		class_2248 standingBlock = player.method_37908().method_8320(player.method_24515().method_10074()).method_26204();
		setOnFence((standingBlock instanceof class_2354 || standingBlock instanceof class_2544 || standingBlock instanceof class_2389) && player.method_24828());
		setOnEdge(standingBlock instanceof class_2189 && player.method_24828());
	}

	private void updateFlyChecker(/*? if <=1.21.8 {*/class_742 player/*?} else {*/ /*net.minecraft.world.entity.Avatar player*//*?}*/) {
		double flyVectorY = Math.round(getVectorY() * 1000.0) / 1000.0;
		if ((flyVectorY == 0.0 || Math.abs(flyVectorY) == 0.375) && !player.method_24828() && !player.method_5869()) {
			setFlychecker(getFlychecker() + 1);
		} else if (Math.abs(flyVectorY) > 0.375 || player.method_24828()) {
			setFlychecker(0);
		}
	}

	public boolean getPrevMainHandUp() {
		return prevMainHandUp;
	}

	public boolean getPrevOffHandUp() {
		return prevOffHandUp;
	}
}
