package com.github.razorplay01.cpa.platform.common.util;

import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.config.ClientConfig;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.enums.BodyParts;
import com.github.razorplay01.cpa.platform.common.util.interfaces.IAnimationControl;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.AdjustmentModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.MirrorModifier;
import com.zigythebird.playeranimcore.math.Vec3f;
import net.minecraft.class_10590;
import net.minecraft.class_1495;
import net.minecraft.class_1498;
import net.minecraft.class_1500;
import net.minecraft.class_1506;
import net.minecraft.class_1507;
import net.minecraft.class_1690;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1821;
import net.minecraft.class_1835;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_5134;
import net.minecraft.class_742;
import net.minecraft.class_9280;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import net.minecraft.world.entity.animal.horse.*;
import net.minecraft.world.item.*;
import java.util.List;
import java.util.Optional;

import static net.minecraft.class_1268.field_5808;

public class Util {
	public static final String RIGHT_PREFIX = "right_";
	public static final String LEFT_PREFIX = "left_";

	private Util() {
		//[]
	}

	public static List<Float> getCustomModelDataId(class_1799 itemStack) {
		return Optional.of(itemStack.method_57380())
				.map(componentsPatch -> (Optional<class_9280>) componentsPatch.method_57845(class_9334.field_49637))
				.flatMap(optional -> optional.map(class_9280::comp_3354))
				.orElse(List.of(0.0f));
	}

	public static boolean isBoat(Object vehicle) {
		return vehicle instanceof class_1690;
	}

	public static boolean isHorse(Object vehicle) {
		return vehicle instanceof class_1498 || vehicle instanceof class_1506 || vehicle instanceof class_1507 || vehicle instanceof class_1495 || vehicle instanceof class_1500;
	}

	public static void configureAnimationContainer(ClientConfig.AnimationConfig config, AnimationContainer animationContainer) {
		animationContainer.setAnimationSpeed(config.getSpeedMultiplier());
		animationContainer.setAnimationFadeTime(config.getFadeTime());
		animationContainer.setAnimationPriority(config.getPriority());
	}

	public static boolean containsAnyAnimation(AnimationContainer container, List<String> animations) {
		String currentAnimation = container.getCurrentAnimationId();
		if (animations == null || animations.isEmpty()) {
			return false;
		}
		return animations.stream().anyMatch(currentAnimation::contains);
	}

	public static void disableBothArms(AnimationContext context) {
		context.iAnimationControl().disableBodyPartAnimationInAllContainers(BodyParts.LEFT_ARM);
		context.iAnimationControl().disableBodyPartAnimationInAllContainers(BodyParts.RIGHT_ARM);
	}

	public static void addModifiersToContainer(AnimationContainer container) {
		for (AbstractModifier modifier : container.getAnimationModifiers().values()) {
			container.getAnimationController().addModifierLast(modifier);
			if (modifier instanceof MirrorModifier mirrorModifier) {
				mirrorModifier.enabled = false;
			}
		}
	}

	public static boolean isSwingingSwordOrTools(/*? if <=1.21.8 {*/class_742 player/*?} else {*/ /*net.minecraft.world.entity.Avatar player*//*?}*/, AnimationContainer animationContainer) {
		return player.field_6252 &&
				(player.method_6047().method_7909() instanceof class_1821 ||
						player.method_6047().method_7909().method_7854().method_57353().method_57832(class_9334.field_50077) ||
						player.method_6047().method_7909() instanceof class_1743 ||
						player.method_6047().method_7909().method_7854().method_57353().method_57832(class_9334.field_55878) ||
						player.method_6047().method_7909() instanceof class_1835) &&
				player.field_6266.equals(field_5808) &&
				!animationContainer.getCurrentAnimationId().equalsIgnoreCase(AnimationsId.SLEEP_ANIMATION.getAnimationId());
	}

	public static Optional<AdjustmentModifier.PartModifier> handleFirstPersonPass(String partName, float pitchRadians) {
		float xRot = 0;
		float offsetY = 0;
		float offsetZ = 0;

		if (partName.equals("body")) {
			if (pitchRadians < 0) {
				xRot -= pitchRadians;
				float offset = Math.abs((float) Math.sin(pitchRadians));
				offsetY += offset * 0.5f;
				offsetZ -= offset;
			}
		} else if (partName.equals("right_arm") || partName.equals("left_arm")) {
			xRot = pitchRadians;
		} else {
			return Optional.empty();
		}

		return Optional.of(new AdjustmentModifier.PartModifier(
				new Vec3f(xRot, 0, 0),
				new Vec3f(0, offsetY, offsetZ))
		);
	}

	public static Optional<AdjustmentModifier.PartModifier> handleThirdPersonPass(String partName, float pitchRadians) {
		float xRot = 0;

		switch (partName) {
			case "right_arm", "left_arm" -> xRot += pitchRadians * 0.5F;
			default -> {
				return Optional.empty();
			}
		}

		return Optional.of(new AdjustmentModifier.PartModifier(
				new Vec3f(xRot, 0, 0),
				new Vec3f(0, 0, 0))
		);
	}

	public static boolean isSword(class_1799 itemStack) {
		class_10590 weapon = itemStack.method_58694(class_9334.field_55878);
		if (weapon != null) {
			// Opcionalmente, verifica los modificadores de atributos para confirmar que es una espada
			class_9285 attributes = itemStack.method_58694(class_9334.field_49636);
			if (attributes != null) {
				for (class_9285.class_9287 entry : attributes.comp_2393()) {
					if (entry.comp_2395().equals(class_5134.field_23721)) {
						return true; // Es probable que sea una espada
					}
				}
			}
			return true; // Si tiene el componente WEAPON, es una espada u otra arma cuerpo a cuerpo
		}
		return false;
	}

	public static boolean isShovel(class_1799 itemStack) {
		class_9424 tool = itemStack.method_58694(class_9334.field_50077);
		if (tool != null) {
			// Usa un BlockState representativo que pertenezca a BlockTags.MINEABLE_WITH_SHOVEL
			class_2680 dirtState = class_2246.field_10566.method_9564();
			return tool.method_58426(dirtState);
		}
		return false;
	}

	public static boolean isPickaxe(class_1799 itemStack) {
		class_9424 tool = itemStack.method_58694(class_9334.field_50077);
		if (tool != null) {
			// Usa un BlockState representativo que pertenezca a BlockTags.MINEABLE_WITH_PICKAXE
			class_2680 stoneState = class_2246.field_10340.method_9564();
			return tool.method_58426(stoneState);
		}
		return false;
	}

	public static boolean isAxe(class_1799 itemStack) {
		class_9424 tool = itemStack.method_58694(class_9334.field_50077);
		if (tool != null) {
			// Usa un BlockState representativo que pertenezca a BlockTags.MINEABLE_WITH_AXE
			class_2680 oakLogState = class_2246.field_10431.method_9564();
			return tool.method_58426(oakLogState);
		}
		return false;
	}
}
