/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.animation.animations.overlay;

import com.github.razorplay01.cpa.CustomPlayerAnimations;
import com.github.razorplay01.cpa.animation.AnimationContainer;
import com.github.razorplay01.cpa.util.enums.AnimationsId;
import com.github.razorplay01.cpa.util.enums.BodyParts;
import com.github.razorplay01.cpa.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.util.records.AnimationContext;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.AnimationProcessor;
import com.zigythebird.playeranimcore.animation.RawAnimation;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractFadeModifier;
import com.zigythebird.playeranimcore.bones.AdvancedPlayerAnimBone;
import com.zigythebird.playeranimcore.easing.EasingType;
import net.minecraft.class_1268;
import net.minecraft.class_1743;
import net.minecraft.class_1821;
import net.minecraft.class_1835;
import net.minecraft.class_9334;

public class GenericHandSwingAnimation
implements ICustomAnimation {
    private boolean wasArmDisabled = false;
    private class_1268 lastSwingingArm = null;
    private boolean needToForceEnableArm = false;
    private BodyParts armToEnable = null;

    @Override
    public void playAnimation(AnimationContext context) {
        if (this.needToForceEnableArm && this.armToEnable != null) {
            this.forceEnableBodyPart(context, this.armToEnable);
            this.needToForceEnableArm = false;
            this.armToEnable = null;
        }
        if (context.player().field_6252) {
            GenericHandSwingAnimation.disableArmBasedOnHand(context, context.player().field_6266);
            this.wasArmDisabled = true;
            this.lastSwingingArm = context.player().field_6266;
        } else if (this.wasArmDisabled && !context.player().field_6252) {
            this.wasArmDisabled = false;
            this.needToForceEnableArm = true;
            this.armToEnable = this.lastSwingingArm == context.playerData().getRightHand() ? BodyParts.RIGHT_ARM : BodyParts.LEFT_ARM;
            this.forceEnableBodyPart(context, this.armToEnable);
        }
        context.overlayAnimationContainer().setCurrentAnimationId("hand_swing" + context.overlayAnimationContainer().getCurrentAnimationId());
        context.overlayAnimationContainer().setAnimationFadeTime(0);
        context.overlayAnimationContainer().setAnimationPriority(0);
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        boolean isSwinging = !(!context.player().field_6252 || CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.isEnabled() && context.player().method_6047().method_7909().method_7854().method_57353().method_57832(class_9334.field_55878) || context.player().method_6047().method_7909() instanceof class_1835 || CustomPlayerAnimations.CONFIG.getOverlayAnimations().toolsAnimations.axeAnimationsConfig.isEnabled() && context.player().method_6047().method_7909() instanceof class_1743 || CustomPlayerAnimations.CONFIG.getOverlayAnimations().toolsAnimations.pickaxeAnimationsConfig.isEnabled() && context.player().method_6047().method_7909().method_7854().method_57353().method_57832(class_9334.field_50077) || CustomPlayerAnimations.CONFIG.getOverlayAnimations().toolsAnimations.shovelAnimationsConfig.isEnabled() && context.player().method_6047().method_7909() instanceof class_1821);
        return isSwinging || this.wasArmDisabled || this.needToForceEnableArm;
    }

    private static void disableArmBasedOnHand(AnimationContext context, class_1268 hand) {
        context.player().disableBodyPartAnimation(context.mainAnimationContainer(), hand == context.playerData().getRightHand() ? BodyParts.RIGHT_ARM : BodyParts.LEFT_ARM);
        context.player().disableBodyPartAnimation(context.overlayAnimationContainer(), hand == context.playerData().getRightHand() ? BodyParts.RIGHT_ARM : BodyParts.LEFT_ARM);
        context.player().disableBodyPartAnimation(context.specialAnimationContainer(), hand == context.playerData().getRightHand() ? BodyParts.RIGHT_ARM : BodyParts.LEFT_ARM);
    }

    private void forceEnableBodyPart(AnimationContext context, BodyParts bodyPart) {
        String partIdToEnable = bodyPart.getPartId();
        context.mainAnimationContainer().getDisabledBoneIds().remove(partIdToEnable);
        context.overlayAnimationContainer().getDisabledBoneIds().remove(partIdToEnable);
        context.specialAnimationContainer().getDisabledBoneIds().remove(partIdToEnable);
        this.forceAnimationChange(context);
        this.updateAnimationController(context.mainAnimationContainer(), partIdToEnable);
        this.updateAnimationController(context.overlayAnimationContainer(), partIdToEnable);
        this.updateAnimationController(context.specialAnimationContainer(), partIdToEnable);
    }

    private void updateAnimationController(AnimationContainer container, String partIdToEnable) {
        container.getAnimationController().setPostAnimationSetupConsumer(getBoneFunc -> {
            ((AdvancedPlayerAnimBone)getBoneFunc.apply(partIdToEnable)).setEnabled(true);
            for (String boneId : container.getDisabledBoneIds()) {
                if (boneId.equals(partIdToEnable)) continue;
                ((AdvancedPlayerAnimBone)getBoneFunc.apply(boneId)).setEnabled(false);
            }
        });
    }

    private void forceAnimationChange(AnimationContext context) {
        Animation currentMainAnimation = null;
        AnimationProcessor.QueuedAnimation mainQueued = context.mainAnimationContainer().getAnimationController().getCurrentAnimation();
        if (mainQueued != null) {
            currentMainAnimation = mainQueued.animation();
        }
        Animation currentOverlayAnimation = null;
        AnimationProcessor.QueuedAnimation overlayQueued = context.overlayAnimationContainer().getAnimationController().getCurrentAnimation();
        if (overlayQueued != null) {
            currentOverlayAnimation = overlayQueued.animation();
        }
        Animation currentSpecialAnimation = null;
        AnimationProcessor.QueuedAnimation specialQueued = context.specialAnimationContainer().getAnimationController().getCurrentAnimation();
        if (specialQueued != null) {
            currentSpecialAnimation = specialQueued.animation();
        }
        RawAnimation blankAnimation = RawAnimation.begin().thenPlay(CustomPlayerAnimations.getAnimation(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId()));
        context.mainAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)1, (EasingType)EasingType.EASE_IN_OUT_SINE), blankAnimation, false);
        context.overlayAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)1, (EasingType)EasingType.EASE_IN_OUT_SINE), blankAnimation, false);
        context.specialAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)1, (EasingType)EasingType.EASE_IN_OUT_SINE), blankAnimation, false);
        if (currentMainAnimation != null) {
            context.mainAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)2, (EasingType)EasingType.EASE_IN_OUT_SINE), currentMainAnimation, false);
        }
        if (currentOverlayAnimation != null) {
            context.overlayAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)2, (EasingType)EasingType.EASE_IN_OUT_SINE), currentOverlayAnimation, false);
        }
        if (currentSpecialAnimation != null) {
            context.specialAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)2, (EasingType)EasingType.EASE_IN_OUT_SINE), currentSpecialAnimation, false);
        }
    }
}

