/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.animation.animations.overlay;

import com.github.razorplay01.cpa.CustomPlayerAnimations;
import com.github.razorplay01.cpa.util.Util;
import com.github.razorplay01.cpa.util.enums.AnimationsId;
import com.github.razorplay01.cpa.util.enums.Modifiers;
import com.github.razorplay01.cpa.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.util.records.AnimationContext;
import com.zigythebird.playeranimcore.animation.layered.modifier.MirrorModifier;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1835;
import net.minecraft.class_742;

public class SwordAnimation
implements ICustomAnimation {
    private final Map<UUID, Integer> comboCounts = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> lastSwingTicks = new HashMap<UUID, Long>();
    private final int COMBO_RESET_TICKS = 50;
    private final Map<UUID, Boolean> animationsInProgress = new HashMap<UUID, Boolean>();
    private final Map<UUID, Long> animationStartTimes = new HashMap<UUID, Long>();
    private final Map<UUID, Float> animationDurations = new HashMap<UUID, Float>();

    @Override
    public void playAnimation(AnimationContext context) {
        UUID uuid = context.player().method_5667();
        if (!CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.isEnabled()) {
            context.overlayAnimationContainer().disableAnimation();
            this.animationsInProgress.put(uuid, false);
        } else if (SwordAnimation.isPlayerSwingingWeapon(context.player())) {
            this.animationStartTimes.put(uuid, context.player().method_37908().method_8510());
            this.animationsInProgress.put(uuid, true);
            this.handleSwordComboAnimation(context);
            if (context.overlayAnimationContainer().getCurrentAnimation() != null) {
                this.animationDurations.put(uuid, Float.valueOf(context.overlayAnimationContainer().getCurrentAnimation().length() - 5.0f));
            }
        } else if (Boolean.TRUE.equals(this.animationsInProgress.getOrDefault(uuid, false))) {
            long currentTime = context.player().method_37908().method_8510();
            if ((float)(currentTime - this.animationStartTimes.getOrDefault(uuid, 0L)) < this.animationDurations.getOrDefault(uuid, Float.valueOf(0.0f)).floatValue()) {
                this.handleSwordComboAnimation(context);
            } else {
                this.animationsInProgress.put(uuid, false);
            }
        }
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        UUID uuid = context.player().method_5667();
        return (SwordAnimation.isPlayerSwingingWeapon(context.player()) || Boolean.TRUE.equals(this.animationsInProgress.getOrDefault(uuid, false))) && !context.mainAnimationContainer().getCurrentAnimationId().equalsIgnoreCase(AnimationsId.SLEEP_ANIMATION.getAnimationId());
    }

    private void handleSwordComboAnimation(AnimationContext context) {
        UUID uuid = context.player().method_5667();
        long currentTick = context.player().method_37908().method_8510();
        this.comboCounts.putIfAbsent(uuid, 0);
        this.lastSwingTicks.putIfAbsent(uuid, 0L);
        if (currentTick - this.lastSwingTicks.get(uuid) > 50L) {
            this.comboCounts.put(uuid, 0);
        }
        if (context.overlayAnimationContainer().getAnimationController().getCurrentAnimation() != null) {
            if (context.overlayAnimationContainer().getAnimationController().isActive() && context.overlayAnimationContainer().getAnimationController().getCurrentAnimation().animation() == CustomPlayerAnimations.getAnimation(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId())) {
                this.comboCounts.compute(uuid, (k, currentCount) -> currentCount % 3 + 1);
            }
            this.lastSwingTicks.put(uuid, currentTick);
            int currentCombo = this.comboCounts.get(uuid);
            switch (currentCombo) {
                case 2: {
                    context.overlayAnimationContainer().setAnimationSpeed(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack2AnimationConfig.getSpeedMultiplier());
                    context.overlayAnimationContainer().setAnimationFadeTime(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack2AnimationConfig.getFadeTime());
                    context.overlayAnimationContainer().setAnimationPriority(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack2AnimationConfig.getPriority());
                    break;
                }
                case 3: {
                    context.overlayAnimationContainer().setAnimationSpeed(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack3AnimationConfig.getSpeedMultiplier());
                    context.overlayAnimationContainer().setAnimationFadeTime(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack3AnimationConfig.getFadeTime());
                    context.overlayAnimationContainer().setAnimationPriority(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack3AnimationConfig.getPriority());
                    break;
                }
                default: {
                    context.overlayAnimationContainer().setAnimationSpeed(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack1AnimationConfig.getSpeedMultiplier());
                    context.overlayAnimationContainer().setAnimationFadeTime(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack1AnimationConfig.getFadeTime());
                    context.overlayAnimationContainer().setAnimationPriority(CustomPlayerAnimations.CONFIG.getOverlayAnimations().swordAnimations.swordAttack1AnimationConfig.getPriority());
                }
            }
            this.selectComboAnimation(context);
            ((MirrorModifier)context.overlayAnimationContainer().getAnimationModifiers().get((Object)Modifiers.MIRROR_MODIFIER.getModifierId())).enabled = context.playerData().getRightHand() != class_1268.field_5808;
        }
    }

    private void selectComboAnimation(AnimationContext context) {
        boolean isSneaking = context.player().method_18276();
        UUID uuid = context.player().method_5667();
        int currentCombo = this.comboCounts.getOrDefault(uuid, 1);
        switch (currentCombo) {
            case 1: {
                context.overlayAnimationContainer().setCurrentAnimation(isSneaking ? CustomPlayerAnimations.getAnimation(AnimationsId.SWORD_ATTACK_1_SNEAK_ANIMATION.getAnimationId()) : CustomPlayerAnimations.getAnimation(AnimationsId.SWORD_ATTACK_1_ANIMATION.getAnimationId()));
                context.overlayAnimationContainer().setCurrentAnimationId(isSneaking ? AnimationsId.SWORD_ATTACK_1_SNEAK_ANIMATION.getAnimationId() : AnimationsId.SWORD_ATTACK_1_ANIMATION.getAnimationId());
                break;
            }
            case 2: {
                context.overlayAnimationContainer().setCurrentAnimation(isSneaking ? CustomPlayerAnimations.getAnimation(AnimationsId.SWORD_ATTACK_2_SNEAK_ANIMATION.getAnimationId()) : CustomPlayerAnimations.getAnimation(AnimationsId.SWORD_ATTACK_2_ANIMATION.getAnimationId()));
                context.overlayAnimationContainer().setCurrentAnimationId(isSneaking ? AnimationsId.SWORD_ATTACK_2_SNEAK_ANIMATION.getAnimationId() : AnimationsId.SWORD_ATTACK_2_ANIMATION.getAnimationId());
                break;
            }
            default: {
                context.overlayAnimationContainer().setCurrentAnimation(isSneaking ? CustomPlayerAnimations.getAnimation(AnimationsId.SWORD_ATTACK_3_SNEAK_ANIMATION.getAnimationId()) : CustomPlayerAnimations.getAnimation(AnimationsId.SWORD_ATTACK_3_ANIMATION.getAnimationId()));
                context.overlayAnimationContainer().setCurrentAnimationId(isSneaking ? AnimationsId.SWORD_ATTACK_3_SNEAK_ANIMATION.getAnimationId() : AnimationsId.SWORD_ATTACK_3_ANIMATION.getAnimationId());
            }
        }
    }

    public static boolean isPlayerSwingingWeapon(class_742 avatar) {
        class_1799 itemStack = avatar.method_6047();
        if (Util.isAxe(itemStack) || Util.isPickaxe(itemStack) || Util.isShovel(itemStack)) {
            return false;
        }
        return avatar.field_6252 && (Util.isSword(itemStack) || itemStack.method_7909() instanceof class_1835) && avatar.field_6266.equals((Object)class_1268.field_5808);
    }
}

