/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.animation.animations.overlay;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.platform.common.util.Util;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.enums.Modifiers;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.layered.modifier.MirrorModifier;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ShovelItem;

public class ShovelAnimation
implements ICustomAnimation {
    private final Map<UUID, Boolean> animationsInProgress = new HashMap<UUID, Boolean>();
    private final Map<UUID, Long> animationStartTimes = new HashMap<UUID, Long>();
    private final Map<UUID, Float> animationDurations = new HashMap<UUID, Float>();

    @Override
    public void playAnimation(AnimationContext context) {
        UUID uuid = context.player().getUUID();
        if (!ModTemplate.CONFIG.getOverlayAnimations().toolsAnimations.shovelAnimationsConfig.isEnabled()) {
            context.overlayAnimationContainer().disableAnimation();
            this.animationsInProgress.put(uuid, false);
        } else if (context.player().swinging && Util.isShovel(context.player().getMainHandItem()) && context.player().getMainHandItem().getItem() instanceof ShovelItem && context.player().swingingArm.equals((Object)InteractionHand.MAIN_HAND)) {
            this.animationStartTimes.put(uuid, context.player().level().getGameTime());
            this.animationsInProgress.put(uuid, true);
            Animation animation = context.player().isCrouching() ? ModTemplate.getAnimation(AnimationsId.SHOVEL_SNEAK_ANIMATION.getAnimationId()) : ModTemplate.getAnimation(AnimationsId.SHOVEL_ANIMATION.getAnimationId());
            this.animationDurations.put(uuid, Float.valueOf(animation.length() - 4.0f));
            Util.configureAnimationContainer(ModTemplate.CONFIG.getOverlayAnimations().toolsAnimations.shovelAnimationsConfig, context.overlayAnimationContainer());
            context.overlayAnimationContainer().setCurrentAnimation(context.player().isCrouching() ? ModTemplate.getAnimation(AnimationsId.SHOVEL_SNEAK_ANIMATION.getAnimationId()) : ModTemplate.getAnimation(AnimationsId.SHOVEL_ANIMATION.getAnimationId()));
            context.overlayAnimationContainer().setCurrentAnimationId(context.player().isCrouching() ? AnimationsId.SHOVEL_SNEAK_ANIMATION.getAnimationId() : AnimationsId.SHOVEL_ANIMATION.getAnimationId());
            ((MirrorModifier)context.overlayAnimationContainer().getAnimationModifiers().get((Object)Modifiers.MIRROR_MODIFIER.getModifierId())).enabled = context.playerData().getRightHand() != InteractionHand.MAIN_HAND;
        } else if (Boolean.TRUE.equals(this.animationsInProgress.getOrDefault(uuid, false))) {
            long currentTime = context.player().level().getGameTime();
            if ((float)(currentTime - this.animationStartTimes.getOrDefault(uuid, 0L)) < this.animationDurations.getOrDefault(uuid, Float.valueOf(0.0f)).floatValue()) {
                Util.configureAnimationContainer(ModTemplate.CONFIG.getOverlayAnimations().toolsAnimations.shovelAnimationsConfig, context.overlayAnimationContainer());
                context.overlayAnimationContainer().setCurrentAnimation(context.player().isCrouching() ? ModTemplate.getAnimation(AnimationsId.SHOVEL_SNEAK_ANIMATION.getAnimationId()) : ModTemplate.getAnimation(AnimationsId.SHOVEL_ANIMATION.getAnimationId()));
                context.overlayAnimationContainer().setCurrentAnimationId(context.player().isCrouching() ? AnimationsId.SHOVEL_SNEAK_ANIMATION.getAnimationId() : AnimationsId.SHOVEL_ANIMATION.getAnimationId());
                ((MirrorModifier)context.overlayAnimationContainer().getAnimationModifiers().get((Object)Modifiers.MIRROR_MODIFIER.getModifierId())).enabled = context.playerData().getRightHand() != InteractionHand.MAIN_HAND;
            } else {
                this.animationsInProgress.put(uuid, false);
            }
        }
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        UUID uuid = context.player().getUUID();
        return (context.player().swinging && Util.isShovel(context.player().getMainHandItem()) && context.player().getMainHandItem().getItem() instanceof ShovelItem && context.player().swingingArm.equals((Object)InteractionHand.MAIN_HAND) || Boolean.TRUE.equals(this.animationsInProgress.getOrDefault(uuid, false))) && !context.mainAnimationContainer().getCurrentAnimationId().equalsIgnoreCase(AnimationsId.SLEEP_ANIMATION.getAnimationId());
    }
}

