/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.animation.animations.special;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.util.Util;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.enums.Modifiers;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import com.zigythebird.playeranimcore.animation.layered.modifier.MirrorModifier;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class UpHandAnimation
implements ICustomAnimation {
    @Override
    public void playAnimation(AnimationContext context) {
        boolean shouldPlay;
        HandStates handStates = UpHandAnimation.determineHandStates(context.player());
        UpHandAnimation.handleHandStateChange(handStates, context.mainAnimationContainer(), context);
        boolean configEnabled = ModTemplate.CONFIG.getSpecialAnimations().upHandAnimationConfig.isEnabled();
        boolean bl = shouldPlay = configEnabled && UpHandAnimation.shouldPlayHandAnimation(handStates, context);
        if (shouldPlay) {
            UpHandAnimation.playHandAnimations(handStates, context);
        } else {
            String currId = context.specialAnimationContainer().getCurrentAnimationId();
            if (currId.contains(AnimationsId.UP_HAND_ANIMATION.getAnimationId())) {
                context.specialAnimationContainer().disableAnimation();
            }
        }
        UpHandAnimation.updateLastHandStates(handStates, context);
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        return true;
    }

    private static HandStates determineHandStates(AbstractClientPlayer player) {
        return new HandStates(UpHandAnimation.isHandUp(player.getMainHandItem()), UpHandAnimation.isHandUp(player.getOffhandItem()));
    }

    private static void handleHandStateChange(HandStates currentStates, AnimationContainer mainContainer, AnimationContext context) {
        boolean prevOff;
        boolean prevMain = context.playerData().getPrevMainHandUp();
        if (currentStates.hasChanged(prevMain, prevOff = context.playerData().getPrevOffHandUp())) {
            mainContainer.disableAnimation();
        }
    }

    private static boolean shouldPlayHandAnimation(HandStates states, AnimationContext context) {
        return (states.isMainHandUp || states.isOffHandUp) && !UpHandAnimation.isBlockingAnimation(context.overlayAnimationContainer(), context.mainAnimationContainer());
    }

    private static boolean isBlockingAnimation(AnimationContainer overlay, AnimationContainer main) {
        return Util.containsAnyAnimation(overlay, ModTemplate.CONFIG.getSpecialAnimations().getUpHandDisableAnimationIds()) || Util.containsAnyAnimation(main, ModTemplate.CONFIG.getSpecialAnimations().getUpHandDisableAnimationIds());
    }

    private static void playHandAnimations(HandStates states, AnimationContext context) {
        if (states.isMainHandUp) {
            UpHandAnimation.setUpHandAnimation(context, context.player().getMainArm());
        }
        if (states.isOffHandUp) {
            UpHandAnimation.setUpHandAnimation(context, UpHandAnimation.getOppositeArm(context.player().getMainArm()));
        }
    }

    private static HumanoidArm getOppositeArm(HumanoidArm arm) {
        return arm == HumanoidArm.RIGHT ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
    }

    private static void updateLastHandStates(HandStates states, AnimationContext context) {
        context.playerData().setPrevMainHandUp(states.isMainHandUp);
        context.playerData().setPrevOffHandUp(states.isOffHandUp);
    }

    private static void setUpHandAnimation(AnimationContext context, HumanoidArm arm) {
        context.specialAnimationContainer().setAnimationSpeed(ModTemplate.CONFIG.getSpecialAnimations().upHandAnimationConfig.getSpeedMultiplier());
        context.specialAnimationContainer().setAnimationFadeTime(ModTemplate.CONFIG.getSpecialAnimations().upHandAnimationConfig.getFadeTime());
        context.specialAnimationContainer().setAnimationPriority(ModTemplate.CONFIG.getSpecialAnimations().upHandAnimationConfig.getPriority());
        context.specialAnimationContainer().setCurrentAnimation(ModTemplate.getAnimation(AnimationsId.UP_HAND_ANIMATION.getAnimationId()));
        boolean isMainRightArm = arm == HumanoidArm.RIGHT;
        String animationId = (isMainRightArm ? "right_" : "left_") + AnimationsId.UP_HAND_ANIMATION.getAnimationId();
        context.specialAnimationContainer().setCurrentAnimationId(animationId);
        ((MirrorModifier)context.specialAnimationContainer().getAnimationModifiers().get((Object)Modifiers.MIRROR_MODIFIER.getModifierId())).enabled = isMainRightArm;
    }

    private static boolean isHandUp(ItemStack itemStack) {
        return UpHandAnimation.getUpHandItems().contains(itemStack.getItem());
    }

    public static Set<Item> getUpHandItems() {
        return ModTemplate.CONFIG.getSpecialAnimations().upHandItemIds.stream().map(idStr -> {
            Item item;
            ResourceLocation id = idStr.contains(":") ? ResourceLocation.tryParse((String)idStr) : ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)idStr.toLowerCase());
            if (id != null && BuiltInRegistries.ITEM.get(id).isPresent() && (item = (Item)((Holder.Reference)BuiltInRegistries.ITEM.get(id).get()).value()) != Items.AIR) {
                return item;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    record HandStates(boolean isMainHandUp, boolean isOffHandUp) {
        boolean hasChanged(boolean lastMainState, boolean lastOffState) {
            return lastMainState != this.isMainHandUp || lastOffState != this.isOffHandUp;
        }
    }
}

