/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.platform.common.util;

import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.util.Util;
import com.github.razorplay01.cpa.platform.common.util.enums.BodyParts;
import com.zigythebird.playeranimcore.animation.layered.modifier.AdjustmentModifier;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonMode;
import com.zigythebird.playeranimcore.math.Vec3f;
import java.util.Optional;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ShieldItem;

public class CustomModifiers {
    private CustomModifiers() {
    }

    public static AdjustmentModifier createBowModifier(AbstractClientPlayer player) {
        return new AdjustmentModifier(partName -> {
            boolean isUsingBow;
            boolean bl = isUsingBow = player.isUsingItem() && player.getUseItem().getItem() instanceof BowItem;
            if (!isUsingBow) {
                return Optional.empty();
            }
            boolean isRight = !(player.getMainArm() == HumanoidArm.RIGHT && player.getOffhandItem().getItem() instanceof BowItem || player.getMainArm() == HumanoidArm.LEFT && player.getMainHandItem().getItem() instanceof BowItem);
            float pitch = (float)Math.toRadians(player.getXRot());
            if (partName.equals(BodyParts.RIGHT_ARM.getPartId()) || partName.equals(BodyParts.LEFT_ARM.getPartId())) {
                return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(0.0f, 0.0f, isRight ? -pitch : pitch), new Vec3f(0.0f, pitch, 0.0f)));
            }
            return Optional.empty();
        });
    }

    public static AdjustmentModifier createShieldModifier(AbstractClientPlayer player) {
        return new AdjustmentModifier(partName -> {
            boolean isUsingShield;
            boolean bl = isUsingShield = player.isUsingItem() && player.getUseItem().getItem() instanceof ShieldItem;
            if (!isUsingShield) {
                return Optional.empty();
            }
            float limitedPitch = Math.clamp(player.getXRot(), -45.0f, 45.0f);
            float pitch = (float)Math.toRadians(limitedPitch) * 0.5f;
            if (partName.equals(BodyParts.LEFT_ARM.getPartId()) || partName.equals(BodyParts.RIGHT_ARM.getPartId())) {
                return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(pitch, 0.0f, 0.0f), Vec3f.ZERO));
            }
            return Optional.empty();
        });
    }

    public static AdjustmentModifier createSwingModifier(AbstractClientPlayer player, AnimationContainer animationContainer) {
        return new AdjustmentModifier(partName -> {
            if (!Util.isSwingingSwordOrTools(player, animationContainer)) {
                return Optional.empty();
            }
            float pitchRadians = (float)Math.toRadians(player.getXRot());
            if (FirstPersonMode.isFirstPersonPass()) {
                return Util.handleFirstPersonPass(partName, pitchRadians);
            }
            return Util.handleThirdPersonPass(partName, pitchRadians);
        });
    }
}

