/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa;

import com.github.razorplay01.cpa.platform.Platform;
import com.github.razorplay01.cpa.platform.common.config.ClientConfig;
import com.github.razorplay01.cpa.platform.common.config.ConfigWrapper;
import com.github.razorplay01.cpa.platform.fabric.FabricPlatform;
import com.zigythebird.playeranim.animation.PlayerAnimResources;
import com.zigythebird.playeranim.animation.PlayerAnimationController;
import com.zigythebird.playeranim.api.PlayerAnimationFactory;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.enums.PlayState;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModTemplate {
    public static final String MOD_ID = "cpa";
    public static final String MOD_VERSION = "5.0.1";
    public static final String MOD_FRIENDLY_NAME = "Custom Player Animations";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cpa");
    public static ClientConfig CONFIG;
    public static final class_2960 MAIN_ANIMATION_CONTAINER_LAYER_ID;
    public static final class_2960 OVERLAY_ANIMATION_CONTAINER_LAYER_ID;
    public static final class_2960 SPECIAL_ANIMATION_CONTAINER_LAYER_ID;
    private static final Platform PLATFORM;

    public static void onInitialize() {
        LOGGER.info("Initializing {} on {}", (Object)MOD_ID, (Object)ModTemplate.xplat().loader());
    }

    public static void onInitializeClient() {
        LOGGER.info("Initializing {} Client on {}", (Object)MOD_ID, (Object)ModTemplate.xplat().loader());
        LOGGER.debug("{}: { version: {}; friendly_name: {} }", new Object[]{MOD_ID, MOD_VERSION, MOD_FRIENDLY_NAME});
        AutoConfig.register(ConfigWrapper.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        CONFIG = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).client;
        PlayerAnimationFactory.ANIMATION_DATA_FACTORY.registerFactory(MAIN_ANIMATION_CONTAINER_LAYER_ID, 1, player -> new PlayerAnimationController(player, (controller, state, animSetter) -> PlayState.STOP));
        PlayerAnimationFactory.ANIMATION_DATA_FACTORY.registerFactory(OVERLAY_ANIMATION_CONTAINER_LAYER_ID, 2, player -> new PlayerAnimationController(player, (controller, state, animSetter) -> PlayState.STOP));
        PlayerAnimationFactory.ANIMATION_DATA_FACTORY.registerFactory(SPECIAL_ANIMATION_CONTAINER_LAYER_ID, 3, player -> new PlayerAnimationController(player, (controller, state, animSetter) -> PlayState.STOP));
    }

    static Platform xplat() {
        return PLATFORM;
    }

    private static Platform createPlatformInstance() {
        return new FabricPlatform();
    }

    public static Animation getAnimation(String animationId) {
        return PlayerAnimResources.getAnimation((class_2960)ModTemplate.of(animationId));
    }

    public static class_2960 of(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    static {
        MAIN_ANIMATION_CONTAINER_LAYER_ID = ModTemplate.of("main_animation_container");
        OVERLAY_ANIMATION_CONTAINER_LAYER_ID = ModTemplate.of("overlay_animation_container");
        SPECIAL_ANIMATION_CONTAINER_LAYER_ID = ModTemplate.of("special_animation_container");
        PLATFORM = ModTemplate.createPlatformInstance();
    }
}

