/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.animation.animations.overlay;

import com.github.razorplay01.cpa.CustomPlayerAnimations;
import com.github.razorplay01.cpa.animation.AnimationContainer;
import com.github.razorplay01.cpa.util.Util;
import com.github.razorplay01.cpa.util.enums.AnimationsId;
import com.github.razorplay01.cpa.util.enums.BodyParts;
import com.github.razorplay01.cpa.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.util.records.AnimationContext;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.RawAnimation;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractFadeModifier;
import com.zigythebird.playeranimcore.bones.AdvancedPlayerAnimBone;
import com.zigythebird.playeranimcore.easing.EasingType;
import net.minecraft.class_1306;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_572;

public class CrossbowAnimation
implements ICustomAnimation {
    private boolean wasMainArmDisabled = false;
    private boolean wasOffArmDisabled = false;
    private class_1799 lastMainHandItem = class_1799.field_8037;
    private class_1799 lastOffHandItem = class_1799.field_8037;
    private boolean needToForceEnableMainArm = false;
    private boolean needToForceEnableOffArm = false;
    private BodyParts mainArmToEnable = null;
    private BodyParts offArmToEnable = null;

    @Override
    public void playAnimation(AnimationContext context) {
        if (this.needToForceEnableMainArm && this.mainArmToEnable != null) {
            this.forceEnableBodyPart(context, this.mainArmToEnable);
            this.needToForceEnableMainArm = false;
            this.mainArmToEnable = null;
        }
        if (this.needToForceEnableOffArm && this.offArmToEnable != null) {
            this.forceEnableBodyPart(context, this.offArmToEnable);
            this.needToForceEnableOffArm = false;
            this.offArmToEnable = null;
        }
        if (context.avatar().method_6115() && context.avatar().method_6030().method_7909() instanceof class_1764) {
            Util.disableBothArms(context);
            this.wasMainArmDisabled = true;
            this.wasOffArmDisabled = true;
            return;
        }
        class_1799 currentMainHandItem = context.avatar().method_6047();
        class_1799 currentOffHandItem = context.avatar().method_6079();
        if (context.playerData().getMainArmPose().equals((Object)class_572.class_573.field_3408)) {
            context.iAnimationControl().disableBodyPartAnimationInAllContainers(context.avatar().method_6068() == class_1306.field_6183 ? BodyParts.RIGHT_ARM : BodyParts.LEFT_ARM);
            this.wasMainArmDisabled = true;
        } else if (!(!this.wasMainArmDisabled || currentMainHandItem.method_7909() instanceof class_1764 && currentMainHandItem.equals(this.lastMainHandItem))) {
            this.wasMainArmDisabled = false;
            this.needToForceEnableMainArm = true;
            this.mainArmToEnable = context.avatar().method_6068() == class_1306.field_6183 ? BodyParts.RIGHT_ARM : BodyParts.LEFT_ARM;
            this.forceEnableBodyPart(context, this.mainArmToEnable);
        }
        if (context.playerData().getOffArmPose().equals((Object)class_572.class_573.field_3408)) {
            context.iAnimationControl().disableBodyPartAnimationInAllContainers(context.avatar().method_6068() == class_1306.field_6183 ? BodyParts.LEFT_ARM : BodyParts.RIGHT_ARM);
            this.wasOffArmDisabled = true;
        } else if (!(!this.wasOffArmDisabled || currentOffHandItem.method_7909() instanceof class_1764 && currentOffHandItem.equals(this.lastOffHandItem))) {
            this.wasOffArmDisabled = false;
            this.needToForceEnableOffArm = true;
            this.offArmToEnable = context.avatar().method_6068() == class_1306.field_6183 ? BodyParts.LEFT_ARM : BodyParts.RIGHT_ARM;
            this.forceEnableBodyPart(context, this.offArmToEnable);
        }
        this.lastMainHandItem = currentMainHandItem.method_7972();
        this.lastOffHandItem = currentOffHandItem.method_7972();
    }

    @Override
    public boolean shouldPlayAnimation(AnimationContext context) {
        boolean holdingCrossbow = context.avatar().method_6047().method_7909() instanceof class_1764 || context.avatar().method_6079().method_7909() instanceof class_1764;
        return holdingCrossbow || this.wasMainArmDisabled || this.wasOffArmDisabled;
    }

    private void forceEnableBodyPart(AnimationContext context, BodyParts bodyPart) {
        String partIdToEnable = bodyPart.getPartId();
        context.mainAnimationContainer().getDisabledBoneIds().remove(partIdToEnable);
        context.overlayAnimationContainer().getDisabledBoneIds().remove(partIdToEnable);
        context.specialAnimationContainer().getDisabledBoneIds().remove(partIdToEnable);
        this.forceAnimationChange(context);
        this.updateAnimationController(context.mainAnimationContainer(), partIdToEnable);
        this.updateAnimationController(context.overlayAnimationContainer(), partIdToEnable);
        this.updateAnimationController(context.specialAnimationContainer(), partIdToEnable);
    }

    private void updateAnimationController(AnimationContainer container, String partIdToEnable) {
        container.getAnimationController().setPostAnimationSetupConsumer(getBoneFunc -> {
            ((AdvancedPlayerAnimBone)getBoneFunc.apply(partIdToEnable)).setEnabled(true);
            for (String boneId : container.getDisabledBoneIds()) {
                if (boneId.equals(partIdToEnable)) continue;
                ((AdvancedPlayerAnimBone)getBoneFunc.apply(boneId)).setEnabled(false);
            }
        });
    }

    private void forceAnimationChange(AnimationContext context) {
        Animation currentMainAnimation = context.mainAnimationContainer().getAnimationController().getCurrentAnimation().animation();
        Animation currentOverlayAnimation = context.overlayAnimationContainer().getAnimationController().getCurrentAnimation().animation();
        Animation currentSpecialAnimation = context.specialAnimationContainer().getAnimationController().getCurrentAnimation().animation();
        RawAnimation blankAnimation = RawAnimation.begin().thenPlay(CustomPlayerAnimations.getAnimation(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId()));
        context.mainAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)1, (EasingType)EasingType.EASE_IN_OUT_SINE), blankAnimation, false);
        context.overlayAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)1, (EasingType)EasingType.EASE_IN_OUT_SINE), blankAnimation, false);
        context.specialAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)1, (EasingType)EasingType.EASE_IN_OUT_SINE), blankAnimation, false);
        if (currentMainAnimation != null) {
            context.mainAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)2, (EasingType)EasingType.EASE_IN_OUT_SINE), currentMainAnimation, false);
        }
        if (currentOverlayAnimation != null) {
            context.overlayAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)2, (EasingType)EasingType.EASE_IN_OUT_SINE), currentOverlayAnimation, false);
        }
        if (currentSpecialAnimation != null) {
            context.specialAnimationContainer().getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)2, (EasingType)EasingType.EASE_IN_OUT_SINE), currentSpecialAnimation, false);
        }
    }
}

