/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.util;

import com.github.razorplay01.cpa.animation.AnimationContainer;
import com.github.razorplay01.cpa.util.Util;
import com.github.razorplay01.cpa.util.enums.BodyParts;
import com.zigythebird.playeranimcore.animation.layered.modifier.AdjustmentModifier;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonMode;
import com.zigythebird.playeranimcore.math.Vec3f;
import java.util.Optional;
import net.minecraft.class_11890;
import net.minecraft.class_1306;
import net.minecraft.class_1753;
import net.minecraft.class_1819;

public class CustomModifiers {
    private CustomModifiers() {
    }

    public static AdjustmentModifier createBowModifier(class_11890 avatar) {
        return new AdjustmentModifier(partName -> {
            boolean isUsingBow;
            boolean bl = isUsingBow = avatar.method_6115() && avatar.method_6030().method_7909() instanceof class_1753;
            if (!isUsingBow) {
                return Optional.empty();
            }
            boolean isRight = !(avatar.method_6068() == class_1306.field_6183 && avatar.method_6079().method_7909() instanceof class_1753 || avatar.method_6068() == class_1306.field_6182 && avatar.method_6047().method_7909() instanceof class_1753);
            float pitch = (float)Math.toRadians(avatar.method_36455());
            if (partName.equals(BodyParts.RIGHT_ARM.getPartId()) || partName.equals(BodyParts.LEFT_ARM.getPartId())) {
                return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(0.0f, 0.0f, isRight ? -pitch : pitch), new Vec3f(0.0f, pitch, 0.0f)));
            }
            return Optional.empty();
        });
    }

    public static AdjustmentModifier createShieldModifier(class_11890 avatar) {
        return new AdjustmentModifier(partName -> {
            boolean isUsingShield;
            boolean bl = isUsingShield = avatar.method_6115() && avatar.method_6030().method_7909() instanceof class_1819;
            if (!isUsingShield) {
                return Optional.empty();
            }
            float limitedPitch = Math.clamp(avatar.method_36455(), -45.0f, 45.0f);
            float pitch = (float)Math.toRadians(limitedPitch) * 0.5f;
            if (partName.equals(BodyParts.LEFT_ARM.getPartId()) || partName.equals(BodyParts.RIGHT_ARM.getPartId())) {
                return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(pitch, 0.0f, 0.0f), Vec3f.ZERO));
            }
            return Optional.empty();
        });
    }

    public static AdjustmentModifier createSwingModifier(class_11890 avatar, AnimationContainer animationContainer) {
        return new AdjustmentModifier(partName -> {
            if (!Util.isSwingingSwordOrTools(avatar, animationContainer)) {
                return Optional.empty();
            }
            float pitchRadians = (float)Math.toRadians(avatar.method_36455());
            if (FirstPersonMode.isFirstPersonPass()) {
                return Util.handleFirstPersonPass(partName, pitchRadians);
            }
            return Util.handleThirdPersonPass(partName, pitchRadians);
        });
    }
}

