/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.util;

import lombok.Generated;
import net.minecraft.class_11890;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_2354;
import net.minecraft.class_2389;
import net.minecraft.class_243;
import net.minecraft.class_2544;
import net.minecraft.class_572;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PlayerData {
    private class_243 playerPosition;
    private class_243 prevPlayerPosition = new class_243(0.0, 0.0, 0.0);
    private double movementSpeed = 0.0;
    private float playerHeadYaw = 0.0f;
    private float playerBodyYaw = 0.0f;
    private float prevPlayerBodyYaw = 0.0f;
    private float bodyYawDelta = 0.0f;
    private float vectorX = 0.0f;
    private float vectorY = 0.0f;
    private float vectorZ = 0.0f;
    private int flychecker = 0;
    private boolean isMovingBackwards = false;
    private boolean isOnFence = false;
    private boolean isOnEdge = false;
    private boolean prevOnGround = false;
    private class_1268 rightHand = class_1268.field_5808;
    private class_1268 leftHand = class_1268.field_5810;
    private class_572.class_573 mainArmPose = class_572.class_573.field_3409;
    private class_572.class_573 offArmPose = class_572.class_573.field_3409;
    private class_1799 mainHandItem = class_1799.field_8037;
    private class_1799 offHandItem = class_1799.field_8037;
    private int movementTicks;
    private boolean prevMainHandUp = false;
    private boolean prevOffHandUp = false;

    public void update(class_11890 player) {
        if (player == null) {
            return;
        }
        this.updateHandOrientation(player.method_6068());
        this.updatePlayerPosition(player.method_5791(), player.method_73188(), player.method_73189());
        this.updateMovementInfo(player.field_6283);
        this.updateEnvironmentInfo(player);
        this.updateFlyChecker(player);
        this.updateMovementTicks(player);
    }

    private void updateMovementTicks(class_11890 avatar) {
        if (this.getMovementSpeed() > 0.0 && !this.isMovingBackwards() && !avatar.method_18276() && !avatar.method_5765()) {
            this.setMovementTicks(this.getMovementTicks() + 1);
        } else {
            this.setMovementTicks(0);
        }
    }

    private void updateHandOrientation(class_1306 mainHand) {
        if (mainHand == class_1306.field_6183) {
            this.setRightHand(class_1268.field_5808);
            this.setLeftHand(class_1268.field_5810);
        } else {
            this.setRightHand(class_1268.field_5810);
            this.setLeftHand(class_1268.field_5808);
        }
    }

    private void updatePlayerPosition(float headYRot, float visualRotationYInDegress, class_243 playerPosition) {
        this.setPlayerBodyYaw(visualRotationYInDegress);
        this.setPlayerHeadYaw(headYRot);
        this.setPlayerPosition(playerPosition);
        this.setVectorX((float)(this.getPlayerPosition().field_1352 - this.getPrevPlayerPosition().field_1352));
        this.setVectorY((float)(this.getPlayerPosition().field_1351 - this.getPrevPlayerPosition().field_1351));
        this.setVectorZ((float)(this.getPlayerPosition().field_1350 - this.getPrevPlayerPosition().field_1350));
        this.setMovementSpeed(Math.sqrt(this.getVectorX() * this.getVectorX() + this.getVectorZ() * this.getVectorZ()));
        this.setBodyYawDelta(this.getPlayerBodyYaw() - this.getPrevPlayerBodyYaw());
    }

    private void updateMovementInfo(float yBodyRot) {
        double bodyYawRadians = Math.toRadians(yBodyRot + 90.0f);
        Vector3f movementVector = new Vector3f(this.getVectorX(), 0.0f, this.getVectorZ());
        Vector3f lookVector = new Vector3f((float)Math.cos(bodyYawRadians), 0.0f, (float)Math.sin(bodyYawRadians));
        this.setMovingBackwards(movementVector.length() > 0.0f && movementVector.dot((Vector3fc)lookVector) < 0.0f);
    }

    private void updateEnvironmentInfo(class_11890 avatar) {
        class_2248 standingBlock = avatar.method_73183().method_8320(avatar.method_24515().method_10074()).method_26204();
        this.setOnFence((standingBlock instanceof class_2354 || standingBlock instanceof class_2544 || standingBlock instanceof class_2389) && avatar.method_24828());
        this.setOnEdge(standingBlock instanceof class_2189 && avatar.method_24828());
    }

    private void updateFlyChecker(class_11890 avatar) {
        double flyVectorY = (double)Math.round((double)this.getVectorY() * 1000.0) / 1000.0;
        if (!(flyVectorY != 0.0 && Math.abs(flyVectorY) != 0.375 || avatar.method_24828() || avatar.method_5869())) {
            this.setFlychecker(this.getFlychecker() + 1);
        } else if (Math.abs(flyVectorY) > 0.375 || avatar.method_24828()) {
            this.setFlychecker(0);
        }
    }

    public boolean getPrevMainHandUp() {
        return this.prevMainHandUp;
    }

    public boolean getPrevOffHandUp() {
        return this.prevOffHandUp;
    }

    @Generated
    public class_243 getPlayerPosition() {
        return this.playerPosition;
    }

    @Generated
    public class_243 getPrevPlayerPosition() {
        return this.prevPlayerPosition;
    }

    @Generated
    public double getMovementSpeed() {
        return this.movementSpeed;
    }

    @Generated
    public float getPlayerHeadYaw() {
        return this.playerHeadYaw;
    }

    @Generated
    public float getPlayerBodyYaw() {
        return this.playerBodyYaw;
    }

    @Generated
    public float getPrevPlayerBodyYaw() {
        return this.prevPlayerBodyYaw;
    }

    @Generated
    public float getBodyYawDelta() {
        return this.bodyYawDelta;
    }

    @Generated
    public float getVectorX() {
        return this.vectorX;
    }

    @Generated
    public float getVectorY() {
        return this.vectorY;
    }

    @Generated
    public float getVectorZ() {
        return this.vectorZ;
    }

    @Generated
    public int getFlychecker() {
        return this.flychecker;
    }

    @Generated
    public boolean isMovingBackwards() {
        return this.isMovingBackwards;
    }

    @Generated
    public boolean isOnFence() {
        return this.isOnFence;
    }

    @Generated
    public boolean isOnEdge() {
        return this.isOnEdge;
    }

    @Generated
    public boolean isPrevOnGround() {
        return this.prevOnGround;
    }

    @Generated
    public class_1268 getRightHand() {
        return this.rightHand;
    }

    @Generated
    public class_1268 getLeftHand() {
        return this.leftHand;
    }

    @Generated
    public class_572.class_573 getMainArmPose() {
        return this.mainArmPose;
    }

    @Generated
    public class_572.class_573 getOffArmPose() {
        return this.offArmPose;
    }

    @Generated
    public class_1799 getMainHandItem() {
        return this.mainHandItem;
    }

    @Generated
    public class_1799 getOffHandItem() {
        return this.offHandItem;
    }

    @Generated
    public int getMovementTicks() {
        return this.movementTicks;
    }

    @Generated
    public void setPlayerPosition(class_243 playerPosition) {
        this.playerPosition = playerPosition;
    }

    @Generated
    public void setPrevPlayerPosition(class_243 prevPlayerPosition) {
        this.prevPlayerPosition = prevPlayerPosition;
    }

    @Generated
    public void setMovementSpeed(double movementSpeed) {
        this.movementSpeed = movementSpeed;
    }

    @Generated
    public void setPlayerHeadYaw(float playerHeadYaw) {
        this.playerHeadYaw = playerHeadYaw;
    }

    @Generated
    public void setPlayerBodyYaw(float playerBodyYaw) {
        this.playerBodyYaw = playerBodyYaw;
    }

    @Generated
    public void setPrevPlayerBodyYaw(float prevPlayerBodyYaw) {
        this.prevPlayerBodyYaw = prevPlayerBodyYaw;
    }

    @Generated
    public void setBodyYawDelta(float bodyYawDelta) {
        this.bodyYawDelta = bodyYawDelta;
    }

    @Generated
    public void setVectorX(float vectorX) {
        this.vectorX = vectorX;
    }

    @Generated
    public void setVectorY(float vectorY) {
        this.vectorY = vectorY;
    }

    @Generated
    public void setVectorZ(float vectorZ) {
        this.vectorZ = vectorZ;
    }

    @Generated
    public void setFlychecker(int flychecker) {
        this.flychecker = flychecker;
    }

    @Generated
    public void setMovingBackwards(boolean isMovingBackwards) {
        this.isMovingBackwards = isMovingBackwards;
    }

    @Generated
    public void setOnFence(boolean isOnFence) {
        this.isOnFence = isOnFence;
    }

    @Generated
    public void setOnEdge(boolean isOnEdge) {
        this.isOnEdge = isOnEdge;
    }

    @Generated
    public void setPrevOnGround(boolean prevOnGround) {
        this.prevOnGround = prevOnGround;
    }

    @Generated
    public void setRightHand(class_1268 rightHand) {
        this.rightHand = rightHand;
    }

    @Generated
    public void setLeftHand(class_1268 leftHand) {
        this.leftHand = leftHand;
    }

    @Generated
    public void setMainArmPose(class_572.class_573 mainArmPose) {
        this.mainArmPose = mainArmPose;
    }

    @Generated
    public void setOffArmPose(class_572.class_573 offArmPose) {
        this.offArmPose = offArmPose;
    }

    @Generated
    public void setMainHandItem(class_1799 mainHandItem) {
        this.mainHandItem = mainHandItem;
    }

    @Generated
    public void setOffHandItem(class_1799 offHandItem) {
        this.offHandItem = offHandItem;
    }

    @Generated
    public void setMovementTicks(int movementTicks) {
        this.movementTicks = movementTicks;
    }

    @Generated
    public void setPrevMainHandUp(boolean prevMainHandUp) {
        this.prevMainHandUp = prevMainHandUp;
    }

    @Generated
    public void setPrevOffHandUp(boolean prevOffHandUp) {
        this.prevOffHandUp = prevOffHandUp;
    }

    @Generated
    public PlayerData() {
    }
}

