/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.util;

import com.github.razorplay01.cpa.animation.AnimationContainer;
import com.github.razorplay01.cpa.config.ClientConfig;
import com.github.razorplay01.cpa.util.enums.AnimationsId;
import com.github.razorplay01.cpa.util.enums.BodyParts;
import com.github.razorplay01.cpa.util.records.AnimationContext;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.AdjustmentModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.MirrorModifier;
import com.zigythebird.playeranimcore.math.Vec3f;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10590;
import net.minecraft.class_11890;
import net.minecraft.class_1268;
import net.minecraft.class_1495;
import net.minecraft.class_1498;
import net.minecraft.class_1500;
import net.minecraft.class_1506;
import net.minecraft.class_1507;
import net.minecraft.class_1690;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1821;
import net.minecraft.class_1835;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_5134;
import net.minecraft.class_9280;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.class_9424;

public class Util {
    public static final String RIGHT_PREFIX = "right_";
    public static final String LEFT_PREFIX = "left_";

    private Util() {
    }

    public static List<Float> getCustomModelDataId(class_1799 itemStack) {
        return Optional.of(itemStack.method_57380()).map(componentsPatch -> componentsPatch.method_57845(class_9334.field_49637)).flatMap(optional -> optional.map(class_9280::comp_3354)).orElse(List.of(Float.valueOf(0.0f)));
    }

    public static boolean isBoat(Object vehicle) {
        return vehicle instanceof class_1690;
    }

    public static boolean isHorse(Object vehicle) {
        return vehicle instanceof class_1498 || vehicle instanceof class_1506 || vehicle instanceof class_1507 || vehicle instanceof class_1495 || vehicle instanceof class_1500;
    }

    public static void configureAnimationContainer(ClientConfig.AnimationConfig config, AnimationContainer animationContainer) {
        animationContainer.setAnimationSpeed(config.getSpeedMultiplier());
        animationContainer.setAnimationFadeTime(config.getFadeTime());
        animationContainer.setAnimationPriority(config.getPriority());
    }

    public static boolean containsAnyAnimation(AnimationContainer container, List<String> animations) {
        String currentAnimation = container.getCurrentAnimationId();
        if (animations == null || animations.isEmpty()) {
            return false;
        }
        return animations.stream().anyMatch(currentAnimation::contains);
    }

    public static void disableBothArms(AnimationContext context) {
        context.iAnimationControl().disableBodyPartAnimationInAllContainers(BodyParts.LEFT_ARM);
        context.iAnimationControl().disableBodyPartAnimationInAllContainers(BodyParts.RIGHT_ARM);
    }

    public static void addModifiersToContainer(AnimationContainer container) {
        for (AbstractModifier modifier : container.getAnimationModifiers().values()) {
            container.getAnimationController().addModifierLast(modifier);
            if (!(modifier instanceof MirrorModifier)) continue;
            MirrorModifier mirrorModifier = (MirrorModifier)modifier;
            mirrorModifier.enabled = false;
        }
    }

    public static boolean isSwingingSwordOrTools(class_11890 avatar, AnimationContainer animationContainer) {
        return avatar.field_6252 && (avatar.method_6047().method_7909() instanceof class_1821 || avatar.method_6047().method_7909().method_7854().method_57353().method_57832(class_9334.field_50077) || avatar.method_6047().method_7909() instanceof class_1743 || avatar.method_6047().method_7909().method_7854().method_57353().method_57832(class_9334.field_55878) || avatar.method_6047().method_7909() instanceof class_1835) && avatar.field_6266.equals((Object)class_1268.field_5808) && !animationContainer.getCurrentAnimationId().equalsIgnoreCase(AnimationsId.SLEEP_ANIMATION.getAnimationId());
    }

    public static Optional<AdjustmentModifier.PartModifier> handleFirstPersonPass(String partName, float pitchRadians) {
        float xRot = 0.0f;
        float offsetY = 0.0f;
        float offsetZ = 0.0f;
        if (partName.equals("body")) {
            if (pitchRadians < 0.0f) {
                xRot -= pitchRadians;
                float offset = Math.abs((float)Math.sin(pitchRadians));
                offsetY += offset * 0.5f;
                offsetZ -= offset;
            }
        } else if (partName.equals("right_arm") || partName.equals("left_arm")) {
            xRot = pitchRadians;
        } else {
            return Optional.empty();
        }
        return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(xRot, 0.0f, 0.0f), new Vec3f(0.0f, offsetY, offsetZ)));
    }

    public static Optional<AdjustmentModifier.PartModifier> handleThirdPersonPass(String partName, float pitchRadians) {
        float xRot = 0.0f;
        switch (partName) {
            case "right_arm": 
            case "left_arm": {
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(xRot += pitchRadians * 0.5f, 0.0f, 0.0f), new Vec3f(0.0f, 0.0f, 0.0f)));
    }

    public static boolean isSword(class_1799 itemStack) {
        class_10590 weapon = (class_10590)itemStack.method_58694(class_9334.field_55878);
        if (weapon != null) {
            class_9285 attributes = (class_9285)itemStack.method_58694(class_9334.field_49636);
            if (attributes != null) {
                for (class_9285.class_9287 entry : attributes.comp_2393()) {
                    if (!entry.comp_2395().equals((Object)class_5134.field_23721)) continue;
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isShovel(class_1799 itemStack) {
        class_9424 tool = (class_9424)itemStack.method_58694(class_9334.field_50077);
        if (tool != null) {
            class_2680 dirtState = class_2246.field_10566.method_9564();
            return tool.method_58426(dirtState);
        }
        return false;
    }

    public static boolean isPickaxe(class_1799 itemStack) {
        class_9424 tool = (class_9424)itemStack.method_58694(class_9334.field_50077);
        if (tool != null) {
            class_2680 stoneState = class_2246.field_10340.method_9564();
            return tool.method_58426(stoneState);
        }
        return false;
    }

    public static boolean isAxe(class_1799 itemStack) {
        class_9424 tool = (class_9424)itemStack.method_58694(class_9334.field_50077);
        if (tool != null) {
            class_2680 oakLogState = class_2246.field_10431.method_9564();
            return tool.method_58426(oakLogState);
        }
        return false;
    }
}

