/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.mixin;

import com.github.razorplay01.cpa.ModTemplate;
import com.github.razorplay01.cpa.platform.common.animation.AnimationContainer;
import com.github.razorplay01.cpa.platform.common.animation.animations.AnimationProvider;
import com.github.razorplay01.cpa.platform.common.util.CustomModifiers;
import com.github.razorplay01.cpa.platform.common.util.PlayerData;
import com.github.razorplay01.cpa.platform.common.util.Util;
import com.github.razorplay01.cpa.platform.common.util.enums.AnimationsId;
import com.github.razorplay01.cpa.platform.common.util.enums.BodyParts;
import com.github.razorplay01.cpa.platform.common.util.enums.Modifiers;
import com.github.razorplay01.cpa.platform.common.util.interfaces.IAnimationControl;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimatedPlayer;
import com.github.razorplay01.cpa.platform.common.util.interfaces.ICustomAnimation;
import com.github.razorplay01.cpa.platform.common.util.records.AnimationContext;
import com.mojang.authlib.GameProfile;
import com.zigythebird.playeranim.api.PlayerAnimationAccess;
import com.zigythebird.playeranimcore.animation.AnimationController;
import com.zigythebird.playeranimcore.animation.RawAnimation;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractFadeModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.AdjustmentModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.MirrorModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.SpeedModifier;
import com.zigythebird.playeranimcore.bones.AdvancedPlayerAnimBone;
import com.zigythebird.playeranimcore.easing.EasingType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerEntityMixin
extends Player
implements IAnimationControl,
ICustomAnimatedPlayer {
    @Unique
    private AnimationContainer mainAnimationContainer;
    @Unique
    private AnimationContainer overlayAnimationContainer;
    @Unique
    private AnimationContainer specialAnimationContainer;
    @Unique
    private final PlayerData playerData = new PlayerData();
    @Unique
    private AnimationContext actualAnimationContext;

    protected AbstractClientPlayerEntityMixin(Level level, GameProfile gameProfile) {
        super(level, gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(ClientLevel clientLevel, GameProfile gameProfile, CallbackInfo ci) {
        this.mainAnimationContainer = new AnimationContainer((AnimationController)PlayerAnimationAccess.getPlayerAnimationLayer((AbstractClientPlayer)((AbstractClientPlayer)this), (ResourceLocation)ModTemplate.MAIN_ANIMATION_CONTAINER_LAYER_ID), new HashMap<String, SpeedModifier>(Map.of(Modifiers.MIRROR_MODIFIER.getModifierId(), new MirrorModifier(), Modifiers.SPEED_MODIFIER.getModifierId(), new SpeedModifier(1.0f))), ModTemplate.getAnimation(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId()), AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId(), "", 0, 0, 0, 0.0f);
        this.overlayAnimationContainer = new AnimationContainer((AnimationController)PlayerAnimationAccess.getPlayerAnimationLayer((AbstractClientPlayer)((AbstractClientPlayer)this), (ResourceLocation)ModTemplate.OVERLAY_ANIMATION_CONTAINER_LAYER_ID), new HashMap<String, AdjustmentModifier>(Map.of(Modifiers.MIRROR_MODIFIER.getModifierId(), new MirrorModifier(), Modifiers.SPEED_MODIFIER.getModifierId(), new SpeedModifier(1.0f), Modifiers.SHIELD_MODIFIER.getModifierId(), CustomModifiers.createShieldModifier((AbstractClientPlayer)this), Modifiers.HAND_SWING_MODIFIER.getModifierId(), CustomModifiers.createSwingModifier((AbstractClientPlayer)this, this.mainAnimationContainer), Modifiers.BOW_MODIFIER.getModifierId(), CustomModifiers.createBowModifier((AbstractClientPlayer)this))), ModTemplate.getAnimation(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId()), AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId(), "", 0, 0, 0, 0.0f);
        this.specialAnimationContainer = new AnimationContainer((AnimationController)PlayerAnimationAccess.getPlayerAnimationLayer((AbstractClientPlayer)((AbstractClientPlayer)this), (ResourceLocation)ModTemplate.SPECIAL_ANIMATION_CONTAINER_LAYER_ID), new HashMap<String, SpeedModifier>(Map.of(Modifiers.MIRROR_MODIFIER.getModifierId(), new MirrorModifier(), Modifiers.SPEED_MODIFIER.getModifierId(), new SpeedModifier(1.0f))), ModTemplate.getAnimation(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId()), AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId(), "", 0, 0, 0, 0.0f);
        Util.addModifiersToContainer(this.mainAnimationContainer);
        Util.addModifiersToContainer(this.overlayAnimationContainer);
        Util.addModifiersToContainer(this.specialAnimationContainer);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        if (this.mainAnimationContainer == null || this.overlayAnimationContainer == null || this.specialAnimationContainer == null) {
            return;
        }
        this.playerData.update((AbstractClientPlayer)this);
        this.enableAllBodyPartsInAllContainers();
        this.overlayAnimationContainer.resetAnimationProperties();
        this.actualAnimationContext = new AnimationContext(this.mainAnimationContainer, this.overlayAnimationContainer, this.specialAnimationContainer, (AbstractClientPlayer)this, this.playerData, this, this);
        this.playAnimations();
        this.updateAnimationSpeeds();
        this.checkMainHandItemForArmDisabling();
        this.checkOffHandItemForArmDisabling();
        this.applyDisables();
        this.updateAnimationContainers();
        this.playerData.setPrevPlayerPosition(this.playerData.getPlayerPosition());
        this.playerData.setPrevPlayerBodyYaw(this.playerData.getPlayerBodyYaw());
        this.playerData.setPrevOnGround(this.onGround());
    }

    @Override
    public AnimationContainer getMainAnimationCPA() {
        return this.mainAnimationContainer;
    }

    @Override
    public AnimationContainer getOverlayAnimationCPA() {
        return this.overlayAnimationContainer;
    }

    @Override
    public AnimationContainer getSpecialAnimationCPA() {
        return this.specialAnimationContainer;
    }

    @Override
    public AnimationContext getAnimationContext() {
        return this.actualAnimationContext;
    }

    @Override
    public void disableBodyPartAnimation(AnimationContainer animationContainer, BodyParts bodyPart) {
        animationContainer.getDisabledBoneIds().add(bodyPart.getPartId());
    }

    @Unique
    public void enabledAllBodyPartsAnimation(AnimationContainer animationContainer) {
        animationContainer.getAnimationController().setPostAnimationSetupConsumer(getBoneFunc -> {});
        animationContainer.getDisabledBoneIds().clear();
    }

    @Override
    public void disableBodyPartAnimationInAllContainers(BodyParts bodyPart) {
        this.disableBodyPartAnimation(this.actualAnimationContext.mainAnimationContainer(), bodyPart);
        this.disableBodyPartAnimation(this.actualAnimationContext.overlayAnimationContainer(), bodyPart);
        this.disableBodyPartAnimation(this.actualAnimationContext.specialAnimationContainer(), bodyPart);
    }

    @Override
    public void disableActiveArm(AnimationContainer animationContainer) {
        if (this.actualAnimationContext.player().getUsedItemHand().equals((Object)InteractionHand.MAIN_HAND)) {
            this.disableBodyPartAnimation(animationContainer, this.actualAnimationContext.player().getMainArm() == HumanoidArm.RIGHT ? BodyParts.RIGHT_ARM : BodyParts.LEFT_ARM);
        } else {
            this.disableBodyPartAnimation(animationContainer, this.actualAnimationContext.player().getMainArm() == HumanoidArm.RIGHT ? BodyParts.LEFT_ARM : BodyParts.RIGHT_ARM);
        }
    }

    @Override
    public HumanoidModel.ArmPose getMainArmPose() {
        return this.playerData.getMainArmPose();
    }

    @Override
    public void setMainArmPose(HumanoidModel.ArmPose armPosition) {
        this.playerData.setMainArmPose(armPosition);
    }

    @Override
    public HumanoidModel.ArmPose getOffArmPose() {
        return this.playerData.getOffArmPose();
    }

    @Override
    public void setOffArmPose(HumanoidModel.ArmPose armPosition) {
        this.playerData.setOffArmPose(armPosition);
    }

    @Unique
    private void updateAnimationSpeeds() {
        ((SpeedModifier)this.mainAnimationContainer.getAnimationModifiers().get((Object)Modifiers.SPEED_MODIFIER.getModifierId())).speed = this.mainAnimationContainer.getAnimationSpeed() * ModTemplate.CONFIG.getGeneral().getAnimationSpeedMultiplier();
        ((SpeedModifier)this.overlayAnimationContainer.getAnimationModifiers().get((Object)Modifiers.SPEED_MODIFIER.getModifierId())).speed = this.overlayAnimationContainer.getAnimationSpeed() * ModTemplate.CONFIG.getGeneral().getAnimationSpeedMultiplier();
        ((SpeedModifier)this.specialAnimationContainer.getAnimationModifiers().get((Object)Modifiers.SPEED_MODIFIER.getModifierId())).speed = this.specialAnimationContainer.getAnimationSpeed() * ModTemplate.CONFIG.getGeneral().getAnimationSpeedMultiplier();
    }

    @Unique
    private void enableAllBodyPartsInAllContainers() {
        this.enabledAllBodyPartsAnimation(this.mainAnimationContainer);
        this.enabledAllBodyPartsAnimation(this.overlayAnimationContainer);
        this.enabledAllBodyPartsAnimation(this.specialAnimationContainer);
    }

    @Unique
    private void applyDisables() {
        this.applyDisableToContainer(this.mainAnimationContainer);
        this.applyDisableToContainer(this.overlayAnimationContainer);
        this.applyDisableToContainer(this.specialAnimationContainer);
    }

    @Unique
    private void applyDisableToContainer(AnimationContainer container) {
        Set<String> disabledIds = container.getDisabledBoneIds();
        if (disabledIds.isEmpty()) {
            container.getAnimationController().setPostAnimationSetupConsumer(getBoneFunc -> {});
        } else {
            container.getAnimationController().setPostAnimationSetupConsumer(getBoneFunc -> {
                for (String boneId : disabledIds) {
                    ((AdvancedPlayerAnimBone)getBoneFunc.apply(boneId)).setEnabled(false);
                }
            });
        }
    }

    @Unique
    private void playAnimations() {
        for (ICustomAnimation animation : AnimationProvider.MAIN_ANIMATIONS) {
            if (!animation.shouldPlayAnimation(this.actualAnimationContext)) continue;
            animation.playAnimation(this.actualAnimationContext);
        }
        for (ICustomAnimation animation : AnimationProvider.OVERLAY_ANIMATIONS) {
            if (!animation.shouldPlayAnimation(this.actualAnimationContext)) continue;
            animation.playAnimation(this.actualAnimationContext);
        }
        for (ICustomAnimation animation : AnimationProvider.SPECIAL_ANIMATIONS) {
            if (!animation.shouldPlayAnimation(this.actualAnimationContext)) continue;
            animation.playAnimation(this.actualAnimationContext);
        }
    }

    @Unique
    private void updateAnimationContainers() {
        this.updateAnimationContainer(this.mainAnimationContainer);
        this.updateAnimationContainer(this.overlayAnimationContainer);
        this.updateAnimationContainer(this.specialAnimationContainer);
    }

    @Unique
    private void updateAnimationContainer(AnimationContainer animationContainer) {
        if (!animationContainer.getAnimationController().isActive() && !animationContainer.getCurrentAnimationId().equals(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId())) {
            animationContainer.setCurrentAnimation(ModTemplate.getAnimation(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId()));
            animationContainer.setCurrentAnimationId(AnimationsId.BLANK_LOOP_ANIMATION.getAnimationId());
            animationContainer.setAnimationPriority(0);
            animationContainer.setAnimationFadeTime(0);
            animationContainer.setAnimationSpeed(1.0f);
        }
        if (!Objects.equals(animationContainer.getCurrentAnimationId(), animationContainer.getPrevAnimationId()) && animationContainer.getAnimationPriority() >= animationContainer.getPrevAnimationPriority() || !animationContainer.getAnimationController().isActive()) {
            this.playCurrentAnimation(animationContainer);
            animationContainer.setPrevAnimationId(animationContainer.getCurrentAnimationId());
            animationContainer.setPrevAnimationPriority(animationContainer.getAnimationPriority());
        }
    }

    @Unique
    public void playCurrentAnimation(AnimationContainer animationContainer) {
        animationContainer.getAnimationController().replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)((int)((float)animationContainer.getAnimationFadeTime() * ModTemplate.CONFIG.getGeneral().getAnimationFadeTimeMultiplier())), (EasingType)EasingType.EASE_IN_OUT_SINE), RawAnimation.begin().thenPlay(animationContainer.getCurrentAnimation()), false);
    }

    @Unique
    private void checkMainHandItemForArmDisabling() {
        if (!this.getMainHandItem().isEmpty() && this.isUsingItem() && (this.isScoping() || this.getMainHandItem().getItem() instanceof InstrumentItem || this.getMainHandItem().getItem() instanceof BrushItem)) {
            this.disableBodyPartAnimationInAllContainers(this.getMainArm() == HumanoidArm.RIGHT ? BodyParts.RIGHT_ARM : BodyParts.LEFT_ARM);
        }
    }

    @Unique
    private void checkOffHandItemForArmDisabling() {
        if (!this.getOffhandItem().isEmpty() && this.isUsingItem() && (this.isScoping() || this.getOffhandItem().getItem() instanceof InstrumentItem || this.getOffhandItem().getItem() instanceof BrushItem)) {
            this.disableBodyPartAnimationInAllContainers(this.getMainArm() == HumanoidArm.RIGHT ? BodyParts.LEFT_ARM : BodyParts.RIGHT_ARM);
        }
    }
}

