/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.cpa.mixin;

import com.github.razorplay01.cpa.platform.common.util.MapRenderer;
import com.github.razorplay01.cpa.platform.common.util.interfaces.HumanoidRenderStateAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandLayer.class})
public abstract class ItemInHandLayerMixin<S extends ArmedEntityRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    protected ItemInHandLayerMixin(RenderLayerParent<S, M> renderLayerParent) {
        super(renderLayerParent);
    }

    @Inject(method={"renderArmWithItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderArmWithItem(S armedEntityRenderState, ItemStackRenderState itemStackRenderState, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        if (!(armedEntityRenderState instanceof PlayerRenderState)) {
            return;
        }
        PlayerRenderState playerRenderState = (PlayerRenderState)armedEntityRenderState;
        LivingEntity livingEntity = ((HumanoidRenderStateAccessor)playerRenderState).getLivingEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        this.onRenderItem(livingEntity, this.getParentModel(), humanoidArm, poseStack, multiBufferSource, i, ci);
    }

    @Unique
    public void onRenderItem(LivingEntity entity, EntityModel<?> model, HumanoidArm arm, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo info) {
        ItemStack heldItem;
        if (!(model instanceof HumanoidModel)) {
            return;
        }
        HumanoidModel humanoid = (HumanoidModel)model;
        if (!this.isArmVisible(humanoid, arm)) {
            return;
        }
        boolean isMainHand = arm == entity.getMainArm();
        ItemStack itemStack = heldItem = isMainHand ? entity.getMainHandItem() : entity.getOffhandItem();
        if (heldItem.getItem().equals(Items.FILLED_MAP)) {
            this.renderMapInHand(humanoid, arm, matrices, vertexConsumers, light, heldItem);
            info.cancel();
        }
    }

    @Unique
    private boolean isArmVisible(HumanoidModel<?> humanoid, HumanoidArm arm) {
        return arm == HumanoidArm.RIGHT && humanoid.rightArm.visible || arm == HumanoidArm.LEFT && humanoid.leftArm.visible;
    }

    @Unique
    private void renderMapInHand(HumanoidModel<?> humanoid, HumanoidArm arm, PoseStack matrices, MultiBufferSource vertexConsumers, int light, ItemStack itemStack) {
        matrices.pushPose();
        humanoid.translateToHand(arm, matrices);
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(200.0f));
        boolean isLeftHand = arm == HumanoidArm.LEFT;
        matrices.translate((double)((float)(isLeftHand ? -1 : 1) / 16.0f), 0.125, -0.625);
        MapRenderer.renderFirstPersonMap(matrices, vertexConsumers, light, itemStack);
        matrices.popPose();
    }
}

